/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.util.Version;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GWCServiceDescriptionProvider
extends ServiceDescriptionProvider {
    public static final String SERVICE_TYPE = "WMTS";
    private final GWC gwc;
    GeoServer geoserver;
    Catalog catalog;

    public GWCServiceDescriptionProvider(GWC gwc, GeoServer gs) {
        this.gwc = gwc;
        this.geoserver = gs;
        this.catalog = gs.getCatalog();
    }

    protected WMTSInfo info(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        WMTSInfo info = null;
        if (workspaceInfo != null) {
            info = (WMTSInfo)this.geoserver.getService(workspaceInfo, WMTSInfo.class);
        }
        if (info == null) {
            info = (WMTSInfo)this.geoserver.getService(WMTSInfo.class);
        }
        return info;
    }

    protected boolean isAvailable(String serviceType, ServiceInfo info, PublishedInfo layerInfo) {
        if (layerInfo != null && !layerInfo.isEnabled()) {
            return false;
        }
        return info.isEnabled();
    }

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        WMTSInfo info = this.info(workspaceInfo, layerInfo);
        if (workspaceInfo != null || this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            descriptions.add(this.description(SERVICE_TYPE, (ServiceInfo)info, workspaceInfo, layerInfo));
        }
        return descriptions;
    }

    private String createLinkWMSC(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        if (workspaceInfo == null && layerInfo == null) {
            return "../gwc/service/wms?service=WMS&version=1.1.1&request=GetCapabilities&tiled=true";
        }
        if (workspaceInfo != null && layerInfo != null) {
            return "../" + workspaceInfo.getName() + "/" + layerInfo.getName() + "/gwc/service/wms?service=WMS&version=1.1.1&request=GetCapabilities&tiled=true";
        }
        if (workspaceInfo != null) {
            return "../" + workspaceInfo.getName() + "/gwc/service/wms?service=WMS&version=1.1.1&request=GetCapabilities&tiled=true";
        }
        return "../" + layerInfo.getName() + "/gwc/service/wms?service=WMS&version=1.1.1&request=GetCapabilities&tiled=true";
    }

    private String createLinkWMTS(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        if (workspaceInfo == null && layerInfo == null) {
            return "../gwc/service/wmts?service=WMTS&version=1.1.1&request=GetCapabilities";
        }
        if (workspaceInfo != null && layerInfo != null) {
            return "../" + workspaceInfo.getName() + "/" + layerInfo.getName() + "/gwc/service/wmts?service=WMTS&version=1.1.1&request=GetCapabilities";
        }
        if (workspaceInfo != null) {
            return "../" + workspaceInfo.getName() + "/gwc/service/wmts?service=WMTS&version=1.1.1&request=GetCapabilities";
        }
        return "../" + layerInfo.getName() + "/gwc/service/wmts?service=WMTS&version=1.1.1&request=GetCapabilities";
    }

    private String createLinkTMS(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        if (workspaceInfo == null && layerInfo == null) {
            return "../gwc/service/tms/1.0.0";
        }
        if (workspaceInfo != null && layerInfo != null) {
            return "../" + workspaceInfo.getName() + "/" + layerInfo.getName() + "/gwc/service/tms/1.0.0";
        }
        if (workspaceInfo != null) {
            return "../" + workspaceInfo.getName() + "/gwc/service/tms/1.0.0";
        }
        return "../" + layerInfo.getName() + "/gwc/service/tms/1.0.0";
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null && !this.geoserver.getGlobal().isGlobalServices().booleanValue()) {
            return links;
        }
        WMTSInfo info = this.info(workspaceInfo, layerInfo);
        GeoServerApplication app = GeoServerApplication.get();
        GWCConfig gwcConfig = this.gwc.getConfig();
        try {
            if (gwcConfig.isWMSCEnabled() && null != app.getBean("gwcServiceWMS")) {
                links.add(new ServiceLinkDescription(SERVICE_TYPE, new Version("1.1.1"), this.createLinkWMSC(workspaceInfo, layerInfo), workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null, "WMS-C"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            if (info.isEnabled() && null != app.getBean("gwcServiceWMTS")) {
                links.add(new ServiceLinkDescription(SERVICE_TYPE, new Version("1.1.1"), this.createLinkWMTS(workspaceInfo, layerInfo), workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null, SERVICE_TYPE));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            if (gwcConfig.isTMSEnabled() && null != app.getBean("gwcServiceTMS")) {
                links.add(new ServiceLinkDescription(SERVICE_TYPE, new Version("1.0.0"), this.createLinkTMS(workspaceInfo, layerInfo), workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null, "TMS"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return links;
    }
}

