/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.SimpleProcessingCollection;
import org.geotools.process.vector.VectorProcess;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@DescribeProcess(title="Buffer", description="Buffers features by a distance value supplied either as a parameter or by a feature attribute. Calculates buffers based on Cartesian distances.")
public class BufferFeatureCollection
implements VectorProcess {
    @DescribeResult(description="Buffered feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="distance", description="Fixed value to use for the buffer distance") Double distance, @DescribeParameter(name="attributeName", description="Attribute containing the buffer distance value", min=0) String attribute) {
        if (distance == null && (attribute == null || attribute == "")) {
            throw new IllegalArgumentException("Buffer distance was not specified");
        }
        if (attribute != null && !"".equals(attribute)) {
            if (((SimpleFeatureType)features.getSchema()).getDescriptor(attribute) == null) {
                boolean found = false;
                for (AttributeDescriptor ad : ((SimpleFeatureType)features.getSchema()).getAttributeDescriptors()) {
                    if (!ad.getLocalName().equals(attribute)) continue;
                    attribute = ad.getLocalName();
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalArgumentException("Attribute not found among the source collection ones: " + attribute);
                }
            }
        } else {
            attribute = null;
        }
        return new BufferedFeatureCollection(features, attribute, distance);
    }

    static class BufferedFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        SimpleFeatureCollection collection;
        Double distance;
        String attribute;
        int count;
        SimpleFeatureBuilder fb;
        SimpleFeature next;

        public BufferedFeatureIterator(SimpleFeatureCollection delegate, String attribute, Double distance, SimpleFeatureType schema) {
            this.delegate = delegate.features();
            this.distance = distance;
            this.collection = delegate;
            this.attribute = attribute;
            this.fb = new SimpleFeatureBuilder(schema);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.delegate.hasNext()) {
                SimpleFeature f = (SimpleFeature)this.delegate.next();
                for (Object value : f.getAttributes()) {
                    if (value instanceof Geometry) {
                        Double fDistance = this.distance;
                        if (this.attribute != null) {
                            fDistance = (Double)Converters.convert((Object)f.getAttribute(this.attribute), Double.class);
                        }
                        if (fDistance != null && fDistance != 0.0) {
                            value = ((Geometry)value).buffer(fDistance.doubleValue());
                        }
                    }
                    this.fb.add(value);
                }
                this.next = this.fb.buildFeature("" + this.count);
                ++this.count;
                this.fb.reset();
            }
            return this.next != null;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("hasNext() returned false!");
            }
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }
    }

    static class BufferedFeatureCollection
    extends SimpleProcessingCollection {
        Double distance;
        String attribute;
        SimpleFeatureCollection delegate;

        public BufferedFeatureCollection(SimpleFeatureCollection delegate, String attribute, Double distance) {
            this.distance = distance;
            this.attribute = attribute;
            this.delegate = delegate;
        }

        @Override
        public SimpleFeatureIterator features() {
            return new BufferedFeatureIterator(this.delegate, this.attribute, this.distance, (SimpleFeatureType)this.getSchema());
        }

        @Override
        public ReferencedEnvelope getBounds() {
            if (this.attribute == null) {
                ReferencedEnvelope re = this.delegate.getBounds();
                re.expandBy(this.distance);
                return re;
            }
            return DataUtilities.bounds(this.features());
        }

        @Override
        protected SimpleFeatureType buildTargetFeatureType() {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor descriptor : ((SimpleFeatureType)this.delegate.getSchema()).getAttributeDescriptors()) {
                if (!(descriptor.getType() instanceof GeometryTypeImpl) || !((SimpleFeatureType)this.delegate.getSchema()).getGeometryDescriptor().equals(descriptor)) {
                    tb.add(descriptor);
                    continue;
                }
                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                builder.setBinding(MultiPolygon.class);
                AttributeDescriptor attributeDescriptor = builder.buildDescriptor(descriptor.getLocalName(), builder.buildType());
                tb.add(attributeDescriptor);
                if (tb.getDefaultGeometry() != null) continue;
                tb.setDefaultGeometry(descriptor.getLocalName());
            }
            tb.setDescription(((SimpleFeatureType)this.delegate.getSchema()).getDescription());
            tb.setCRS(((SimpleFeatureType)this.delegate.getSchema()).getCoordinateReferenceSystem());
            tb.setName(((SimpleFeatureType)this.delegate.getSchema()).getName());
            return tb.buildFeatureType();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

