/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;

public class RequestUtils {
    public static String getRemoteAddr(HttpServletRequest req) {
        String forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            String[] ips = forwardedFor.split(", ");
            return ips[0];
        }
        return req.getRemoteAddr();
    }

    /*
     * WARNING - void declaration
     */
    public static String getVersionPreOws(List<String> providedList, List<String> acceptedList) {
        void var4_14;
        TreeSet<Version> provided = new TreeSet<Version>();
        for (String string : providedList) {
            provided.add(new Version(string));
        }
        if (acceptedList == null || acceptedList.isEmpty()) {
            return ((Version)provided.last()).toString();
        }
        TreeSet<Version> accepted = new TreeSet<Version>();
        for (String string : acceptedList) {
            RequestUtils.checkVersionNumber(string, null);
            accepted.add(new Version(string));
        }
        Iterator iterator = accepted.iterator();
        while (iterator.hasNext()) {
            Version version = (Version)iterator.next();
            if (provided.contains(version)) continue;
            iterator.remove();
        }
        Object var4_7 = null;
        if (!accepted.isEmpty()) {
            String string = ((Version)accepted.last()).toString();
        } else {
            void var4_12;
            for (String v4 : acceptedList) {
                accepted.add(new Version(v4));
            }
            if (((Version)accepted.last()).compareTo((Version)provided.first()) < 0) {
                String string = ((Version)provided.first()).toString();
            }
            if (((Version)accepted.first()).compareTo((Version)provided.last()) > 0) {
                String string = ((Version)provided.last()).toString();
            }
            if (var4_12 == null) {
                Version current;
                Iterator iterator2 = provided.iterator();
                Version last = (Version)iterator2.next();
                while (iterator2.hasNext() && (current = (Version)iterator2.next()).compareTo((Version)accepted.last()) <= 0) {
                    last = current;
                }
                String string = last.toString();
            }
        }
        return var4_14;
    }

    /*
     * WARNING - void declaration
     */
    public static String getVersionOws11(List<String> providedList, List<String> acceptedList) {
        void var4_8;
        TreeSet<Version> provided = new TreeSet<Version>();
        for (String string : providedList) {
            provided.add(new Version(string));
        }
        if (acceptedList == null || acceptedList.isEmpty()) {
            return ((Version)provided.last()).toString();
        }
        ArrayList<Version> accepted = new ArrayList<Version>();
        for (String v : acceptedList) {
            RequestUtils.checkVersionNumber(v, "AcceptVersions");
            accepted.add(new Version(v));
        }
        Object var4_6 = null;
        for (Version version : accepted) {
            if (!provided.contains(version)) continue;
            Version version2 = version;
            break;
        }
        if (var4_8 == null) {
            throw new ServiceException("Could not find any matching version " + acceptedList + " in supported list: " + acceptedList, "VersionNegotiationFailed");
        }
        return var4_8.toString();
    }

    public static void checkVersionNumber(String v, String locator) throws ServiceException {
        if (!v.matches("[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{1,2}")) {
            String msg = v + " is an invalid version number";
            throw new ServiceException(msg, "VersionNegotiationFailed", locator);
        }
    }

    public static BufferedReader getBufferedXMLReader(InputStream stream, int xmlLookahead) throws IOException {
        Reader reader = XmlCharsetDetector.getCharsetAwareReader(stream);
        return RequestUtils.getBufferedXMLReader(reader, xmlLookahead);
    }

    public static BufferedReader getBufferedXMLReader(Reader reader, int xmlLookahead) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader, xmlLookahead);
        }
        reader.mark(xmlLookahead);
        return (BufferedReader)reader;
    }

    public static String[] getLanguageValue(Request request, String languageParamName) {
        String[] result = null;
        if (request != null) {
            result = RequestUtils.getLanguageValue(request.getRawKvp(), languageParamName);
        }
        return result;
    }

    public static String[] getLanguageValue(Map<String, Object> rawKvp, String languageParamName) {
        String acceptLanguages;
        String[] result = null;
        if (rawKvp != null && rawKvp.containsKey(languageParamName) && (acceptLanguages = rawKvp.get(languageParamName).toString()) != null) {
            String[] langAr = acceptLanguages.split(" ");
            if (langAr.length == 1) {
                langAr = acceptLanguages.split(",");
            }
            result = langAr;
        }
        return result;
    }
}

