/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ClassProperties {
    private static final Multimap<String, Method> EMPTY = ImmutableMultimap.of();
    private static final Set<String> COMMON_DERIVED_PROPERTIES = new HashSet<String>(Arrays.asList("prefixedName"));
    Multimap<String, Method> methods = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), () -> new ArrayList());
    Multimap<String, Method> getters = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), () -> new ArrayList());
    Multimap<String, Method> setters = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), () -> new ArrayList());

    public ClassProperties(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            this.methods.put((Object)name, (Object)method);
            Class<?>[] params = method.getParameterTypes();
            if ((name.startsWith("get") || name.startsWith("is") || COMMON_DERIVED_PROPERTIES.contains(name)) && params.length == 0) {
                this.getters.put((Object)this.gp(method), (Object)method);
                continue;
            }
            if (!name.startsWith("set") || params.length != 1) continue;
            this.setters.put((Object)name.substring(3), (Object)method);
        }
        if (this.methods.size() == 0) {
            this.methods = EMPTY;
        }
        if (this.getters.size() == 0) {
            this.getters = EMPTY;
        }
        if (this.setters.size() == 0) {
            this.setters = EMPTY;
        }
    }

    public List<String> properties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (String key : this.getters.keySet()) {
            if (key.equals("Resource")) {
                properties.add(0, key);
                continue;
            }
            properties.add(key);
        }
        return properties;
    }

    public Method setter(String property, Class<?> type) {
        Collection methods = this.setters.get((Object)property);
        for (Method setter : methods) {
            if (type == null) {
                return setter;
            }
            Class<?> target = setter.getParameterTypes()[0];
            if (!target.isAssignableFrom(type) && (!target.isPrimitive() || type != ClassProperties.wrapper(target)) && (!type.isPrimitive() || target != ClassProperties.wrapper(type))) continue;
            return setter;
        }
        String lax = ClassProperties.lax(property);
        if (!lax.equals(property)) {
            return this.setter(lax, type);
        }
        return null;
    }

    public Method getter(String property, Class<?> type) {
        String lax;
        Collection methods = this.getters.get((Object)property);
        if (methods != null) {
            for (Method getter : methods) {
                if (type == null) {
                    return getter;
                }
                Class<?> target = getter.getReturnType();
                if (!type.isAssignableFrom(target) && (!target.isPrimitive() || type != ClassProperties.wrapper(target)) && (!type.isPrimitive() || target != ClassProperties.wrapper(type))) continue;
                return getter;
            }
        }
        if (!(lax = ClassProperties.lax(property)).equals(property)) {
            return this.getter(lax, type);
        }
        return null;
    }

    static String lax(String property) {
        return property.replaceAll("_", "");
    }

    static Class<?> wrapper(Class<?> primitive) {
        if (Boolean.TYPE == primitive) {
            return Boolean.class;
        }
        if (Character.TYPE == primitive) {
            return Character.class;
        }
        if (Byte.TYPE == primitive) {
            return Byte.class;
        }
        if (Short.TYPE == primitive) {
            return Short.class;
        }
        if (Integer.TYPE == primitive) {
            return Integer.class;
        }
        if (Long.TYPE == primitive) {
            return Long.class;
        }
        if (Float.TYPE == primitive) {
            return Float.class;
        }
        if (Double.TYPE == primitive) {
            return Double.class;
        }
        return null;
    }

    public Method method(String name) {
        Collection results = this.methods.get((Object)name);
        if (results.isEmpty()) {
            return null;
        }
        return (Method)results.iterator().next();
    }

    String gp(Method getter) {
        String name = getter.getName();
        if (COMMON_DERIVED_PROPERTIES.contains(name)) {
            return name;
        }
        return name.substring(name.startsWith("get") ? 3 : 2);
    }
}

