/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.kvp.ViewParamsFormatParser;
import org.geoserver.ows.kvp.view.LayerParams;
import org.geoserver.ows.kvp.view.Parameter;
import org.geoserver.ows.kvp.view.ViewParamsRoot;
import org.geoserver.ows.kvp.view.XMLViewParamsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class XMLViewParamsFormatParser
implements ViewParamsFormatParser {
    private static final Logger LOGGER = Logging.getLogger(XMLViewParamsFormatParser.class);
    public static final String XML_IDENTIFIER = "XML";

    @Override
    public String getIdentifier() {
        return XML_IDENTIFIER;
    }

    @Override
    public List<Object> parse(String value) throws Exception {
        ArrayList<Object> resultList = new ArrayList<Object>();
        ViewParamsRoot viewParams = XMLViewParamsUtils.parseViewParams(value);
        for (LayerParams layerParams : viewParams.getLayerParams()) {
            resultList.add(this.parseParams(layerParams));
        }
        return resultList;
    }

    private Map<String, Object> parseParams(LayerParams layerParams) throws Exception {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (Parameter parameter : layerParams.getParameters()) {
            this.parseValue(parameter, paramsMap);
        }
        return paramsMap;
    }

    private void parseValue(Parameter parameter, Map<String, Object> paramsMap) throws Exception {
        KvpParser parser;
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        String key = parameter.getName();
        String raw = StringUtils.isNotBlank((CharSequence)parameter.getValue()) ? parameter.getValue() : "true";
        Object parsed = null;
        Iterator iterator = parsers.iterator();
        while (iterator.hasNext() && (!key.equalsIgnoreCase((parser = (KvpParser)iterator.next()).getKey()) || (parsed = parser.parse(raw)) == null)) {
        }
        if (parsed == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Could not find kvp parser for: '" + key + "'. Storing as raw string.");
            }
            parsed = raw;
        }
        paramsMap.put(key, parsed);
    }
}

