/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.ows.DefaultOutputStrategy;
import org.geoserver.ows.DirectInvocationService;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.DispatcherOutputStream;
import org.geoserver.ows.FileItemCleanupCallback;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.OWS10ServiceExceptionHandler;
import org.geoserver.ows.OWS11ServiceExceptionHandler;
import org.geoserver.ows.OutputStrategyFactory;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.SOAPAwareResponse;
import org.geoserver.ows.SOAPServiceExceptionHandler;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.ServiceStrategy;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xsd.EMFUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class Dispatcher
extends AbstractController {
    static Logger logger = Logging.getLogger((String)"org.geoserver.ows");
    boolean citeCompliant = false;
    public static final ThreadLocal<Request> REQUEST = new InheritableThreadLocal<Request>();
    static final Charset UTF8 = StandardCharsets.UTF_8;
    int XML_LOOKAHEAD = 8192;
    List<DispatcherCallback> callbacks = Collections.emptyList();
    public static final String SOAP_12_NS = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_11_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    static final String SOAP_MIME = "application/soap+xml";
    private Method getEntityResolver = null;

    public Dispatcher() {
        try {
            Class<?> clazz = Class.forName("org.geoserver.util.EntityResolverProvider");
            this.getEntityResolver = clazz.getMethod("getEntityResolver", new Class[0]);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to load EntityResolverProvider. Entity resolution will be enabled: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void setCiteCompliant(boolean citeCompliant) {
        this.citeCompliant = citeCompliant;
    }

    public boolean isCiteCompliant() {
        return this.citeCompliant;
    }

    protected void initApplicationContext(ApplicationContext context) {
        this.callbacks = GeoServerExtensions.extensions(DispatcherCallback.class, (ApplicationContext)context);
        String lookahead = GeoServerExtensions.getProperty((String)"XML_LOOKAHEAD", (ApplicationContext)context);
        if (lookahead != null) {
            try {
                int lookaheadValue = Integer.valueOf(lookahead);
                if (lookaheadValue <= 0) {
                    logger.log(Level.SEVERE, "Invalid XML_LOOKAHEAD value, will use " + this.XML_LOOKAHEAD + " instead");
                }
                this.XML_LOOKAHEAD = lookaheadValue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Invalid XML_LOOKAHEAD value, will use " + this.XML_LOOKAHEAD + " instead");
            }
        }
    }

    protected void preprocessRequest(HttpServletRequest request) throws Exception {
        Charset charSet = UTF8;
        if (request.getCharacterEncoding() != null) {
            try {
                charSet = Charset.forName(request.getCharacterEncoding());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        request.setCharacterEncoding(charSet.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.preprocessRequest(httpRequest);
        Request request = new Request();
        request.setHttpRequest(httpRequest);
        request.setHttpResponse(httpResponse);
        Service service = null;
        try {
            Object result;
            request = this.init(request);
            REQUEST.set(request);
            try {
                service = this.service(request);
            }
            catch (Throwable t) {
                this.exception(t, null, request);
                ModelAndView modelAndView = null;
                this.fireFinishedCallback(request);
                REQUEST.remove();
                return modelAndView;
            }
            if (request.getError() != null) {
                throw request.getError();
            }
            Operation operation = this.dispatch(request, service);
            request.setOperation(operation);
            if (request.isSOAP()) {
                this.flagAsSOAP(operation);
            }
            if ((result = this.execute(request, operation)) != null) {
                this.response(result, request, operation);
            }
        }
        catch (Throwable t) {
            if (Dispatcher.isSecurityException(t)) {
                throw (Exception)t;
            }
            this.exception(t, service, request);
        }
        finally {
            this.fireFinishedCallback(request);
            REQUEST.remove();
        }
        return null;
    }

    void flagAsSOAP(Operation op) {
        for (Object reqObj : op.getParameters()) {
            if (OwsUtils.has(reqObj, "formatOptions")) {
                OwsUtils.put(reqObj, "formatOptions", "SOAP", true);
            }
            if (OwsUtils.has(reqObj, "extendedProperties")) {
                OwsUtils.put(reqObj, "extendedProperties", "SOAP", true);
            }
            if (!OwsUtils.has(reqObj, "metadata")) continue;
            OwsUtils.put(reqObj, "metadata", "SOAP", true);
        }
    }

    void fireFinishedCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            try {
                cb.finished(req);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Error firing finished callback for " + cb.getClass(), t);
            }
        }
    }

    Request init(Request request) throws ServiceException, IOException {
        HttpServletRequest httpRequest = request.getHttpRequest();
        String reqContentType = httpRequest.getContentType();
        request.setGet("GET".equalsIgnoreCase(httpRequest.getMethod()) || this.isForm(reqContentType));
        this.parseKVP(request);
        if (!request.isGet()) {
            if (httpRequest.getContentType() != null && httpRequest.getContentType().startsWith(SOAP_MIME)) {
                request.setSOAP(true);
                request.setInput(this.soapReader(httpRequest, request));
            } else if (reqContentType != null && ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
                ServletFileUpload up = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                CaseInsensitiveMap<String, FileItem> kvpFileItems = new CaseInsensitiveMap<String, FileItem>(new LinkedHashMap());
                try {
                    List items = up.parseRequest(httpRequest);
                    FileItemCleanupCallback.setFileItems(items);
                    FileItem body = null;
                    for (FileItem item : items) {
                        if (item.isFormField()) {
                            FileItem old = kvpFileItems.put(item.getFieldName(), item);
                            if (old == null) continue;
                            old.delete();
                            continue;
                        }
                        if (body != null) {
                            body.delete();
                        }
                        body = item;
                    }
                    if (body == null && (body = (FileItem)kvpFileItems.remove("body")) == null) {
                        throw new IllegalArgumentException("Unable to find input from multipart/form-data content");
                    }
                    request.setInput(this.fileItemReader(body));
                }
                catch (Exception e) {
                    throw new ServiceException("Error handling multipart/form-data content", (Throwable)e);
                }
                LinkedHashMap<String, Object> kvpItems = new LinkedHashMap<String, Object>();
                kvpFileItems.forEach((key, value) -> {
                    kvpItems.put((String)key, value.getString());
                    value.delete();
                });
                request.setOrAppendKvp(this.parseKVP(request, kvpItems));
            } else {
                request.setInput(this.reader(httpRequest));
            }
            if (-1 == request.getInput().read()) {
                request.setInput(null);
            } else {
                request.getInput().reset();
            }
        }
        String ctxPath = request.httpRequest.getContextPath();
        String reqPath = request.httpRequest.getRequestURI();
        if ((reqPath = reqPath.substring(ctxPath.length())).startsWith("/")) {
            reqPath = reqPath.substring(1, reqPath.length());
        }
        if (reqPath.endsWith("/")) {
            reqPath = reqPath.substring(0, reqPath.length() - 1);
        }
        String context = reqPath;
        String path = null;
        int index = context.lastIndexOf(47);
        if (index != -1) {
            path = context.substring(index + 1);
            context = context.substring(0, index);
        } else {
            path = reqPath;
            context = null;
        }
        request.setContext(context);
        request.setPath(path);
        return this.fireInitCallback(request);
    }

    private boolean isForm(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("application/x-www-form-urlencoded");
    }

    Request fireInitCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            Request r = cb.init(req);
            req = r != null ? r : req;
        }
        return req;
    }

    BufferedReader soapReader(HttpServletRequest httpRequest, Request request) throws IOException {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Object provider = GeoServerExtensions.bean((String)"entityResolverProvider");
            if (provider != null && this.getEntityResolver != null) {
                db.setEntityResolver((EntityResolver)this.getEntityResolver.invoke(provider, new Object[0]));
            }
            dom = db.parse((InputStream)httpRequest.getInputStream());
        }
        catch (Exception e) {
            throw new IOException("Error parsing SOAP request", e);
        }
        NodeList list = dom.getElementsByTagNameNS(SOAP_12_NS, "Body");
        if (list.getLength() != 1) {
            list = dom.getElementsByTagNameNS(SOAP_11_NS, "Body");
            if (list.getLength() != 1) {
                throw new IOException("SOAP requests should specify a single Body element");
            }
            request.setSOAPNamespace(SOAP_11_NS);
        } else {
            request.setSOAPNamespace(SOAP_12_NS);
        }
        Element body = (Element)list.item(0);
        Element payload = null;
        for (int i = 0; payload == null && i < body.getChildNodes().getLength(); ++i) {
            Node n = body.getChildNodes().item(i);
            if (!(n instanceof Element)) continue;
            payload = (Element)n;
        }
        if (payload == null) {
            throw new IOException("Could not find payload in SOAP request");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(payload), new StreamResult(bout));
        }
        catch (Exception e) {
            throw new IOException("Error encoding payload of SOAP request", e);
        }
        return RequestUtils.getBufferedXMLReader(new ByteArrayInputStream(bout.toByteArray()), this.XML_LOOKAHEAD);
    }

    BufferedReader reader(HttpServletRequest httpRequest) throws IOException {
        return RequestUtils.getBufferedXMLReader((InputStream)httpRequest.getInputStream(), this.XML_LOOKAHEAD);
    }

    BufferedReader fileItemReader(FileItem fileItem) throws IOException {
        return RequestUtils.getBufferedXMLReader(fileItem.getInputStream(), this.XML_LOOKAHEAD);
    }

    Service service(Request req) throws Exception {
        String service;
        if (req.getKvp() != null) {
            req.setService(Dispatcher.normalize(KvpUtils.getSingleValue(req.getKvp(), "service")));
            req.setVersion(Dispatcher.normalizeVersion(Dispatcher.normalize(KvpUtils.getSingleValue(req.getKvp(), "version"))));
            req.setRequest(Dispatcher.normalize(KvpUtils.getSingleValue(req.getKvp(), "request")));
            req.setOutputFormat(Dispatcher.normalize(KvpUtils.getSingleValue(req.getKvp(), "outputFormat")));
        }
        if (req.getInput() != null && "POST".equalsIgnoreCase(req.getHttpRequest().getMethod())) {
            req = this.readOpPost(req);
        }
        if ((service = req.getService()) == null || req.getRequest() == null) {
            Map<String, String> map = Dispatcher.readOpContext(req);
            if (service == null && (service = Dispatcher.normalize(map.get("service"))) != null && !this.citeCompliant) {
                req.setService(service);
            }
            if (req.getRequest() == null) {
                req.setRequest(Dispatcher.normalize(map.get("request")));
            }
        }
        if (service == null) {
            throw new ServiceException("Could not determine service", "MissingParameterValue", "service");
        }
        Service serviceDescriptor = this.findService(service, req.getVersion(), req.getNamespace());
        if (serviceDescriptor == null) {
            if (req.getContext() != null && (serviceDescriptor = this.findService(req.getContext(), req.getVersion(), req.getNamespace())) != null) {
                if (req.getRequest() == null) {
                    req.setRequest(req.getService());
                }
                req.setService(req.getContext());
                req.setContext(null);
            }
            if (serviceDescriptor == null) {
                String msg = "No service: ( " + service + " )";
                throw new ServiceException(msg, "InvalidParameterValue", "service");
            }
        }
        req.setServiceDescriptor(serviceDescriptor);
        return this.fireServiceDispatchedCallback(req, serviceDescriptor);
    }

    Service fireServiceDispatchedCallback(Request req, Service service) {
        for (DispatcherCallback cb : this.callbacks) {
            Service s = cb.serviceDispatched(req, service);
            service = s != null ? s : service;
        }
        return service;
    }

    public static String normalize(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value.trim())) {
            return null;
        }
        return value.trim();
    }

    public static String normalizeVersion(String version) {
        if (version == null) {
            return null;
        }
        Version v = new Version(version);
        if (v.getMajor() == null) {
            return null;
        }
        if (v.getMinor() == null) {
            return String.format("%d.0.0", ((Number)((Object)v.getMajor())).intValue());
        }
        if (v.getRevision() == null) {
            return String.format("%d.%d.0", ((Number)((Object)v.getMajor())).intValue(), ((Number)((Object)v.getMinor())).intValue());
        }
        return version;
    }

    Operation dispatch(Request req, Service serviceDescriptor) throws Throwable {
        Object serviceBean;
        Method operation;
        if (req.getRequest() == null) {
            String msg = "Could not determine geoserver request from http request " + req.getHttpRequest();
            throw new ServiceException(msg, "MissingParameterValue", "request");
        }
        boolean exists = this.operationExists(req, serviceDescriptor);
        if (!exists && req.getKvp().get("request") != null) {
            req.setRequest(Dispatcher.normalize(KvpUtils.getSingleValue(req.getKvp(), "request")));
            exists = this.operationExists(req, serviceDescriptor);
        }
        if ((operation = OwsUtils.method((serviceBean = serviceDescriptor.getService()).getClass(), req.getRequest())) == null || !exists) {
            String msg = "No such operation " + req;
            throw new ServiceException(msg, "OperationNotSupported", req.getRequest());
        }
        Object[] parameters = new Object[operation.getParameterTypes().length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<Object> parameterType = operation.getParameterTypes()[i];
            if (parameterType.isAssignableFrom(HttpServletRequest.class)) {
                parameters[i] = req.getHttpRequest();
                continue;
            }
            if (parameterType.isAssignableFrom(HttpServletResponse.class)) {
                parameters[i] = req.getHttpResponse();
                continue;
            }
            if (parameterType.isAssignableFrom(InputStream.class)) {
                parameters[i] = req.getHttpRequest().getInputStream();
                continue;
            }
            if (parameterType.isAssignableFrom(OutputStream.class)) {
                parameters[i] = req.getHttpResponse().getOutputStream();
                continue;
            }
            Object requestBean = null;
            Exception t = null;
            boolean kvpParsed = false;
            boolean xmlParsed = false;
            if (req.getKvp() != null && req.getKvp().size() > 0) {
                try {
                    requestBean = this.parseRequestKVP(parameterType, req);
                    kvpParsed = true;
                }
                catch (Exception e) {
                    t = e;
                }
            }
            if (req.getInput() != null) {
                requestBean = this.parseRequestXML(requestBean, req.getInput(), req);
                xmlParsed = true;
            }
            if (requestBean == null) {
                if (t != null) {
                    throw t;
                }
                if (kvpParsed && xmlParsed || !kvpParsed && !xmlParsed) {
                    throw new ServiceException("Could not find request reader (either kvp or xml) for: " + parameterType.getName() + ", it might be that some request parameters are missing, please check the documentation");
                }
                if (kvpParsed) {
                    throw new ServiceException("Could not parse the KVP for: " + parameterType.getName());
                }
                throw new ServiceException("Could not parse the XML for: " + parameterType.getName());
            }
            Method setBaseUrl = OwsUtils.setter(requestBean.getClass(), "baseUrl", String.class);
            if (setBaseUrl != null) {
                setBaseUrl.invoke(requestBean, (Object[])new String[]{ResponseUtils.baseURL(req.getHttpRequest())});
            }
            if (requestBean == null) continue;
            if (req.getService() == null) {
                req.setService(this.lookupRequestBeanProperty(requestBean, "service", false));
            }
            if (req.getVersion() == null) {
                req.setVersion(Dispatcher.normalizeVersion(this.lookupRequestBeanProperty(requestBean, "version", false)));
            }
            if (req.getOutputFormat() == null) {
                req.setOutputFormat(this.lookupRequestBeanProperty(requestBean, "outputFormat", true));
            }
            parameters[i] = requestBean;
        }
        if (this.citeCompliant) {
            if (!"GetCapabilities".equalsIgnoreCase(req.getRequest())) {
                if (req.getVersion() == null) {
                    throw new ServiceException("Could not determine version", "MissingParameterValue", "version");
                }
                if (!req.getVersion().matches("[0-99].[0-99].[0-99]")) {
                    throw new ServiceException("Invalid version: " + req.getVersion(), "InvalidParameterValue", "version");
                }
                boolean found = false;
                Version version = new Version(req.getVersion());
                for (Service service : this.loadServices()) {
                    if (!version.equals((Object)service.getVersion())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new ServiceException("Invalid version: " + req.getVersion(), "InvalidParameterValue", "version");
                }
            }
            if (req.getService() == null) {
                throw new ServiceException("Could not determine service", "MissingParameterValue", "service");
            }
        }
        Operation op = new Operation(req.getRequest(), serviceDescriptor, operation, parameters);
        return this.fireOperationDispatchedCallback(req, op);
    }

    private boolean operationExists(Request req, Service serviceDescriptor) {
        boolean exists = false;
        for (String op : serviceDescriptor.getOperations()) {
            if (!op.equalsIgnoreCase(req.getRequest())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    Operation fireOperationDispatchedCallback(Request req, Operation op) {
        for (DispatcherCallback cb : this.callbacks) {
            Operation o = cb.operationDispatched(req, op);
            op = o != null ? o : op;
        }
        return op;
    }

    String lookupRequestBeanProperty(Object requestBean, String property, boolean allowDefaultValues) {
        if (requestBean instanceof EObject && EMFUtils.has((EObject)((EObject)requestBean), (String)property)) {
            EObject eObject = (EObject)requestBean;
            if (allowDefaultValues || EMFUtils.isSet((EObject)eObject, (String)property)) {
                return Dispatcher.normalize((String)EMFUtils.get((EObject)eObject, (String)property));
            }
        } else {
            String version = OwsUtils.property(requestBean, property, String.class);
            if (version != null) {
                return Dispatcher.normalize(version);
            }
        }
        return null;
    }

    Object execute(Request req, Operation opDescriptor) throws Throwable {
        Service serviceDescriptor = opDescriptor.getService();
        Object serviceBean = serviceDescriptor.getService();
        Object[] parameters = opDescriptor.getParameters();
        Object result = null;
        try {
            if (serviceBean instanceof DirectInvocationService) {
                String operationName = opDescriptor.getId();
                result = ((DirectInvocationService)serviceBean).invokeDirect(operationName, parameters);
            } else {
                Method operation = opDescriptor.getMethod();
                result = operation.invoke(serviceBean, parameters);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
        return this.fireOperationExecutedCallback(req, opDescriptor, result);
    }

    Object fireOperationExecutedCallback(Request req, Operation op, Object result) {
        for (DispatcherCallback cb : this.callbacks) {
            Object r = cb.operationExecuted(req, op, result);
            result = r != null ? r : result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void response(Object result, Request req, Operation opDescriptor) throws Throwable {
        if (result != null) {
            List responses = GeoServerExtensions.extensions(Response.class);
            Iterator itr = responses.iterator();
            block5: while (itr.hasNext()) {
                Response response = (Response)itr.next();
                Class<?> binding = response.getBinding();
                if (!binding.isAssignableFrom(result.getClass()) || !response.canHandle(opDescriptor)) {
                    itr.remove();
                    continue;
                }
                Set<String> outputFormats = response.getOutputFormats();
                if (req.getOutputFormat() == null || outputFormats.isEmpty() || outputFormats.contains(req.getOutputFormat())) continue;
                Iterator<String> iterator = outputFormats.iterator();
                while (iterator.hasNext()) {
                    String format;
                    String outputFormat = format = iterator.next();
                    if (!req.getOutputFormat().equalsIgnoreCase(outputFormat)) continue;
                    continue block5;
                }
                itr.remove();
            }
            if (responses.isEmpty()) {
                if (req.getOutputFormat() != null) {
                    throw new ServiceException("Failed to find response for output format " + req.getOutputFormat(), "InvalidParameterValue", "outputFormat");
                }
                String msg = "No response: ( object = " + result.getClass();
                if (req.getOutputFormat() != null) {
                    msg = msg + ", outputFormat = " + req.getOutputFormat();
                }
                msg = msg + " )";
                throw new RuntimeException(msg);
            }
            if (responses.size() > 1) {
                Collections.sort(responses, (o1, o2) -> {
                    Class<?> c2;
                    Class<?> c1 = o1.getBinding();
                    if (c1.equals(c2 = o2.getBinding())) {
                        return 0;
                    }
                    if (c1.isAssignableFrom(c2)) {
                        return 1;
                    }
                    return -1;
                });
                Response r1 = (Response)responses.get(0);
                Response r2 = (Response)responses.get(1);
                if (r1.getBinding().equals(r2.getBinding())) {
                    String msg = "Multiple responses: (" + result.getClass() + "): " + r1 + ", " + r2;
                    throw new RuntimeException(msg);
                }
            }
            Response response = (Response)responses.get(0);
            response = this.fireResponseDispatchedCallback(req, opDescriptor, result, response);
            ServiceStrategy outputStrategy = this.findOutputStrategy(req.getHttpResponse());
            if (outputStrategy == null) {
                outputStrategy = new DefaultOutputStrategy();
            }
            String mimeType = response.getMimeType(result, opDescriptor);
            if (req.isSOAP()) {
                req.getHttpResponse().setContentType(SOAP_MIME);
            } else {
                req.getHttpResponse().setContentType(mimeType);
            }
            String charset = response.getCharset(opDescriptor);
            if (charset != null) {
                req.getHttpResponse().setCharacterEncoding(charset);
            }
            this.setHeaders(req, opDescriptor, result, response);
            DispatcherOutputStream output = outputStrategy.getDestination(req.getHttpResponse());
            boolean abortResponse = true;
            try {
                if (req.isSOAP()) {
                    this.startSOAPEnvelope(output, req, response);
                }
                if (req.isSOAP() && result instanceof TransformerBase) {
                    ((TransformerBase)result).setOmitXMLDeclaration(true);
                }
                response.write(result, output, opDescriptor);
                if (req.isSOAP()) {
                    this.endSOAPEnvelope(output);
                }
                try {
                    outputStrategy.flush(req.getHttpResponse());
                }
                catch (IOException e) {
                    throw new ClientStreamAbortedException(e);
                }
                abortResponse = true;
            }
            finally {
                if (abortResponse) {
                    outputStrategy.abort();
                }
            }
            req.getHttpResponse().getOutputStream().flush();
        }
    }

    void setHeaders(Request req, Operation opDescriptor, Object result, Response response) {
        Map<String, Object> rawKvp = req.getRawKvp();
        String disposition = response.getPreferredDisposition(result, opDescriptor);
        String filename = response.getAttachmentFileName(result, opDescriptor);
        if (rawKvp != null) {
            if (rawKvp.get("FILENAME") != null) {
                filename = (String)rawKvp.get("FILENAME");
            }
            if (rawKvp.get("CONTENT-DISPOSITION") != null) {
                disposition = (String)rawKvp.get("CONTENT-DISPOSITION");
            }
        }
        if (disposition != null && !"attachment".equals(disposition) && !"inline".equals(disposition)) {
            disposition = null;
        }
        String[][] headers = response.getHeaders(result, opDescriptor);
        boolean contentDispositionProvided = false;
        if (headers != null) {
            for (String[] header : headers) {
                if (header[0].equalsIgnoreCase("Content-Disposition")) {
                    contentDispositionProvided = true;
                    if (disposition != null) continue;
                    req.getHttpResponse().addHeader(header[0], header[1]);
                    continue;
                }
                req.getHttpResponse().addHeader(header[0], header[1]);
            }
        }
        if (!contentDispositionProvided) {
            if (disposition == null) {
                disposition = "inline";
            }
            String disp = disposition + "; filename=" + filename;
            req.getHttpResponse().setHeader("Content-Disposition", disp);
        }
    }

    void startSOAPEnvelope(OutputStream output, Request request, Response response) throws IOException {
        String type;
        output.write(("<soap:Envelope xmlns:soap='" + request.getSOAPNamespace() + "'><soap:Header/>").getBytes());
        output.write("<soap:Body".getBytes());
        if (response != null && response instanceof SOAPAwareResponse && (type = ((SOAPAwareResponse)((Object)response)).getBodyType()) != null) {
            output.write((" type='" + type + "'").getBytes());
        }
        output.write(">".getBytes());
    }

    void endSOAPEnvelope(OutputStream output) throws IOException {
        output.write("</soap:Body></soap:Envelope>".getBytes());
    }

    Response fireResponseDispatchedCallback(Request req, Operation op, Object result, Response response) {
        for (DispatcherCallback cb : this.callbacks) {
            Response r = cb.responseDispatched(req, op, result, response);
            response = r != null ? r : response;
        }
        return response;
    }

    Collection<Service> loadServices() {
        List services = GeoServerExtensions.extensions(Service.class);
        if (new HashSet(services).size() != services.size()) {
            String msg = "Two identical service descriptors found";
            throw new IllegalStateException(msg);
        }
        return services;
    }

    Service findService(String id, String ver, String namespace) throws ServiceException {
        Version version = ver != null ? new Version(ver) : null;
        Collection<Service> services = this.loadServices();
        if (id.contains("/")) {
            id = id.substring(id.indexOf("/") + 1);
        }
        ArrayList<Service> matches = new ArrayList<Service>();
        for (Service sBean : services) {
            if (!sBean.getId().equalsIgnoreCase(id)) continue;
            matches.add(sBean);
        }
        if (matches.isEmpty()) {
            return null;
        }
        Service sBean = null;
        if (matches.size() > 1) {
            ArrayList vmatches = new ArrayList(matches);
            if (version != null) {
                Iterator itr = vmatches.iterator();
                while (itr.hasNext()) {
                    Service s = (Service)itr.next();
                    if (version.equals((Object)s.getVersion())) continue;
                    itr.remove();
                }
                if (vmatches.isEmpty()) {
                    vmatches = new ArrayList(matches);
                }
            }
            if (namespace != null && vmatches.size() > 1) {
                ArrayList nmatches = new ArrayList(vmatches);
                Iterator itr = nmatches.iterator();
                while (itr.hasNext()) {
                    Service s = (Service)itr.next();
                    if (s.getNamespace() == null || s.getNamespace().equals(namespace)) continue;
                    itr.remove();
                }
                if (!nmatches.isEmpty()) {
                    vmatches = nmatches;
                }
            }
            if (vmatches.size() > 1) {
                Comparator comparator = (s1, s2) -> s1.getVersion().compareTo(s2.getVersion());
                Collections.sort(vmatches, comparator);
            }
            sBean = (Service)vmatches.get(vmatches.size() - 1);
        } else {
            sBean = (Service)matches.get(0);
        }
        return sBean;
    }

    public static Collection<KvpRequestReader> loadKvpRequestReaders() {
        List kvpReaders = GeoServerExtensions.extensions(KvpRequestReader.class);
        if (new HashSet(kvpReaders).size() != kvpReaders.size()) {
            String msg = "Two identical kvp readers found";
            throw new IllegalStateException(msg);
        }
        return kvpReaders;
    }

    public static KvpRequestReader findKvpRequestReader(Class<?> type) {
        Collection<KvpRequestReader> kvpReaders = Dispatcher.loadKvpRequestReaders();
        ArrayList<KvpRequestReader> matches = new ArrayList<KvpRequestReader>();
        for (KvpRequestReader kvpReader : kvpReaders) {
            if (!kvpReader.getRequestBean().isAssignableFrom(type)) continue;
            matches.add(kvpReader);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            Comparator comparator = (kvp1, kvp2) -> {
                if (kvp2.getRequestBean().isAssignableFrom(kvp1.getRequestBean())) {
                    return -1;
                }
                return 1;
            };
            Collections.sort(matches, comparator);
        }
        return (KvpRequestReader)matches.get(0);
    }

    static Collection<XmlRequestReader> loadXmlReaders() {
        List xmlReaders = GeoServerExtensions.extensions(XmlRequestReader.class);
        if (new HashSet(xmlReaders).size() != xmlReaders.size()) {
            String msg = "Two identical xml readers found";
            block0: for (int i = 0; i < xmlReaders.size(); ++i) {
                XmlRequestReader r1 = (XmlRequestReader)xmlReaders.get(i);
                for (int j = i + 1; j < xmlReaders.size(); ++j) {
                    XmlRequestReader r2 = (XmlRequestReader)xmlReaders.get(j);
                    if (!r1.equals(r2)) continue;
                    msg = msg + ": " + r1 + " and " + r2;
                    continue block0;
                }
            }
            throw new IllegalStateException(msg);
        }
        return xmlReaders;
    }

    /*
     * WARNING - void declaration
     */
    public static XmlRequestReader findXmlReader(String namespace, String element, String serviceId, String ver) {
        String msg;
        Collection<XmlRequestReader> xmlReaders = Dispatcher.loadXmlReaders();
        ArrayList<XmlRequestReader> matches = new ArrayList<XmlRequestReader>();
        for (XmlRequestReader xmlRequestReader : xmlReaders) {
            QName xmlElement = xmlRequestReader.getElement();
            if (!xmlElement.getLocalPart().equalsIgnoreCase(element) || !xmlElement.getNamespaceURI().equalsIgnoreCase(namespace)) continue;
            matches.add(xmlRequestReader);
        }
        if (matches.isEmpty() && (namespace == null || namespace.equals(""))) {
            msg = "No namespace specified in request, searching for  xml reader by element name only";
            logger.info(msg);
            for (XmlRequestReader xmlReader : xmlReaders) {
                if (!xmlReader.getElement().getLocalPart().equals(element)) continue;
                matches.add(xmlReader);
            }
            if (!matches.isEmpty()) {
                Iterator iterator = matches.iterator();
                XmlRequestReader first = (XmlRequestReader)iterator.next();
                while (iterator.hasNext()) {
                    XmlRequestReader xmlReader = (XmlRequestReader)iterator.next();
                    if (first.getServiceId().equals(xmlReader.getServiceId())) continue;
                    matches.clear();
                    break;
                }
            }
        }
        if (matches.isEmpty()) {
            msg = "No xml reader: (" + namespace + "," + element + ")";
            logger.info(msg);
            return null;
        }
        XmlRequestReader xmlReader = null;
        if (matches.size() > 1) {
            void var7_13;
            ArrayList arrayList = new ArrayList(matches);
            if (serviceId != null) {
                Iterator itr = arrayList.iterator();
                while (itr.hasNext()) {
                    XmlRequestReader r = (XmlRequestReader)itr.next();
                    if (r.getServiceId() == null || serviceId.equalsIgnoreCase(r.getServiceId())) continue;
                    itr.remove();
                }
            }
            if (ver != null) {
                Version version = new Version(ver);
                Iterator itr = arrayList.iterator();
                while (itr.hasNext()) {
                    XmlRequestReader r = (XmlRequestReader)itr.next();
                    if (r.getVersion() == null || version.equals((Object)r.getVersion())) continue;
                    itr.remove();
                }
                if (arrayList.isEmpty()) {
                    ArrayList arrayList2 = new ArrayList(matches);
                }
            }
            if (var7_13.size() > 1) {
                Comparator comparator = (r1, r2) -> {
                    Version v1 = r1.getVersion();
                    Version v2 = r2.getVersion();
                    if (v1 == null && v2 == null) {
                        return 0;
                    }
                    if (v1 != null && v2 == null) {
                        return 1;
                    }
                    if (v1 == null && v2 != null) {
                        return -1;
                    }
                    int versionCompare = v1.compareTo(v2);
                    if (versionCompare != 0) {
                        return versionCompare;
                    }
                    String sid1 = r1.getServiceId();
                    String sid2 = r2.getServiceId();
                    if (sid1 == null && sid2 == null) {
                        return 0;
                    }
                    if (sid1 != null && sid2 == null) {
                        return 1;
                    }
                    if (sid1 == null && sid2 != null) {
                        return -1;
                    }
                    return sid1.compareTo(sid2);
                };
                Collections.sort(var7_13, comparator);
            }
            if (!var7_13.isEmpty()) {
                xmlReader = (XmlRequestReader)var7_13.get(var7_13.size() - 1);
            }
        } else {
            xmlReader = (XmlRequestReader)matches.get(0);
        }
        return xmlReader;
    }

    ServiceStrategy findOutputStrategy(HttpServletResponse response) {
        OutputStrategyFactory factory = null;
        try {
            factory = (OutputStrategyFactory)GeoServerExtensions.bean((String)"serviceStrategyFactory");
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
        return factory.createOutputStrategy(response);
    }

    BufferedInputStream input(File cache) throws IOException {
        return cache == null ? null : new BufferedInputStream(new FileInputStream(cache));
    }

    void preParseKVP(Request req) throws ServiceException {
        HttpServletRequest request = req.getHttpRequest();
        Map kvp = request.getParameterMap();
        if (kvp == null || kvp.isEmpty()) {
            req.setKvp(new HashMap<String, Object>());
            return;
        }
        KvpMap<String, Object> parsedKvp = KvpUtils.normalize(kvp);
        KvpMap<String, Object> rawKvp = new KvpMap<String, Object>((Map<String, Object>)parsedKvp);
        req.setKvp(parsedKvp);
        req.setRawKvp(rawKvp);
    }

    void parseKVP(Request req) throws ServiceException {
        this.preParseKVP(req);
        this.parseKVP(req, req.getKvp());
    }

    Map<String, Object> parseKVP(Request req, Map<String, Object> kvp) {
        List<Throwable> errors = KvpUtils.parse(kvp);
        if (!errors.isEmpty()) {
            req.setError(errors.get(0));
        }
        return kvp;
    }

    Object parseRequestKVP(Class<?> type, Request request) throws Exception {
        KvpRequestReader kvpReader = Dispatcher.findKvpRequestReader(type);
        if (kvpReader != null) {
            Object requestBean = kvpReader.createRequest();
            if (requestBean != null) {
                requestBean = kvpReader.read(requestBean, request.getKvp(), request.getRawKvp());
            }
            return requestBean;
        }
        return null;
    }

    Object parseRequestXML(Object requestBean, BufferedReader input, Request request) throws Exception {
        if (!input.ready()) {
            return null;
        }
        String namespace = request.getNamespace();
        String element = request.getPostRequestElementName();
        String version = request.getVersion();
        String service = request.getService();
        XmlRequestReader xmlReader = Dispatcher.findXmlReader(namespace, element, service, version);
        if (xmlReader == null) {
            return requestBean;
        }
        return xmlReader.read(requestBean, input, request.getKvp());
    }

    public static Map<String, String> readOpContext(Request request) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (request.getPath() != null) {
            map.put("service", request.getPath());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request readOpPost(Request req) throws Exception {
        String outputFormat;
        String version;
        String service;
        String request;
        String elementName;
        String namespace;
        try (XMLStreamReader parser = this.createParserForRootElement(req);){
            while (parser.hasNext() && 1 != parser.next()) {
            }
            namespace = parser.getNamespaceURI() == null ? "" : parser.getNamespaceURI();
            request = elementName = parser.getLocalName();
            service = parser.getAttributeValue(null, "service");
            version = parser.getAttributeValue(null, "version");
            outputFormat = parser.getAttributeValue(null, "outputFormat");
        }
        req.setNamespace(Dispatcher.normalize(namespace));
        req.setPostRequestElementName(Dispatcher.normalize(elementName));
        if (request != null) {
            req.setRequest(Dispatcher.normalize(request));
        }
        if (service != null) {
            req.setService(Dispatcher.normalize(service));
        }
        if (version != null) {
            req.setVersion(Dispatcher.normalizeVersion(Dispatcher.normalize(version)));
        }
        if (outputFormat != null) {
            req.setOutputFormat(Dispatcher.normalize(outputFormat));
        }
        return req;
    }

    private XMLStreamReader createParserForRootElement(Request req) throws IOException, FactoryConfigurationError, XMLStreamException {
        char[] buff = new char[this.XML_LOOKAHEAD];
        BufferedReader input = req.getInput();
        input.mark(this.XML_LOOKAHEAD);
        input.read(buff);
        input.reset();
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XMLStreamReader parser = factory.createXMLStreamReader(new CharArrayReader(buff));
        return parser;
    }

    void exception(Throwable t, Service service, Request request) {
        Throwable current = t;
        while (!(current == null || current instanceof ClientStreamAbortedException || Dispatcher.isSecurityException(current) || current instanceof HttpErrorCodeException)) {
            if (current instanceof SAXException) {
                current = ((SAXException)current).getException();
                continue;
            }
            current = current.getCause();
        }
        if (current instanceof ClientStreamAbortedException) {
            logger.log(Level.FINER, "Client has closed stream", t);
            return;
        }
        if (Dispatcher.isSecurityException(current)) {
            throw (RuntimeException)current;
        }
        if (current instanceof HttpErrorCodeException) {
            HttpErrorCodeException ece = (HttpErrorCodeException)current;
            int errorCode = ece.getErrorCode();
            if (errorCode < 199 || errorCode > 299) {
                logger.log(Level.FINE, "", t);
            } else {
                logger.log(Level.FINER, "", t);
            }
            boolean isError = ece.getErrorCode() >= 400;
            HttpServletResponse rsp = request.getHttpResponse();
            if (ece.getContentType() != null) {
                rsp.setContentType(ece.getContentType());
            }
            try {
                if (isError) {
                    if (ece.getMessage() != null) {
                        rsp.sendError(ece.getErrorCode(), ece.getMessage());
                    } else {
                        rsp.sendError(ece.getErrorCode());
                    }
                } else {
                    rsp.setStatus(ece.getErrorCode());
                    if (ece.getMessage() != null) {
                        rsp.getOutputStream().print(ece.getMessage());
                    }
                }
                if (!isError) {
                    t = null;
                }
            }
            catch (IOException e) {
                logger.log(Level.FINER, "", t);
            }
        } else {
            Throwable cause;
            String errorCode = null;
            String message = t.getMessage();
            Level level = Level.SEVERE;
            for (cause = t; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ServiceException)) continue;
                errorCode = ((ServiceException)cause).getCode();
                break;
            }
            if (errorCode != null && errorCode.toUpperCase().startsWith("INVALID") || errorCode == null && message != null && message.toUpperCase().startsWith("INVALID")) {
                level = Level.INFO;
            }
            logger.log(level, "", t);
            if (cause == null) {
                cause = new ServiceException(t);
            }
            ServiceException se = (ServiceException)cause;
            if (cause != t) {
                se = new ServiceException(se.getMessage(), t, se.getCode(), se.getLocator());
            }
            this.handleServiceException(se, service, request);
        }
        request.error = t;
    }

    void handleServiceException(ServiceException se, Service service, Request request) {
        HttpServletResponse httpResponse;
        ServiceExceptionHandler handler = null;
        if (service != null) {
            List handlers = GeoServerExtensions.extensions(ServiceExceptionHandler.class);
            for (Object o : handlers) {
                ServiceExceptionHandler seh = (ServiceExceptionHandler)o;
                if (!seh.getServices().contains(service)) continue;
                handler = seh;
                break;
            }
        }
        if (handler == null) {
            handler = new OWS10ServiceExceptionHandler();
        }
        if (request.isSOAP() && (handler instanceof OWS10ServiceExceptionHandler || handler instanceof OWS11ServiceExceptionHandler)) {
            handler = new SOAPServiceExceptionHandler(handler);
        }
        if ((httpResponse = request.getHttpResponse()).containsHeader("Content-Disposition")) {
            try {
                httpResponse.setHeader("Content-Disposition", null);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Failed to reset content disposition header", e);
            }
        }
        handler.handleServiceException(se, request);
    }

    public static boolean isSecurityException(Throwable t) {
        return t != null && t.getClass().getPackage().getName().startsWith("org.springframework.security");
    }
}

