/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.AbstractURLPublisher;

public class ClasspathPublisher
extends AbstractURLPublisher {
    Class<?> clazz;

    public ClasspathPublisher(Class<?> clazz) {
        this.clazz = clazz;
    }

    public ClasspathPublisher() {
        this.clazz = ClasspathPublisher.class;
    }

    @Override
    protected URL getUrl(HttpServletRequest request) throws IOException {
        String ctxPath = request.getContextPath();
        String reqPath = request.getRequestURI();
        reqPath = URLDecoder.decode(reqPath, "UTF-8");
        if (Arrays.stream((reqPath = reqPath.substring(ctxPath.length())).split("/")).anyMatch(".."::equals)) {
            throw new IllegalArgumentException("Contains invalid '..' path: " + reqPath);
        }
        URL url = this.clazz.getResource(reqPath);
        if (url == null && !reqPath.startsWith("/")) {
            url = this.clazz.getResource("/");
        }
        if (url == null && reqPath.length() > 1 && reqPath.startsWith("/")) {
            url = this.clazz.getResource(reqPath.substring(1));
        }
        return url;
    }
}

