/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.IOUtils;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.image.WorldImageWriter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class IMGCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public IMGCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, Arrays.asList("png", "jpeg", "JPEG", "PNG", "image/png", "image/jpeg"), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("png", "png");
                this.put("jpeg", "jpeg");
                this.put("JPEG", "jpeg");
                this.put("PNG", "png");
                this.put("image/png", "png");
                this.put("image/jpeg", "jpeg");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("png", "image/png");
                this.put("jpeg", "image/jpeg");
                this.put("PNG", "image/png");
                this.put("JPEG", "image/jpeg");
                this.put("image/png", "image/png");
                this.put("image/jpeg", "image/jpeg");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        if (sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        WorldImageWriter writer = new WorldImageWriter((Object)output);
        Format writerParams = writer.getFormat();
        ParameterValueGroup writeParameters = writerParams.getWriteParameters();
        ParameterValue format = writeParameters.parameter("Format");
        format.setValue((Object)this.getFileExtension(outputFormat));
        try {
            writer.write((GridCoverage)sourceCoverage, new GeneralParameterValue[]{format});
            output.flush();
        }
        finally {
            IOUtils.closeQuietly((Closeable)output);
            try {
                writer.dispose();
            }
            catch (Throwable throwable) {}
            sourceCoverage.dispose(true);
        }
    }
}

