/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.jai.OpImage;
import javax.media.jai.RenderedOp;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;

public class GeoTiffWriterHelper {
    private static final float DEFAULT_QUALITY = 0.75f;
    private static final GeoTiffFormat TIFF_FORMAT = new GeoTiffFormat();
    private GridCoverage2D coverage;
    private File sourceFile;
    private GeoTiffWriteParams imageIoWriteParams;
    private ParameterValueGroup geotoolsWriteParams;

    public GeoTiffWriterHelper(GridCoverage2D coverage) throws IOException {
        this.coverage = coverage;
        if (this.isUnprocessed(coverage)) {
            this.sourceFile = this.getSourceFile(coverage);
        }
        this.imageIoWriteParams = this.buildWriteParams(coverage);
        this.geotoolsWriteParams = this.buildGeoToolsWriteParams(this.imageIoWriteParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSourceFile(GridCoverage2D coverage) {
        File file;
        Object fileSource = coverage.getProperty("OriginalFileSource");
        if (fileSource != null && fileSource instanceof String && (file = new File((String)fileSource)).exists()) {
            GeoTiffReader reader = null;
            try {
                reader = new GeoTiffReader((Object)file);
                GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
                Envelope envelope = coverage.getEnvelope();
                if (originalEnvelope.equals(envelope, 1.0E-9, false)) {
                    GridCoverage2D test = reader.read(null);
                    ImageUtilities.disposeImage((RenderedImage)test.getRenderedImage());
                    File file2 = file;
                    return file2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
        return null;
    }

    private GeoTiffWriteParams buildWriteParams(GridCoverage2D coverage) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        int tileWidth = renderedImage.getTileWidth();
        int tileHeight = renderedImage.getTileHeight();
        GridEnvelope gr = coverage.getGridGeometry().getGridRange();
        if (gr.getSpan(0) < tileWidth) {
            tileWidth = gr.getSpan(0);
        }
        if (gr.getSpan(1) < tileHeight) {
            tileHeight = gr.getSpan(1);
        }
        GeoTiffWriteParams writeParams = new GeoTiffWriteParams();
        writeParams.setTilingMode(2);
        writeParams.setTiling(tileWidth, tileHeight);
        return writeParams;
    }

    private ParameterValueGroup buildGeoToolsWriteParams(GeoTiffWriteParams writeParams) {
        ParameterValueGroup wparams = TIFF_FORMAT.getWriteParameters();
        wparams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)writeParams);
        return wparams;
    }

    public GeoTiffWriteParams getImageIoWriteParams() {
        return this.imageIoWriteParams;
    }

    public ParameterValueGroup getGeotoolsWriteParams() {
        return this.geotoolsWriteParams;
    }

    public void disableSourceCopyOptimization() {
        this.sourceFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream stream) throws IOException {
        if (this.sourceFile != null) {
            FileUtils.copyFile((File)this.sourceFile, (OutputStream)stream);
        } else {
            boolean unreferenced;
            CoordinateReferenceSystem crs = this.coverage.getCoordinateReferenceSystem();
            boolean bl = unreferenced = crs == null || crs instanceof EngineeringCRS;
            if (unreferenced) {
                int tileHeight;
                int tileWidth;
                RenderedImage ri = this.coverage.getRenderedImage();
                if (this.imageIoWriteParams.getTilingMode() == 2) {
                    tileWidth = this.imageIoWriteParams.getTileWidth();
                    tileHeight = this.imageIoWriteParams.getTileHeight();
                } else {
                    tileWidth = ri.getTileWidth();
                    tileHeight = ri.getTileHeight();
                }
                float quality = 0.75f;
                String compression = null;
                if (this.imageIoWriteParams.getCompressionMode() == 2) {
                    compression = this.imageIoWriteParams.getCompressionType();
                    quality = this.imageIoWriteParams.getCompressionQuality();
                }
                new ImageWorker(ri).writeTIFF((Object)stream, compression, quality, tileWidth, tileHeight);
            } else {
                GeneralParameterValue[] wps = this.geotoolsWriteParams.values().toArray(new GeneralParameterValue[this.geotoolsWriteParams.values().size()]);
                AbstractGridCoverageWriter writer = (AbstractGridCoverageWriter)TIFF_FORMAT.getWriter((Object)stream);
                if (writer == null) {
                    throw new ServiceException("Could not find the GeoTIFF writer, please check it's in the classpath");
                }
                try {
                    writer.write((GridCoverage)this.coverage, wps);
                }
                finally {
                    try {
                        writer.dispose();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private boolean isUnprocessed(GridCoverage2D coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        if (ri instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)ri;
            return op.getOperationName().startsWith("ImageRead");
        }
        if (ri instanceof OpImage) {
            return ri.getClass().getSimpleName().startsWith("ImageRead");
        }
        return true;
    }
}

