/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.CloseableIterator;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.FileGroupProvider;
import org.geotools.data.FileResourceInfo;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.SupportFilesCollector;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class ImageMosaicFileResourceInfo
extends DefaultResourceInfo
implements FileResourceInfo {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicFileResourceInfo.class);
    private static final FilterFactory2 FF = FeatureUtilities.DEFAULT_FILTER_FACTORY;
    private String parentLocation;
    private String locationAttributeName;
    private RasterManager rasterManager;
    private PathType pathType;
    private String typeName;
    private GranuleCatalog granuleCatalog;

    public ImageMosaicFileResourceInfo(RasterManager rasterManager, String parentLocation, String locationAttributeName) {
        this.rasterManager = rasterManager;
        this.granuleCatalog = rasterManager.getGranuleCatalog();
        this.typeName = rasterManager.getTypeName();
        this.pathType = rasterManager.getPathType();
        this.parentLocation = parentLocation;
        this.locationAttributeName = locationAttributeName;
    }

    @Override
    public CloseableIterator<FileGroupProvider.FileGroup> getFiles(Query query) {
        SimpleFeatureCollection fc = null;
        try {
            Query updatedQuery = query != null ? query : new Query();
            Filter filter = updatedQuery.getFilter();
            if (!"location".equalsIgnoreCase(this.locationAttributeName) && filter instanceof LikeFilterImpl) {
                LikeFilterImpl likeFilter = (LikeFilterImpl)filter;
                AttributeExpressionImpl impl = (AttributeExpressionImpl)likeFilter.getExpression();
                String attribute = impl.getPropertyName();
                String value = likeFilter.getLiteral();
                if ("location".equalsIgnoreCase(attribute)) {
                    attribute = this.locationAttributeName;
                    updatedQuery.setFilter((Filter)FF.like((Expression)FF.property(attribute), value));
                }
            }
            ArrayList<SortByImpl> clauses = new ArrayList<SortByImpl>(1);
            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.locationAttributeName), SortOrder.ASCENDING));
            Object[] sb = clauses.toArray(new SortBy[0]);
            boolean isSortBySupported = this.granuleCatalog.getQueryCapabilities(this.typeName).supportsSorting((SortBy[])sb);
            if (isSortBySupported) {
                updatedQuery.setSortBy((SortBy[])sb);
            } else {
                LOGGER.severe("Sorting parameter ignored, underlying datastore cannot sort on " + Arrays.toString(sb));
            }
            updatedQuery.setTypeName(this.typeName);
            fc = this.granuleCatalog.getGranules(updatedQuery);
            return new CloseableFileGroupIterator(fc.features());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    class CloseableFileGroupIterator
    implements CloseableIterator<FileGroupProvider.FileGroup> {
        SimpleFeature cachedNext = null;
        SimpleFeatureIterator featureIterator;

        public CloseableFileGroupIterator(SimpleFeatureIterator featureIterator) {
            this.featureIterator = featureIterator;
        }

        @Override
        public boolean hasNext() {
            return this.featureIterator.hasNext() || this.cachedNext != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation isn't supported");
        }

        @Override
        public FileGroupProvider.FileGroup next() {
            SimpleFeature next = null;
            if (this.cachedNext != null) {
                next = this.cachedNext;
                this.cachedNext = null;
            } else {
                next = (SimpleFeature)this.featureIterator.next();
            }
            int groupedFeatures = 0;
            SimpleFeature firstFeature = null;
            String granuleLocation = (String)Utils.getAttribute(next, ImageMosaicFileResourceInfo.this.locationAttributeName);
            URL resolved = ImageMosaicFileResourceInfo.this.pathType.resolvePath(ImageMosaicFileResourceInfo.this.parentLocation, granuleLocation);
            File file = null;
            if (resolved != null && (file = URLs.urlToFile((URL)resolved)) != null && file.exists()) {
                ++groupedFeatures;
                firstFeature = next;
            }
            if (groupedFeatures == 0) {
                return null;
            }
            while (this.featureIterator.hasNext()) {
                next = (SimpleFeature)this.featureIterator.next();
                String nextLocation = (String)Utils.getAttribute(next, ImageMosaicFileResourceInfo.this.locationAttributeName);
                if (granuleLocation.equalsIgnoreCase(nextLocation)) {
                    ++groupedFeatures;
                    continue;
                }
                this.cachedNext = next;
                break;
            }
            return this.buildFileGroup(file, groupedFeatures > 1, firstFeature);
        }

        private FileGroupProvider.FileGroup buildFileGroup(File file, boolean aggregate, SimpleFeature firstFeature) {
            String filePath = file.getAbsolutePath();
            List<File> supportFiles = null;
            SupportFilesCollector collector = SupportFilesCollector.getCollectorFor(file);
            if (collector != null) {
                supportFiles = collector.getSupportFiles(filePath);
            }
            Map<String, Object> metadataMap = this.computeGroupMetadata(filePath, aggregate, firstFeature);
            return new FileGroupProvider.FileGroup(file, supportFiles, metadataMap);
        }

        private Map<String, Object> computeGroupMetadata(String filePath, boolean aggregate, SimpleFeature firstFeature) {
            HashMap<String, Object> metadataMap = null;
            List<DimensionDescriptor> dimensionDescriptors = ImageMosaicFileResourceInfo.this.rasterManager.getDimensionDescriptors();
            if (dimensionDescriptors != null && !dimensionDescriptors.isEmpty()) {
                PropertyIsEqualTo filter = FF.equals((Expression)FF.property("location"), (Expression)FF.literal((Object)filePath));
                metadataMap = new HashMap<String, Object>();
                try {
                    for (DimensionDescriptor descriptor : dimensionDescriptors) {
                        String attribute = descriptor.getStartAttribute();
                        String name = descriptor.getName();
                        Comparable max = null;
                        Comparable min = null;
                        if (aggregate) {
                            Query query = new Query(ImageMosaicFileResourceInfo.this.typeName);
                            query.setFilter((Filter)filter);
                            query.setPropertyNames(Arrays.asList(attribute));
                            MaxVisitor maxVisitor = new MaxVisitor(attribute);
                            ImageMosaicFileResourceInfo.this.granuleCatalog.computeAggregateFunction(query, maxVisitor);
                            max = maxVisitor.getMax();
                            MinVisitor minVisitor = new MinVisitor(attribute);
                            ImageMosaicFileResourceInfo.this.granuleCatalog.computeAggregateFunction(query, minVisitor);
                            min = minVisitor.getMin();
                        } else {
                            max = min = (Comparable)Utils.getAttribute(firstFeature, attribute);
                        }
                        this.addMetadaElement(name, min, max, metadataMap);
                    }
                    this.addBBOX(aggregate, (Filter)filter, firstFeature, metadataMap);
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception occurred while parsing the feature domains", e);
                }
            }
            return metadataMap;
        }

        private void addBBOX(boolean aggregate, Filter filter, SimpleFeature firstFeature, Map<String, Object> metadataMap) throws IOException {
            ReferencedEnvelope envelope = null;
            if (aggregate) {
                BoundsVisitor boundsVisitor = new BoundsVisitor();
                Query query = new Query(ImageMosaicFileResourceInfo.this.typeName);
                query.setFilter(filter);
                ImageMosaicFileResourceInfo.this.granuleCatalog.computeAggregateFunction(query, boundsVisitor);
                envelope = boundsVisitor.getBounds();
            } else {
                envelope = new ReferencedEnvelope(firstFeature.getBounds());
            }
            if (envelope != null) {
                metadataMap.put("BOUNDINGBOX", (Object)envelope);
            }
        }

        private void addMetadaElement(String name, Comparable min, Comparable max, Map<String, Object> metadataMap) {
            if ("TIME".equalsIgnoreCase(name) || min instanceof Date) {
                metadataMap.put(name.toUpperCase(), new DateRange((Date)min, (Date)max));
            } else if ("ELEVATION".equalsIgnoreCase(name) || min instanceof Number) {
                metadataMap.put(name.toUpperCase(), NumberRange.create((double)((Number)((Object)min)).doubleValue(), (boolean)true, (double)((Number)((Object)max)).doubleValue(), (boolean)true));
            } else {
                metadataMap.put(name, new Range(String.class, (Comparable)((Object)((String)((Object)min))), (Comparable)((Object)((String)((Object)max)))));
            }
        }

        @Override
        public void close() throws IOException {
            this.featureIterator.close();
        }
    }
}

