/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicElementConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicSourceElement;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

public class ImageMosaicFileFeatureConsumer
implements ImageMosaicElementConsumer<SimpleFeature> {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicFileConsumer.class);
    private ImageMosaicFileConsumer imageMosaicFileConsumer = new ImageMosaicFileConsumer();

    @Override
    public boolean checkElement(SimpleFeature feature, ImageMosaicWalker provider) {
        ImageMosaicConfigHandler configHandler = provider.getConfigHandler();
        CatalogBuilderConfiguration runConfiguration = configHandler.getRunConfiguration();
        String locationAttrName = runConfiguration.getParameter("LocationAttribute");
        Object locationAttrObj = Utils.getAttribute(feature, locationAttrName);
        File file = null;
        if (locationAttrObj instanceof String) {
            String path = (String)locationAttrObj;
            boolean isAbsolute = Boolean.getBoolean(runConfiguration.getParameter("AbsolutePath"));
            file = isAbsolute ? new File(path) : new File(runConfiguration.getParameter("RootMosaicDirectory"), path);
        } else if (locationAttrObj instanceof File) {
            file = (File)locationAttrObj;
        }
        return this.imageMosaicFileConsumer.checkElement(file, provider);
    }

    @Override
    public void handleElement(SimpleFeature feature, ImageMosaicWalker provider) throws IOException {
        ImageMosaicConfigHandler configHandler = provider.getConfigHandler();
        CatalogBuilderConfiguration runConfiguration = configHandler.getRunConfiguration();
        String locationAttrName = runConfiguration.getParameter("LocationAttribute");
        Object locationAttrObj = Utils.getAttribute(feature, locationAttrName);
        File file = null;
        if (locationAttrObj instanceof String) {
            String path = (String)locationAttrObj;
            if (Boolean.getBoolean(runConfiguration.getParameter("AbsolutePath")) && !this.imageMosaicFileConsumer.checkElement(file = new File(path), provider)) {
                file = null;
            }
            if (!(file != null || (file = new File(runConfiguration.getParameter("RootMosaicDirectory"), path)).exists() && file.canRead() && file.isFile() || this.imageMosaicFileConsumer.checkElement(file = new File(path), provider))) {
                file = null;
            }
            if (file == null) {
                provider.skip(path);
                return;
            }
        } else if (locationAttrObj instanceof File) {
            file = (File)locationAttrObj;
        } else {
            provider.getEventHandler().fireException(new IOException("Location attribute type not recognized for column name: " + locationAttrName));
            provider.stop();
            return;
        }
        this.imageMosaicFileConsumer.handleElement(file, provider);
    }

    static class ImageMosaicFileConsumer
    implements ImageMosaicElementConsumer<File> {
        ImageMosaicFileConsumer() {
        }

        @Override
        public boolean checkElement(File file, ImageMosaicWalker provider) {
            return file != null && file.exists() && file.canRead() && file.isFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleElement(File file, ImageMosaicWalker provider) throws IOException {
            String extension;
            String validFileName;
            int elementIndex = provider.getElementIndex() + 1;
            provider.setElementIndex(elementIndex);
            int numElements = provider.getNumElements();
            ImageMosaicEventHandlers eventHandler = provider.getEventHandler();
            ImageMosaicConfigHandler configHandler = provider.getConfigHandler();
            if (!this.checkElement(file, provider)) {
                return;
            }
            try {
                validFileName = file.getCanonicalPath();
                validFileName = FilenameUtils.normalize((String)validFileName);
                extension = FilenameUtils.getExtension((String)validFileName);
            }
            catch (IOException e) {
                eventHandler.fireFileEvent(Level.FINER, file, false, "Exception occurred while processing file " + file + ": " + e.getMessage(), (double)elementIndex * 100.0 / (double)numElements);
                eventHandler.fireException(e);
                return;
            }
            validFileName = FilenameUtils.getName((String)validFileName);
            eventHandler.fireEvent(Level.INFO, "Now indexing file " + validFileName, (double)elementIndex * 100.0 / (double)numElements);
            AbstractGridCoverage2DReader coverageReader = null;
            try {
                String[] coverageNames;
                AbstractGridFormat cachedFormat = configHandler.getCachedFormat();
                AbstractGridFormat format = cachedFormat == null ? GridFormatFinder.findFormat((Object)file, (Hints)Utils.EXCLUDE_MOSAIC_HINTS) : (cachedFormat.accepts((Object)file) ? cachedFormat : GridFormatFinder.findFormat((Object)file, (Hints)Utils.EXCLUDE_MOSAIC_HINTS));
                if (format instanceof UnknownFormat || format == null) {
                    if (!Utils.LOG_EXCLUDES.contains(extension)) {
                        eventHandler.fireFileEvent(Level.INFO, file, false, "Skipped file " + file + ": File format is not supported.", (double)elementIndex * 99.0 / (double)numElements);
                    }
                    return;
                }
                Hints configurationHints = configHandler.getRunConfiguration().getHints();
                coverageReader = format.getReader((Object)file, configurationHints);
                if (configHandler.getCachedReaderSPI() == null) {
                    URL granuleUrl = URLs.fileToUrl((File)file);
                    ImageInputStreamSpi inStreamSpi = Utils.getInputStreamSPIFromURL(granuleUrl);
                    if (inStreamSpi == null) {
                        throw new IllegalArgumentException("no inputStreamSPI available!");
                    }
                    try (ImageInputStream inStream = inStreamSpi.createInputStreamInstance(granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());){
                        if (inStream == null) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
                            }
                            throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                        }
                        ImageReaderSpi spi = Utils.getReaderSpiFromStream(null, inStream);
                        configHandler.setCachedReaderSPI(spi);
                    }
                }
                for (String cvName : coverageNames = coverageReader.getGridCoverageNames()) {
                    ImageMosaicSourceElement.FileElement element = new ImageMosaicSourceElement.FileElement(file);
                    boolean shouldAccept = true;
                    try {
                        for (GranuleAcceptor acceptor : configHandler.getGranuleAcceptors()) {
                            if (acceptor.accepts((GridCoverage2DReader)coverageReader, cvName, file, configHandler)) continue;
                            shouldAccept = false;
                            String message = "Granule acceptor  " + acceptor.getClass().getName() + " rejected the granule being processed" + file;
                            ((ImageMosaicSourceElement)element).fireHarvestingEvent(eventHandler, elementIndex, numElements, message);
                            break;
                        }
                        configHandler.setCachedFormat(format);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failure during potential granule evaluation, skipping it: " + file, e);
                        shouldAccept = false;
                    }
                    if (shouldAccept) {
                        configHandler.updateConfiguration((GridCoverage2DReader)coverageReader, cvName, element, elementIndex, (double)numElements, provider.getTransaction());
                    }
                    ((ImageMosaicSourceElement)element).fireHarvestingEvent(eventHandler, elementIndex, numElements, "Done with file " + file);
                }
            }
            catch (Exception e) {
                eventHandler.fireException(e);
                provider.stop();
                return;
            }
            finally {
                block43: {
                    try {
                        if (coverageReader != null) {
                            coverageReader.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block43;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }
}

