/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicElementConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ImageMosaicDatastoreWalker
extends ImageMosaicWalker
implements Runnable {
    protected ImageMosaicElementConsumer<SimpleFeature> consumer;
    static final Logger LOGGER = Logging.getLogger(ImageMosaicDatastoreWalker.class);

    public ImageMosaicDatastoreWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, ImageMosaicElementConsumer<SimpleFeature> consumer) {
        super(configHandler, eventHandler);
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block44: {
            String message;
            GranuleCatalog catalog;
            block43: {
                catalog = null;
                this.configHandler.indexingPreamble();
                this.startTransaction();
                catalog = this.configHandler.getCatalog();
                String locationAttrName = this.configHandler.getRunConfiguration().getParameter("LocationAttribute");
                String requestedTypeName = this.configHandler.getRunConfiguration().getParameter("TypeName");
                if (requestedTypeName != null) {
                    SimpleFeatureType type = catalog.getType(requestedTypeName);
                    if (!Utils.isValidMosaicSchema(type, locationAttrName)) {
                        LOGGER.log(Level.FINE, "Skipping invalid mosaic index table " + requestedTypeName);
                    } else {
                        this.processGranules(catalog, requestedTypeName);
                    }
                } else {
                    String[] typeNames = catalog.getTypeNames();
                    if (typeNames != null) {
                        for (String typeName : typeNames) {
                            if (!Utils.isValidMosaicSchema(catalog.getType(typeName), locationAttrName)) {
                                LOGGER.log(Level.FINE, "Skipping invalid mosaic index table " + typeName);
                                continue;
                            }
                            this.processGranules(catalog, typeName);
                        }
                    }
                }
                if (this.getStop()) {
                    this.rollbackTransaction();
                    break block43;
                }
                this.commitTransaction();
            }
            try {
                this.closeTransaction();
            }
            catch (Exception e) {
                message = "Unable to close indexing" + e.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                this.eventHandler.fireException(e);
            }
            try {
                this.configHandler.indexingPostamble(!this.getStop());
            }
            catch (Exception e) {
                message = "Unable to close indexing" + e.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                this.eventHandler.fireException(e);
            }
            try {
                if (catalog != null) {
                    catalog.dispose();
                }
                break block44;
            }
            catch (RuntimeException e) {
                message = "Failed to dispose harvesting catalog";
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message, e);
                }
                break block44;
            }
            catch (Exception e) {
                String message22;
                try {
                    LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                    try {
                        this.rollbackTransaction();
                    }
                    catch (IOException e1) {
                        throw new IllegalStateException(e1);
                    }
                }
                catch (Throwable throwable) {
                    block45: {
                        String message32;
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e2) {
                            message32 = "Unable to close indexing" + e2.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message32, e2);
                            }
                            this.eventHandler.fireException(e2);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                        }
                        catch (Exception e3) {
                            message32 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message32, e3);
                            }
                            this.eventHandler.fireException(e3);
                        }
                        try {
                            if (catalog != null) {
                                catalog.dispose();
                            }
                        }
                        catch (RuntimeException e4) {
                            message32 = "Failed to dispose harvesting catalog";
                            if (!LOGGER.isLoggable(Level.WARNING)) break block45;
                            LOGGER.log(Level.WARNING, message32, e4);
                        }
                    }
                    throw throwable;
                }
                try {
                    this.closeTransaction();
                }
                catch (Exception e5) {
                    message22 = "Unable to close indexing" + e5.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e5);
                    }
                    this.eventHandler.fireException(e5);
                }
                try {
                    this.configHandler.indexingPostamble(!this.getStop());
                }
                catch (Exception e6) {
                    message22 = "Unable to close indexing" + e6.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e6);
                    }
                    this.eventHandler.fireException(e6);
                }
                try {
                    if (catalog != null) {
                        catalog.dispose();
                    }
                }
                catch (RuntimeException e7) {
                    message22 = "Failed to dispose harvesting catalog";
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message22, e7);
                    }
                }
            }
        }
    }

    private void processGranules(GranuleCatalog catalog, String requestedTypeName) throws IOException {
        Query query = new Query(requestedTypeName);
        Integer maxInitializationTiles = IndexerUtils.getParameterAsInteger("MaxInitTiles", this.configHandler.getRunConfiguration().getIndexer());
        if (maxInitializationTiles != null) {
            query.setMaxFeatures(maxInitializationTiles);
        }
        SimpleFeatureCollection coll = catalog.getGranules(query);
        int numFiles = 0;
        try (SimpleFeatureIterator it = coll.features();){
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                this.consumer.handleElement(feature, this);
                ++numFiles;
                if (!this.getStop()) continue;
                break;
            }
        }
        this.setNumElements(numFiles);
    }
}

