/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.util.Date;
import java.util.EmptyStackException;
import java.util.Stack;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.PeriodNode;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.SuppressFBWarnings;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.temporal.Period;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_EXCEPTION"})
public final class BuildResultStack {
    private final Stack<Result> stack = new Stack();
    private final String cqlSource;

    public BuildResultStack(String cqlSource) {
        assert (cqlSource != null);
        this.cqlSource = cqlSource;
    }

    public Result peek() {
        return this.stack.peek();
    }

    public boolean empty() {
        return this.stack.empty();
    }

    public Result popResult() throws CQLException {
        return this.stack.pop();
    }

    public Expression popExpression() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            return (Expression)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Expression", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public Literal popLiteral() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            return (Literal)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Literal", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public PropertyName popPropertyName() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            return (PropertyName)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Property", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public Filter popFilter() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            return (Filter)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Filter", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public PeriodNode popPeriodNode() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            return (PeriodNode)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Period", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public Period popPeriod() throws CQLException {
        Result item = null;
        try {
            item = this.stack.pop();
            PeriodNode periodNode = (PeriodNode)item.getBuilt();
            Literal begin = periodNode.getBeginning();
            Literal end = periodNode.getEnding();
            DefaultPosition ip1 = new DefaultPosition((Date)begin.getValue());
            DefaultPosition ip2 = new DefaultPosition((Date)end.getValue());
            DefaultPeriod period = new DefaultPeriod(new DefaultInstant(ip1), new DefaultInstant(ip2));
            return period;
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expecting Period", item.getToken(), cce, this.cqlSource);
        }
        catch (EmptyStackException ese) {
            throw new CQLException("No items on stack");
        }
    }

    public double popDoubleValue() throws CQLException {
        try {
            Literal expr = this.popLiteral();
            Double number = Double.valueOf(expr.getValue().toString());
            return number;
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expected double");
        }
    }

    public int popIntegerValue() throws CQLException {
        try {
            Literal expr = this.popLiteral();
            Number number = (Number)expr.getValue();
            return number.intValue();
        }
        catch (ClassCastException cce) {
            throw new CQLException("Expected integer");
        }
    }

    public String popStringValue() throws CQLException {
        Literal literal = this.popLiteral();
        return literal.toString();
    }

    public String popIdentifierPart() throws CQLException {
        try {
            Result resultPart = this.stack.pop();
            IToken token = resultPart.getToken();
            return token.toString();
        }
        catch (ClassCastException e) {
            throw new CQLException("identifier part is expected");
        }
    }

    public String popIdentifier() throws CQLException {
        try {
            Result result = this.stack.pop();
            String identifier = (String)result.getBuilt();
            return identifier;
        }
        catch (ClassCastException e) {
            throw new CQLException("fail in identifier parsing");
        }
    }

    public Geometry popGeometry() throws CQLException {
        try {
            Result result = this.stack.pop();
            Geometry g = (Geometry)result.getBuilt();
            return g;
        }
        catch (ClassCastException e) {
            throw new CQLException("fail in geometry parsing");
        }
    }

    public void push(Result item) {
        this.stack.push(item);
    }

    public int size() {
        return this.stack.size();
    }
}

