/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.BaseSimpleFeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PagingFeatureCollection
extends BaseSimpleFeatureCollection {
    protected static final Logger LOGGER = Logging.getLogger(PagingFeatureCollection.class);
    final Integer matched;
    SimpleFeatureCollection first;
    ObjectNode next;

    public PagingFeatureCollection(SimpleFeatureCollection first, ObjectNode next, Integer matched) {
        super((SimpleFeatureType)first.getSchema());
        this.first = first;
        this.next = next;
        this.matched = matched;
    }

    public Integer getMatched() {
        return this.matched;
    }

    @Override
    public int size() {
        if (this.matched != null) {
            return this.matched;
        }
        return super.size();
    }

    @Override
    public SimpleFeatureIterator features() {
        return new PagingFeatureIterator(this.first.features(), this.next);
    }

    protected SimpleFeatureCollection readNext(ObjectNode next) throws IOException {
        if (next == null) {
            return null;
        }
        JsonNode href = next.get("href");
        if (href == null) {
            return null;
        }
        LOGGER.fine(() -> "Fetching next page of data at " + href.textValue());
        try (GeoJSONReader reader = new GeoJSONReader(new URL(href.textValue()));){
            SimpleFeatureCollection simpleFeatureCollection = reader.getFeatures();
            return simpleFeatureCollection;
        }
    }

    protected class PagingFeatureIterator
    implements SimpleFeatureIterator {
        private SimpleFeatureIterator delegate;
        private ObjectNode next;

        public PagingFeatureIterator(SimpleFeatureIterator delegate, ObjectNode next) {
            this.delegate = delegate;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            while (!this.delegate.hasNext() && this.next != null) {
                try {
                    SimpleFeatureCollection features = PagingFeatureCollection.this.readNext(this.next);
                    this.delegate = features.features();
                    if (features instanceof PagingFeatureCollection) {
                        this.next = ((PagingFeatureCollection)features).next;
                        continue;
                    }
                    this.next = null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Switching to the next page failed", e);
                }
            }
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (SimpleFeature)this.delegate.next();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

