/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.rest.controller.GWCSeedingController;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.seed.MassTruncateRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.seed.TruncateBboxRequest;
import org.geowebcache.seed.TruncateLayerRequest;
import org.geowebcache.seed.TruncateOrphansRequest;
import org.geowebcache.seed.TruncateParametersRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class MassTruncateController
extends GWCSeedingController {
    private static Logger log = Logging.getLogger((String)MassTruncateController.class.getName());
    @Autowired
    private StorageBroker broker;
    @Autowired
    private TileBreeder breeder;
    static final Class<?>[] DEFAULT_REQUEST_TYPES = new Class[]{TruncateLayerRequest.class, TruncateParametersRequest.class, TruncateOrphansRequest.class, TruncateBboxRequest.class};
    Class<?>[] requestTypes;

    @Autowired
    public MassTruncateController(ApplicationContextProvider appCtx) {
        super(appCtx);
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity<?> handleRestException(RestException ex) {
        return new ResponseEntity((Object)ex.toString(), ex.getStatus());
    }

    public void setStorageBroker(StorageBroker broker) {
        this.broker = broker;
    }

    public void setTileBreeder(TileBreeder breeder) {
        this.breeder = breeder;
    }

    @Override
    @RequestMapping(value={"/masstruncate"}, method={RequestMethod.GET})
    public ResponseEntity<?> doGet(HttpServletRequest req) {
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream());
        StringBuilder sb = new StringBuilder();
        HashSet<String> result = new HashSet<String>();
        sb.append("<massTruncateRequests href=\"").append(req.getRequestURL()).append("\">");
        for (Class<?> requestType : this.getRequestTypes()) {
            String alias = xs.getMapper().serializedClass(requestType);
            sb.append(" <requestType>");
            sb.append(alias);
            sb.append("</requestType>");
            if (result.add(alias) || !log.isLoggable(Level.WARNING)) continue;
            log.warning("Duplicate MassTruncate RestException type: " + alias);
        }
        sb.append("</massTruncateRequests>");
        return new ResponseEntity((Object)sb.toString(), HttpStatus.OK);
    }

    @RequestMapping(value={"/masstruncate"}, method={RequestMethod.POST})
    public ResponseEntity<?> doPost(HttpServletRequest req) throws IOException {
        String contentType = req.getContentType();
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()));
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)req.getInputStream(), (Writer)writer, (Charset)Charset.defaultCharset());
        String reqData = writer.toString();
        Object obj = null;
        if (contentType == null || contentType.equalsIgnoreCase("text/xml")) {
            obj = xs.fromXML(reqData);
        } else if (contentType.equalsIgnoreCase("json")) {
            obj = xs.fromXML(this.convertJson(reqData));
        } else if (contentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            obj = xs.fromXML(URLDecoder.decode(reqData, Charset.defaultCharset().name()));
        } else {
            throw new RestException("Format extension unknown or not specified: " + contentType, HttpStatus.BAD_REQUEST);
        }
        MassTruncateRequest mtr = (MassTruncateRequest)obj;
        try {
            if (!mtr.doTruncate(this.broker, this.breeder)) {
                throw new RestException("Truncation failed", HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (GeoWebCacheException | StorageException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return mtr.getResponse(contentType);
    }

    @Override
    protected void handleRequest(HttpServletRequest req, HttpServletResponse resp, Object obj) {
        MassTruncateRequest mtr = (MassTruncateRequest)obj;
        try {
            if (!mtr.doTruncate(this.broker, this.breeder)) {
                throw new RestException("Truncation failed", HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (GeoWebCacheException | StorageException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected Class<?>[] getRequestTypes() {
        if (this.requestTypes == null) {
            this.requestTypes = DEFAULT_REQUEST_TYPES;
        }
        return this.requestTypes;
    }

    @Override
    protected XStream configXStream(XStream xs) {
        xs = super.configXStream(xs);
        xs.processAnnotations((Class[])this.getRequestTypes());
        return xs;
    }
}

