/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.jdbc.config.JDBCSecurityServiceConfig;
import org.geoserver.security.web.jdbc.JDBCDriverChoice;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class JDBCConnectionPanel<T extends JDBCSecurityServiceConfig>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    FeedbackPanel feedbackPanel;

    public JDBCConnectionPanel(String id, IModel<T> model) {
        super(id, (IModel)new Model());
        this.add(new Component[]{new AjaxCheckBox("jndi"){

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)JDBCConnectionPanel.this.get("cxPanelContainer");
                ((ConnectionPanel)c.get("cxPanel")).resetModel();
                c.addOrReplace(new Component[]{JDBCConnectionPanel.this.createCxPanel("cxPanel", (Boolean)this.getModelObject())});
                target.add(new Component[]{c});
            }
        }});
        boolean useJNDI = ((JDBCSecurityServiceConfig)model.getObject()).isJndi();
        this.add(new Component[]{new WebMarkupContainer("cxPanelContainer").add(new Component[]{this.createCxPanel("cxPanel", useJNDI)}).setOutputMarkupId(true)});
        this.add(new Component[]{new AjaxSubmitLink("cxTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    ((ConnectionPanel)JDBCConnectionPanel.this.get("cxPanelContainer:cxPanel")).test();
                    this.info((Serializable)new StringResourceModel("connectionSuccessful", (Component)JDBCConnectionPanel.this, null).getObject());
                }
                catch (Exception e) {
                    try {
                        this.error(e);
                        LOGGER.log(Level.WARNING, "Connection error", e);
                    }
                    catch (Throwable throwable) {
                        target.add(new Component[]{JDBCConnectionPanel.this.feedbackPanel});
                        throw throwable;
                    }
                    target.add(new Component[]{JDBCConnectionPanel.this.feedbackPanel});
                }
                target.add(new Component[]{JDBCConnectionPanel.this.feedbackPanel});
            }
        }.setDefaultFormProcessing(false)});
        Component[] componentArray = new Component[1];
        this.feedbackPanel = new FeedbackPanel("feedback");
        componentArray[0] = this.feedbackPanel;
        this.add(componentArray);
        this.feedbackPanel.setOutputMarkupId(true);
    }

    ConnectionPanel createCxPanel(String id, boolean useJNDI) {
        return useJNDI ? new JNDIConnectionPanel(id) : new BasicConnectionPanel(id);
    }

    class JNDIConnectionPanel
    extends ConnectionPanel {
        public JNDIConnectionPanel(String id) {
            super(id);
            this.add(new Component[]{new TextField("jndiName").setRequired(true)});
        }

        @Override
        public void resetModel() {
        }

        @Override
        public void test() throws Exception {
            ((FormComponent)this.get("jndiName")).processInput();
            Object lookedUp = GeoTools.jndiLookup((String)this.get("jndiName").getDefaultModelObjectAsString());
            if (lookedUp == null) {
                throw new IllegalArgumentException("Failed to look up an object from JNDI at the given location");
            }
            if (!(lookedUp instanceof DataSource)) {
                LOGGER.log(Level.WARNING, "Was trying to look up a DataSource in JNDI, but got this instead: " + lookedUp);
                throw new IllegalArgumentException("JNDI lookup did not provide a DataSource");
            }
            Connection con = ((DataSource)lookedUp).getConnection();
            Throwable throwable = null;
            if (con != null) {
                if (throwable != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    con.close();
                }
            }
        }
    }

    class BasicConnectionPanel
    extends ConnectionPanel {
        public BasicConnectionPanel(String id) {
            super(id);
            this.add(new Component[]{new JDBCDriverChoice("driverClassName").setRequired(true)});
            this.add(new Component[]{new TextField("connectURL").setRequired(true)});
            this.add(new Component[]{new TextField("userName").setRequired(true)});
            PasswordTextField pwdField = new PasswordTextField("password");
            pwdField.setRequired(false);
            pwdField.setResetPassword(false);
            this.add(new Component[]{pwdField});
        }

        @Override
        public void resetModel() {
        }

        @Override
        public void test() throws Exception {
            ((FormComponent)this.get("driverClassName")).processInput();
            ((FormComponent)this.get("connectURL")).processInput();
            ((FormComponent)this.get("userName")).processInput();
            ((FormComponent)this.get("password")).processInput();
            Class.forName(this.get("driverClassName").getDefaultModelObjectAsString());
            Connection cx = DriverManager.getConnection(this.get("connectURL").getDefaultModelObjectAsString(), this.get("userName").getDefaultModelObjectAsString(), this.get("password").getDefaultModelObjectAsString());
            Throwable throwable = null;
            if (cx != null) {
                if (throwable != null) {
                    try {
                        cx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    cx.close();
                }
            }
        }
    }

    abstract class ConnectionPanel
    extends FormComponentPanel<Serializable> {
        public ConnectionPanel(String id) {
            super(id, (IModel)new Model());
        }

        public abstract void resetModel();

        public abstract void test() throws Exception;
    }
}

