/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.diskquota.storage.PagePyramid;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.springframework.util.Assert;

public class TilePageCalculator {
    private static final Logger log = Logging.getLogger((String)TilePageCalculator.class.getName());
    private TileLayerDispatcher tld;
    private StorageBroker sb;

    public TilePageCalculator(TileLayerDispatcher tld, StorageBroker sb) {
        this.tld = tld;
        this.sb = sb;
    }

    public TilePage pageForTile(TileSet tileSet, long[] tileIndex) {
        int[] pageIndexForTile = new int[3];
        this.pageIndexForTile(tileSet, tileIndex, null);
        String tileSetId = tileSet.getId();
        int pageX = pageIndexForTile[0];
        int pageY = pageIndexForTile[1];
        byte zoomLevel = (byte)pageIndexForTile[2];
        return new TilePage(tileSetId, pageX, pageY, zoomLevel);
    }

    public int[] pageIndexForTile(TileSet tileSet, long[] tileIndex, int[] pageIndexTarget) {
        Assert.notNull((Object)tileSet, (String)"TileSet must be non null");
        Assert.notNull((Object)tileIndex, (String)"TileIndex must be non null");
        Assert.isTrue((pageIndexTarget != null && pageIndexTarget.length > 2 ? 1 : 0) != 0, (String)"PageIndexTarget must be non null and have at least a size of 2");
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        pagePyramid.pageIndexForTile(tileIndex[0], tileIndex[1], (int)tileIndex[2], pageIndexTarget);
        return pageIndexTarget;
    }

    private PagePyramid getPagePyramid(TileSet tileSet) {
        PagePyramid pagePyramid = this.newPagePyramid(tileSet);
        return pagePyramid;
    }

    public BigInteger getTilesPerPage(TileSet tileSet, int zoomLevel) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        PagePyramid.PageLevelInfo pageInfo = pagePyramid.getPageInfo(zoomLevel);
        BigInteger tilesPerPage = pageInfo.tilesPerPage;
        return tilesPerPage;
    }

    public long[][] toGridCoverage(TileSet tileSet, TilePage page) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        int pageX = page.getPageX();
        int pageY = page.getPageY();
        byte level = page.getZoomLevel();
        long[][] gridCoverage = pagePyramid.toGridCoverage(pageX, pageY, level);
        return gridCoverage;
    }

    public Set<String> getLayerNames() {
        return this.tld.getLayerNames();
    }

    public Set<TileSet> getTileSetsFor(String layerName) {
        return this.getTileSetsFor(layerName, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Set<TileSet> getTileSetsFor(String layerName, Collection<GridSubset> gridSubSets, List<MimeType> mimeTypes) {
        return this.getTileSetsFor(layerName, Optional.of(gridSubSets), Optional.of(mimeTypes), Optional.empty());
    }

    public Set<TileSet> getTileSetsFor(String layerName, Optional<? extends Collection<GridSubset>> optGridSubsets, Optional<? extends Collection<MimeType>> optMimeTypes, Optional<? extends Collection<String>> optParameterIds) {
        TileLayer tileLayer;
        if (!optGridSubsets.isPresent() || !optMimeTypes.isPresent()) {
            try {
                tileLayer = this.tld.getTileLayer(layerName);
            }
            catch (GeoWebCacheException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            tileLayer = null;
        }
        Collection<String> gridsetNames = this.getGridSubsetNames(optGridSubsets, tileLayer);
        Collection<String> formatNames = this.getFormatNames(optMimeTypes, tileLayer);
        Collection<String> parameterIds = this.getParameterIds(layerName, optParameterIds);
        HashSet<TileSet> set = new HashSet<TileSet>();
        for (String gridset : gridsetNames) {
            for (String format : formatNames) {
                for (String parametersId : parameterIds) {
                    TileSet tileSet = new TileSet(layerName, gridset, format, parametersId);
                    set.add(tileSet);
                }
            }
        }
        return set;
    }

    private Collection<String> getGridSubsetNames(Optional<Collection<GridSubset>> gridSubsets, TileLayer tileLayer) {
        return gridSubsets.map(Collection::stream).map(stream -> stream.map(GridSubset::getName)).map(stream -> stream.collect(Collectors.toSet())).orElseGet(() -> tileLayer.getGridSubsets());
    }

    private Collection<String> getFormatNames(Optional<Collection<MimeType>> mimeTypes, TileLayer tileLayer) {
        return mimeTypes.map(Collection::stream).orElseGet(() -> tileLayer.getMimeTypes().stream()).map(MimeType::getFormat).collect(Collectors.toList());
    }

    private Collection<String> getParameterIds(String layerName, Optional<Collection<String>> parameterIds) {
        return parameterIds.orElseGet(() -> {
            try {
                return this.sb.getCachedParameterIds(layerName);
            }
            catch (StorageException e) {
                log.log(Level.SEVERE, "Error while retreiving cached parameter IDs for layer " + layerName, e);
                return Collections.emptySet();
            }
        });
    }

    private PagePyramid newPagePyramid(TileSet tileSet) {
        TileLayer tileLayer;
        String layerName = tileSet.getLayerName();
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e);
        }
        String gridsetId = tileSet.getGridsetId();
        GridSubset gridSubset = tileLayer.getGridSubset(gridsetId);
        return this.newPagePyramid(gridSubset);
    }

    PagePyramid newPagePyramid(GridSubset gridSubset) {
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        long[][] coverages = gridSubset.getCoverages();
        PagePyramid pagePyramid = new PagePyramid(coverages, zoomStart, zoomStop);
        return pagePyramid;
    }
}

