/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.AbstractMonitor;
import org.geowebcache.diskquota.QueuedUsageStatsConsumer;
import org.geowebcache.diskquota.QueuedUsageStatsProducer;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.UsageStats;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.TileLayerListener;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class UsageStatsMonitor
extends AbstractMonitor {
    private static final Logger log = Logging.getLogger((String)UsageStatsMonitor.class.getName());
    private static final CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota Usage Stats Gathering Thread-");
    private final QuotaStore quotaStore;
    private final TileLayerDispatcher tileLayerDispatcher;
    private final TilePageCalculator tilePageCalculator;
    private BlockingQueue<UsageStats> sharedQueue;
    private QueuedUsageStatsProducer usageStatsProducer;
    private QueuedUsageStatsConsumer usageStatsConsumer;

    public UsageStatsMonitor(QuotaStore quotaStore, TileLayerDispatcher tileLayerDispatcher) {
        Assert.notNull((Object)quotaStore, (String)"quotaStore is null");
        Assert.notNull((Object)tileLayerDispatcher, (String)"tileLayerDispatcher is null");
        this.quotaStore = quotaStore;
        this.tileLayerDispatcher = tileLayerDispatcher;
        this.tilePageCalculator = quotaStore.getTilePageCalculator();
    }

    @Override
    public void startUp() {
        super.startUp();
        this.sharedQueue = new LinkedBlockingQueue<UsageStats>(1000);
        this.usageStatsConsumer = new QueuedUsageStatsConsumer(this.quotaStore, this.sharedQueue, this.tilePageCalculator);
        this.getExecutorService().submit(this.usageStatsConsumer);
        this.usageStatsProducer = new QueuedUsageStatsProducer(this.sharedQueue);
        Iterable allLayers = this.tileLayerDispatcher.getLayerList();
        for (TileLayer layer : allLayers) {
            layer.addLayerListener((TileLayerListener)this.usageStatsProducer);
        }
    }

    @Override
    protected void shutDown(boolean cancel) {
        Iterable allLayers = this.tileLayerDispatcher.getLayerList();
        for (TileLayer layer : allLayers) {
            try {
                layer.removeLayerListener((TileLayerListener)this.usageStatsProducer);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Unexpected exception while removing the usage stats listener from layer '" + layer + "'. Ignoring in order to continue with the monitor's shutdown process", e);
            }
        }
        this.usageStatsConsumer.shutdown();
        if (cancel) {
            this.usageStatsProducer.setCancelled(true);
            this.getExecutorService().shutdownNow();
        } else {
            this.getExecutorService().shutdown();
        }
        this.sharedQueue = null;
    }

    @Override
    protected CustomizableThreadFactory getThreadFactory() {
        return tf;
    }
}

