/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.diskquota.AbstractMonitor;
import org.geowebcache.diskquota.QueuedQuotaUpdatesConsumer;
import org.geowebcache.diskquota.QueuedQuotaUpdatesProducer;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdate;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageBroker;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class QuotaUpdatesMonitor
extends AbstractMonitor {
    private static final Logger log = Logging.getLogger((String)QuotaUpdatesMonitor.class.getName());
    private static final CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota Updates Gathering Thread-");
    private final StorageBroker storageBroker;
    private final QuotaStore quotaStore;
    private BlockingQueue<QuotaUpdate> sharedQueue;
    private QueuedQuotaUpdatesProducer quotaDiffsProducer;
    private QueuedQuotaUpdatesConsumer quotaUsageUpdatesConsumer;

    public QuotaUpdatesMonitor(StorageBroker storageBroker, QuotaStore quotaStore) {
        Assert.notNull((Object)storageBroker, (String)"storageBroker is null");
        Assert.notNull((Object)quotaStore, (String)"quotaStore is null");
        this.storageBroker = storageBroker;
        this.quotaStore = quotaStore;
        String sizeStr = GeoWebCacheExtensions.getProperty((String)"GEOWEBCACHE_QUOTA_QUEUE_SIZE");
        int quotaQueueSize = 1000;
        if (sizeStr != null) {
            quotaQueueSize = Integer.parseInt(sizeStr);
        }
        this.sharedQueue = quotaQueueSize > 0 ? new LinkedBlockingQueue<QuotaUpdate>(quotaQueueSize) : new LinkedBlockingQueue<QuotaUpdate>();
    }

    @Override
    public void startUp() {
        super.startUp();
        this.quotaDiffsProducer = new QueuedQuotaUpdatesProducer(this.sharedQueue, this.quotaStore);
        this.quotaUsageUpdatesConsumer = new QueuedQuotaUpdatesConsumer(this.quotaStore, this.sharedQueue);
        this.storageBroker.addBlobStoreListener((BlobStoreListener)this.quotaDiffsProducer);
        this.getExecutorService().submit(this.quotaUsageUpdatesConsumer);
    }

    @Override
    protected void shutDown(boolean cancel) {
        log.fine("Shutting down quota usage monitor...");
        try {
            this.storageBroker.removeBlobStoreListener((BlobStoreListener)this.quotaDiffsProducer);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Unexpected exception while removing the disk quota monitor listener from the StorageBroker. Ignoring in order to continue with the monitor's shutdown process", e);
        }
        if (cancel) {
            this.quotaDiffsProducer.setCancelled(true);
            this.getExecutorService().shutdownNow();
        } else {
            this.getExecutorService().shutdown();
        }
        this.sharedQueue = null;
    }

    @Override
    public void shutDown() {
        this.quotaUsageUpdatesConsumer.shutdown();
        super.shutDown();
    }

    public void tileStored(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize) {
        this.quotaDiffsProducer.tileStored(layerName, gridSetId, blobFormat, parametersId, x, y, z, blobSize);
    }

    @Override
    protected CustomizableThreadFactory getThreadFactory() {
        return tf;
    }
}

