/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdate;
import org.geowebcache.storage.BlobStoreListener;
import org.springframework.util.Assert;

class QueuedQuotaUpdatesProducer
implements BlobStoreListener {
    private static final Logger log = Logging.getLogger((String)QueuedQuotaUpdatesProducer.class.getName());
    private final BlockingQueue<QuotaUpdate> queuedUpdates;
    private boolean cancelled;
    private final QuotaStore quotaStore;
    int updateOfferTimeoutSeconds;

    public QueuedQuotaUpdatesProducer(BlockingQueue<QuotaUpdate> queuedUpdates, QuotaStore quotaStore) {
        Assert.notNull(queuedUpdates, (String)"queuedUpdates can't be null");
        this.queuedUpdates = queuedUpdates;
        this.quotaStore = quotaStore;
        String timeoutStr = GeoWebCacheExtensions.getProperty((String)"GEOWEBCACHE_QUOTA_DIFF_TIMEOUT");
        this.updateOfferTimeoutSeconds = 300;
        if (timeoutStr != null) {
            this.updateOfferTimeoutSeconds = Integer.parseInt(timeoutStr);
        }
    }

    public void tileStored(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize) {
        if (blobSize == 0L) {
            return;
        }
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, blobSize, new long[]{x, y, z});
    }

    public void tileDeleted(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize) {
        long actualSizeFreed = -1L * blobSize;
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, actualSizeFreed, new long[]{x, y, z});
    }

    public void tileUpdated(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize, long oldSize) {
        long delta = blobSize - oldSize;
        if (delta == 0L) {
            return;
        }
        long[] tileIndex = new long[]{x, y, z};
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, delta, tileIndex);
    }

    public void layerDeleted(String layerName) {
        this.quotaStore.deleteLayer(layerName);
    }

    public void gridSubsetDeleted(String layerName, String gridSetId) {
        this.quotaStore.deleteGridSubset(layerName, gridSetId);
    }

    public void parametersDeleted(String layerName, String parametersId) {
        this.quotaStore.deleteParameters(layerName, parametersId);
    }

    public void layerRenamed(String oldLayerName, String newLayerName) {
        try {
            this.quotaStore.renameLayer(oldLayerName, newLayerName);
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, "Can't rename " + oldLayerName + " to " + newLayerName + " in quota store", e);
            Thread.currentThread().interrupt();
        }
    }

    private void quotaUpdate(String layerName, String gridSetId, String blobFormat, String parametersId, long amount, long[] tileIndex) {
        if (this.cancelled(layerName)) {
            return;
        }
        QuotaUpdate payload = new QuotaUpdate(layerName, gridSetId, blobFormat, parametersId, amount, tileIndex);
        try {
            if (this.updateOfferTimeoutSeconds <= 0) {
                this.queuedUpdates.put(payload);
            } else if (!this.queuedUpdates.offer(payload, this.updateOfferTimeoutSeconds, TimeUnit.SECONDS)) {
                throw new RuntimeException("Failed to offer the quota diff to the updates queue within the configured timeout of " + this.updateOfferTimeoutSeconds + " seconds");
            }
        }
        catch (InterruptedException e) {
            if (this.cancelled(layerName)) {
                return;
            }
            log.info("Quota updates on " + layerName + " abruptly interrupted on thread " + Thread.currentThread().getName() + ".");
            Thread.currentThread().interrupt();
        }
    }

    private boolean cancelled(String layerName) {
        if (this.cancelled) {
            log.fine("Quota updates listener cancelled. Avoiding adding update for layer " + layerName + " to quota information queue");
        }
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

