/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.QuotaUpdatesMonitor;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.geowebcache.util.FileUtils;

final class LayerCacheInfoBuilder {
    private static final Logger log = Logging.getLogger((String)LayerCacheInfoBuilder.class.getName());
    private final File rootCacheDir;
    private final ExecutorService threadPool;
    private final Map<String, List<Future<?>>> perLayerRunningTasks;
    private final QuotaUpdatesMonitor quotaUsageMonitor;
    private boolean closed = false;

    public LayerCacheInfoBuilder(File rootCacheDir, ExecutorService threadPool, QuotaUpdatesMonitor quotaUsageMonitor) {
        this.rootCacheDir = rootCacheDir;
        this.threadPool = threadPool;
        this.quotaUsageMonitor = quotaUsageMonitor;
        this.perLayerRunningTasks = new HashMap();
    }

    public void buildCacheInfo(TileLayer tileLayer) {
        String layerName = tileLayer.getName();
        String layerDirName = FilePathUtils.filteredLayerName((String)layerName);
        File layerDir = new File(this.rootCacheDir, layerDirName);
        if (!layerDir.exists()) {
            return;
        }
        this.perLayerRunningTasks.put(layerName, new ArrayList());
        Future<?> tilesetCollector = this.threadPool.submit(() -> this.gatherStatsByTileset(tileLayer, layerName, layerDir));
        this.perLayerRunningTasks.get(layerName).add(tilesetCollector);
    }

    private void gatherStatsByTileset(TileLayer tileLayer, String layerName, File layerDir) {
        Set<TileSet> onDiskTileSets = this.findOnDiskTileSets(tileLayer, layerDir);
        for (TileSet tileSet : onDiskTileSets) {
            String gridSetId = tileSet.getGridsetId();
            String parametersId = tileSet.getParametersId();
            GridSubset gs = tileLayer.getGridSubset(gridSetId);
            int zoomStart = gs.getZoomStart();
            int zoomStop = gs.getZoomStop();
            for (int zoomLevel = zoomStart; zoomLevel <= zoomStop && !this.closed; ++zoomLevel) {
                File gridsetZLevelDir;
                String gridsetZLevelParamsDirName = FilePathUtils.gridsetZoomLevelDir((String)gridSetId, (long)zoomLevel);
                if (parametersId != null) {
                    gridsetZLevelParamsDirName = gridsetZLevelParamsDirName + "_" + parametersId;
                }
                if (!(gridsetZLevelDir = new File(layerDir, gridsetZLevelParamsDirName)).exists()) continue;
                ZoomLevelVisitor cacheInfoBuilder = new ZoomLevelVisitor(layerName, gridsetZLevelDir, gridSetId, zoomLevel, parametersId, this.quotaUsageMonitor);
                Future<ZoomLevelVisitor.Stats> cacheTask = this.threadPool.submit(cacheInfoBuilder);
                this.perLayerRunningTasks.get(layerName).add(cacheTask);
                log.fine("Submitted background task to gather cache info for '" + layerName + "'/" + gridSetId + "/" + zoomLevel);
            }
        }
    }

    private Set<TileSet> findOnDiskTileSets(TileLayer tileLayer, File layerDir) {
        String layerName = tileLayer.getName();
        Set griSetNames = tileLayer.getGridSubsets();
        HashSet<TileSet> foundTileSets = new HashSet<TileSet>();
        for (String gridSetName : griSetNames) {
            File[] thisGridSetDirs;
            String gridSetDirPrefix = FilePathUtils.filteredGridSetId((String)gridSetName);
            FileFilter prefixFilter = pathname -> {
                if (!pathname.isDirectory()) {
                    return false;
                }
                return pathname.getName().startsWith(gridSetDirPrefix + "_");
            };
            for (File directory : thisGridSetDirs = FileUtils.listFilesNullSafe((File)layerDir, (FileFilter)prefixFilter)) {
                String dirName = directory.getName();
                String zlevelAndParamId = dirName.substring(1 + gridSetDirPrefix.length());
                String[] parts = zlevelAndParamId.split("_");
                String gridsetId = gridSetName;
                String blobFormat = null;
                String parametersId = null;
                if (parts.length == 2) {
                    parametersId = parts[1];
                }
                TileSet tileSet = new TileSet(layerName, gridsetId, blobFormat, parametersId);
                foundTileSets.add(tileSet);
            }
        }
        return foundTileSets;
    }

    public boolean isRunning(String layerName) {
        try {
            List<Future<?>> layerTasks = this.perLayerRunningTasks.get(layerName);
            if (layerTasks == null) {
                return false;
            }
            int numRunning = 0;
            Iterator<Future<?>> it = layerTasks.iterator();
            while (it.hasNext()) {
                Future<?> future = it.next();
                if (future.isDone()) {
                    it.remove();
                    continue;
                }
                ++numRunning;
            }
            return numRunning > 0;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return false;
        }
    }

    public void shutDown() {
        this.closed = true;
        this.threadPool.shutdownNow();
    }

    private final class ZoomLevelVisitor
    implements FileFilter,
    Callable<Stats> {
        private final String gridSetId;
        private int tileZ;
        private final File zoomLevelPath;
        private Stats stats;
        private final QuotaUpdatesMonitor quotaUsageMonitor;
        private final String layerName;
        private final String parametersId;

        public ZoomLevelVisitor(String layerName, File zoomLevelPath, String gridsetId, int zoomLevel, String parametersId, QuotaUpdatesMonitor quotaUsageMonitor) {
            this.layerName = layerName;
            this.zoomLevelPath = zoomLevelPath;
            this.gridSetId = gridsetId;
            this.parametersId = parametersId;
            this.quotaUsageMonitor = quotaUsageMonitor;
            this.tileZ = zoomLevel;
            this.stats = new Stats();
        }

        @Override
        public Stats call() throws Exception {
            String zLevelKey = this.layerName + "'/" + this.gridSetId + "/paramId:" + (this.parametersId == null ? "default" : this.parametersId) + "/zlevel:" + this.tileZ;
            try {
                log.fine("Gathering cache information for '" + zLevelKey);
                this.stats.numTiles = 0L;
                this.stats.runTimeMillis = 0L;
                long runTime = System.currentTimeMillis();
                FileUtils.traverseDepth((File)this.zoomLevelPath, (FileFilter)this);
                this.stats.runTimeMillis = runTime = System.currentTimeMillis() - runTime;
            }
            catch (TraversalCanceledException cancel) {
                log.fine("Gathering cache information for " + zLevelKey + " was canceled.");
                return null;
            }
            catch (Exception e) {
                throw e;
            }
            log.fine("Cache information for " + zLevelKey + " collected in " + (double)this.stats.runTimeMillis / 1000.0 + "s. Counted " + this.stats.numTiles + " tiles for a storage space of " + this.stats.collectedQuota.toNiceString());
            return this.stats;
        }

        @Override
        public boolean accept(File file) {
            String blobFormat;
            if (LayerCacheInfoBuilder.this.closed) {
                throw new TraversalCanceledException();
            }
            if (file.isDirectory()) {
                log.finer("Processing files in " + file.getAbsolutePath());
                return true;
            }
            long length = file.length();
            String path = file.getPath();
            int fileNameIdx = 1 + path.lastIndexOf(File.separatorChar);
            int coordSepIdx = path.lastIndexOf(95);
            int dotIdx = path.lastIndexOf(46);
            String extension = FilenameUtils.getExtension((String)file.getName());
            try {
                blobFormat = MimeType.createFromExtension((String)extension).getFormat();
            }
            catch (MimeException e) {
                throw new RuntimeException(e);
            }
            long x = Long.valueOf(path.substring(fileNameIdx, coordSepIdx));
            long y = Long.valueOf(path.substring(1 + coordSepIdx, dotIdx));
            this.quotaUsageMonitor.tileStored(this.layerName, this.gridSetId, blobFormat, this.parametersId, x, y, this.tileZ, length);
            ++this.stats.numTiles;
            this.stats.collectedQuota.addBytes(length);
            return true;
        }

        private class TraversalCanceledException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private TraversalCanceledException() {
            }
        }

        private class Stats {
            long runTimeMillis;
            long numTiles;
            Quota collectedQuota = new Quota();

            private Stats() {
            }
        }
    }
}

