/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.math.BigInteger;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.TileRange;
import org.springframework.beans.factory.DisposableBean;

public class CacheCleaner
implements DisposableBean {
    private static final Logger log = Logging.getLogger((String)CacheCleaner.class.getName());
    private final TileBreeder tileBreeder;
    private boolean shutDown;

    public CacheCleaner(TileBreeder tileBreeder) {
        this.tileBreeder = tileBreeder;
    }

    public void destroy() throws Exception {
        this.shutDown = true;
    }

    public void expireByLayerNames(Set<String> layerNames, QuotaResolver quotaResolver, QuotaStore pageStore) throws InterruptedException {
        while (true) {
            if (this.shutDown || Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Quota limit = quotaResolver.getLimit();
            Quota used = quotaResolver.getUsed();
            Quota excess = used.difference(limit);
            if (excess.getBytes().compareTo(BigInteger.ZERO) <= 0) {
                log.info("Reached back Quota: " + limit.toNiceString() + " (" + used.toNiceString() + ") for layers " + layerNames);
                return;
            }
            ExpirationPolicy expirationPolicy = quotaResolver.getExpirationPolicy();
            if (null == expirationPolicy) {
                log.warning("Aborting disk quota enforcement task, no expiration policy defined for layers " + layerNames);
                return;
            }
            TilePage tilePage = null;
            if (ExpirationPolicy.LFU.equals((Object)expirationPolicy)) {
                tilePage = pageStore.getLeastFrequentlyUsedPage(layerNames);
            } else if (ExpirationPolicy.LRU.equals((Object)expirationPolicy)) {
                tilePage = pageStore.getLeastRecentlyUsedPage(layerNames);
            } else {
                throw new IllegalStateException("Unrecognized expiration policy: " + (Object)((Object)expirationPolicy));
            }
            if (tilePage == null) {
                limit = quotaResolver.getLimit();
                Quota usedQuota = quotaResolver.getUsed();
                if (excess.getBytes().compareTo(BigInteger.ZERO) > 0) {
                    log.warning("No more pages to expire, check if youd disk quota database is out of date with your blob store. Quota: " + limit.toNiceString() + " used: " + usedQuota.toNiceString());
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Expiring tile page " + tilePage + " based on the global " + (Object)((Object)expirationPolicy) + " expiration policy");
            }
            if (this.shutDown || Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.expirePage(pageStore, tilePage);
        }
    }

    private void expirePage(QuotaStore pageStore, TilePage tilePage) throws InterruptedException {
        MimeType mimeType;
        String tileSetId = tilePage.getTileSetId();
        TileSet tileSet = pageStore.getTileSetById(tileSetId);
        String layerName = tileSet.getLayerName();
        String gridSetId = tileSet.getGridsetId();
        String blobFormat = tileSet.getBlobFormat();
        String parametersId = tileSet.getParametersId();
        byte zoomLevel = tilePage.getZoomLevel();
        long[][] pageGridCoverage = pageStore.getTilesForPage(tilePage);
        try {
            mimeType = MimeType.createFromFormat((String)blobFormat);
        }
        catch (MimeException e) {
            throw new RuntimeException(e);
        }
        if (log.isLoggable(Level.FINER)) {
            if (parametersId != null) {
                log.finer("Expiring page " + tilePage + "/" + mimeType.getFormat() + "/" + parametersId);
            } else {
                log.finer("Expiring page " + tilePage + "/" + mimeType.getFormat());
            }
        }
        GWCTask truncateTask = this.createTruncateTaskForPage(layerName, gridSetId, zoomLevel, pageGridCoverage, mimeType, parametersId);
        try {
            truncateTask.doAction();
            pageStore.setTruncated(tilePage);
        }
        catch (InterruptedException e) {
            log.fine("Truncate task interrupted");
            Thread.currentThread().interrupt();
            return;
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
    }

    private GWCTask createTruncateTaskForPage(String layerName, String gridSetId, int zoomLevel, long[][] pageGridCoverage, MimeType mimeType, String parametersId) {
        GWCTask[] truncateTasks;
        int zoomStart = zoomLevel;
        int zoomStop = zoomLevel;
        TileRange tileRange = new TileRange(layerName, gridSetId, zoomStart, zoomStop, pageGridCoverage, mimeType, null, parametersId);
        boolean filterUpdate = false;
        try {
            truncateTasks = this.tileBreeder.createTasks(tileRange, GWCTask.TYPE.TRUNCATE, 1, filterUpdate);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        GWCTask truncateTask = truncateTasks[0];
        return truncateTask;
    }

    public static class LayerQuotaResolver
    implements QuotaResolver {
        private final LayerQuota layerQuota;
        private final QuotaStore store;

        public LayerQuotaResolver(LayerQuota layerQuota, QuotaStore store) {
            this.layerQuota = layerQuota;
            this.store = store;
        }

        @Override
        public Quota getLimit() {
            Quota limit = this.layerQuota.getQuota();
            if (limit == null) {
                limit = new Quota(BigInteger.valueOf(Long.MAX_VALUE));
            }
            return limit;
        }

        @Override
        public Quota getUsed() throws InterruptedException {
            String layer = this.layerQuota.getLayer();
            Quota usedQuotaByLayerName = this.store.getUsedQuotaByLayerName(layer);
            return usedQuotaByLayerName;
        }

        @Override
        public ExpirationPolicy getExpirationPolicy() {
            ExpirationPolicy expirationPolicy = this.layerQuota.getExpirationPolicyName();
            return expirationPolicy;
        }
    }

    public static class GlobalQuotaResolver
    implements QuotaResolver {
        private final DiskQuotaConfig config;
        private final QuotaStore store;

        public GlobalQuotaResolver(DiskQuotaConfig config, QuotaStore store) {
            this.config = config;
            this.store = store;
        }

        @Override
        public Quota getLimit() {
            return this.config.getGlobalQuota();
        }

        @Override
        public Quota getUsed() throws InterruptedException {
            return this.store.getGloballyUsedQuota();
        }

        @Override
        public ExpirationPolicy getExpirationPolicy() {
            return this.config.getGlobalExpirationPolicyName();
        }
    }

    public static interface QuotaResolver {
        public ExpirationPolicy getExpirationPolicy();

        public Quota getLimit();

        public Quota getUsed() throws InterruptedException;
    }
}

