/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.util.DimensionWarning;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.Info;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.rest.exception.RestException;
import org.springframework.http.HttpStatus;

public class GWCGeoServerRESTConfigurationProvider
implements ContextualConfigurationProvider {
    private final Catalog catalog;

    public GWCGeoServerRESTConfigurationProvider(Catalog catalog) {
        this.catalog = catalog;
    }

    public XStream getConfiguredXStream(XStream xs) {
        xs.alias("GeoServerLayer", GeoServerTileLayer.class);
        xs.alias("warning", DimensionWarning.WarningType.class);
        xs.allowTypes(new Class[]{DimensionWarning.WarningType.class});
        xs.processAnnotations(GeoServerTileLayerInfoImpl.class);
        xs.processAnnotations(StyleParameterFilter.class);
        xs.registerConverter((Converter)new RESTConverterHelper());
        xs.addDefaultImplementation(GeoServerTileLayerInfoImpl.class, GeoServerTileLayerInfo.class);
        xs.addDefaultImplementation(LinkedHashSet.class, Set.class);
        xs.omitField(StyleParameterFilter.class, "availableStyles");
        xs.omitField(StyleParameterFilter.class, "defaultStyle");
        return xs;
    }

    public boolean appliesTo(ContextualConfigurationProvider.Context ctxt) {
        return ContextualConfigurationProvider.Context.REST == ctxt;
    }

    public boolean canSave(Info i) {
        return false;
    }

    private final class RESTConverterHelper
    implements Converter {
        private RESTConverterHelper() {
        }

        public boolean canConvert(Class type) {
            return GeoServerTileLayer.class.equals((Object)type);
        }

        public GeoServerTileLayer unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String actualName;
            GeoServerTileLayerInfoImpl current = new GeoServerTileLayerInfoImpl();
            Class<GeoServerTileLayerInfo> type = GeoServerTileLayerInfo.class;
            GeoServerTileLayerInfo info = (GeoServerTileLayerInfo)context.convertAnother((Object)current, type);
            String id = info.getId();
            String name = info.getName();
            if (id != null && id.length() == 0) {
                id = null;
            }
            if (name != null && name.length() == 0) {
                name = null;
            }
            if (name == null) {
                throw new RestException("Layer name not provided", HttpStatus.BAD_REQUEST);
            }
            LayerInfo layer = null;
            LayerGroupInfo layerGroup = null;
            if (id != null) {
                layer = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayer(id);
                if (layer == null && (layerGroup = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerGroup(id)) == null) {
                    throw new RestException("No GeoServer Layer or LayerGroup exists with id '" + id + "'", HttpStatus.BAD_REQUEST);
                }
            } else {
                layer = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerByName(name);
                if (layer == null && (layerGroup = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerGroupByName(name)) == null) {
                    throw new RestException("GeoServer Layer or LayerGroup '" + name + "' not found", HttpStatus.NOT_FOUND);
                }
            }
            String actualId = layer != null ? layer.getId() : layerGroup.getId();
            String string = actualName = layer != null ? GWC.tileLayerName((LayerInfo)layer) : GWC.tileLayerName((LayerGroupInfo)layerGroup);
            if (id != null && !name.equals(actualName)) {
                throw new RestException("Layer with id '" + id + "' found but name does not match: '" + name + "'/'" + actualName + "'", HttpStatus.BAD_REQUEST);
            }
            info.setId(actualId);
            info.setName(actualName);
            GridSetBroker gridsets = GWC.get().getGridSetBroker();
            GeoServerTileLayer tileLayer = layer != null ? new GeoServerTileLayer((PublishedInfo)layer, gridsets, info) : new GeoServerTileLayer((PublishedInfo)layerGroup, gridsets, info);
            return tileLayer;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GeoServerTileLayer tileLayer = (GeoServerTileLayer)source;
            GeoServerTileLayerInfo info = tileLayer.getInfo();
            context.convertAnother((Object)info);
        }
    }
}

