/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;

public final class RasterByteSingleBandSkippingBytesProvider
extends AbstractScanlineProvider {
    static final int[] PIXEL_STRIDES = new int[]{1};
    int pixelStride;
    final byte[] bytes;
    int[] bandOffsets;
    int numBands;

    public RasterByteSingleBandSkippingBytesProvider(Raster raster) {
        super(raster, 8, raster.getWidth() * RasterByteSingleBandSkippingBytesProvider.computePixelStride(raster, PIXEL_STRIDES));
        PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)raster.getSampleModel();
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
        this.pixelStride = sm.getPixelStride();
        this.numBands = sm.getNumBands();
        this.bandOffsets = sm.getBandOffsets();
    }

    @Override
    public void next(byte[] scanline, int offset, int length) {
        if (this.currentRow == this.height) {
            throw new IllegalStateException("All scanlines have been read already");
        }
        int bytesIdx = this.cursor.next();
        if (this.numBands == this.pixelStride) {
            System.arraycopy(this.bytes, bytesIdx, scanline, offset, length);
        } else {
            int max = offset + length;
            for (int i = offset; i < max; i += this.numBands) {
                for (int j = 0; j < this.numBands; ++j) {
                    scanline[i + j] = this.bytes[bytesIdx + this.bandOffsets[j]];
                }
                bytesIdx += this.pixelStride;
            }
        }
        ++this.currentRow;
    }
}

