/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public final class RasterByteSingleBandProvider
extends AbstractScanlineProvider {
    final byte[] bytes;

    public RasterByteSingleBandProvider(Raster raster, int bitDepth, int scanlineLength) {
        super(raster, bitDepth, scanlineLength);
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    public RasterByteSingleBandProvider(Raster raster, int bitDepth, int scanlineLength, IndexColorModel palette) {
        super(raster, bitDepth, scanlineLength, palette);
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    @Override
    public void next(byte[] scanline, int offset, int length) {
        if (this.currentRow == this.height) {
            throw new IllegalStateException("All scanlines have been read already");
        }
        int next = this.cursor.next();
        System.arraycopy(this.bytes, next, scanline, offset, length);
        ++this.currentRow;
    }
}

