/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public final class RasterByteABGRProvider
extends AbstractScanlineProvider {
    static final int[] PIXEL_STRIDES = new int[]{3, 4};
    final byte[] bytes;
    final boolean bgrOrder;
    final boolean hasAlpha;
    final int pixelStride;
    final int[] bandOffsets;
    final int numBands;

    public RasterByteABGRProvider(Raster raster, boolean hasAlpha) {
        super(raster, 8, raster.getWidth() * RasterByteABGRProvider.computePixelStride(raster, PIXEL_STRIDES, hasAlpha));
        this.hasAlpha = hasAlpha;
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        this.bgrOrder = sm.getBandOffsets()[0] != 0;
        this.pixelStride = sm.getPixelStride();
        this.bandOffsets = sm.getBandOffsets();
        this.numBands = sm.getNumBands();
    }

    @Override
    public void next(byte[] row, int offset, int length) {
        int bytesIdx = this.cursor.next();
        int max = offset + length;
        if (!this.bgrOrder && this.numBands == this.pixelStride) {
            System.arraycopy(this.bytes, bytesIdx, row, offset, length);
        } else {
            for (int i = offset; i < max; i += this.numBands) {
                for (int j = 0; j < this.numBands; ++j) {
                    row[i + j] = this.bytes[bytesIdx + this.bandOffsets[j]];
                }
                bytesIdx += this.pixelStride;
            }
        }
    }
}

