/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces.stats;

import org.marlin.pisces.stats.StatLong;

public final class Histogram
extends StatLong {
    static final int BUCKET = 2;
    static final int MAX = 20;
    static final int LAST = 19;
    static final int[] STEPS = new int[20];
    private final StatLong[] stats = new StatLong[20];

    static int bucket(int val) {
        for (int i = 1; i < 20; ++i) {
            if (val >= STEPS[i]) continue;
            return i - 1;
        }
        return 19;
    }

    public Histogram(String name) {
        super(name);
        for (int i = 0; i < 20; ++i) {
            this.stats[i] = new StatLong(String.format("%5s .. %5s", STEPS[i], i + 1 < 20 ? Integer.valueOf(STEPS[i + 1]) : "~"));
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < 20; ++i) {
            this.stats[i].reset();
        }
    }

    @Override
    public void add(int val) {
        super.add(val);
        this.stats[Histogram.bucket(val)].add(val);
    }

    @Override
    public void add(long val) {
        this.add((int)val);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        super.toString(sb).append(" { ");
        for (int i = 0; i < 20; ++i) {
            if (this.stats[i].count == 0L) continue;
            sb.append("\n        ").append(this.stats[i].toString());
        }
        return sb.append(" }").toString();
    }

    static {
        Histogram.STEPS[0] = 0;
        Histogram.STEPS[1] = 1;
        for (int i = 2; i < 20; ++i) {
            Histogram.STEPS[i] = STEPS[i - 1] * 2;
        }
    }
}

