/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.marlin.geom.Path2D;
import org.marlin.pisces.Curve;
import org.marlin.pisces.Helpers;
import org.marlin.pisces.MarlinConst;
import org.marlin.pisces.MarlinProperties;
import org.marlin.pisces.MarlinUtils;
import org.marlin.pisces.RendererContext;
import sun.awt.geom.PathConsumer2D;

final class TransformingPathConsumer2D {
    static final float CLIP_RECT_PADDING = 1.0f;
    private final RendererContext rdrCtx;
    private final ClosedPathDetector cpDetector;
    private final PathClipFilter pathClipper;
    private final Path2DWrapper wp_Path2DWrapper = new Path2DWrapper();
    private final DeltaScaleFilter dt_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter dt_DeltaTransformFilter = new DeltaTransformFilter();
    private final DeltaScaleFilter iv_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter iv_DeltaTransformFilter = new DeltaTransformFilter();
    private final PathTracer tracerInput = new PathTracer("[Input]");
    private final PathTracer tracerCPDetector = new PathTracer("ClosedPathDetector");
    private final PathTracer tracerFiller = new PathTracer("Filler");
    private final PathTracer tracerStroker = new PathTracer("Stroker");
    private final PathTracer tracerDasher = new PathTracer("Dasher");

    TransformingPathConsumer2D(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.cpDetector = new ClosedPathDetector(rdrCtx);
        this.pathClipper = new PathClipFilter(rdrCtx);
    }

    PathConsumer2D wrapPath2D(Path2D.Float p2d) {
        return this.wp_Path2DWrapper.init(p2d);
    }

    PathConsumer2D traceInput(PathConsumer2D out) {
        return this.tracerInput.init(out);
    }

    PathConsumer2D traceClosedPathDetector(PathConsumer2D out) {
        return this.tracerCPDetector.init(out);
    }

    PathConsumer2D traceFiller(PathConsumer2D out) {
        return this.tracerFiller.init(out);
    }

    PathConsumer2D traceStroker(PathConsumer2D out) {
        return this.tracerStroker.init(out);
    }

    PathConsumer2D traceDasher(PathConsumer2D out) {
        return this.tracerDasher.init(out);
    }

    PathConsumer2D detectClosedPath(PathConsumer2D out) {
        return this.cpDetector.init(out);
    }

    PathConsumer2D pathClipper(PathConsumer2D out) {
        return this.pathClipper.init(out);
    }

    PathConsumer2D deltaTransformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float mxx = (float)at.getScaleX();
        float mxy = (float)at.getShearX();
        float myx = (float)at.getShearY();
        float myy = (float)at.getScaleY();
        if (mxy == 0.0f && myx == 0.0f) {
            if (mxx == 1.0f && myy == 1.0f) {
                return out;
            }
            if (this.rdrCtx.doClip) {
                this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipScale(this.rdrCtx.clipRect, mxx, myy);
            }
            return this.dt_DeltaScaleFilter.init(out, mxx, myy);
        }
        if (this.rdrCtx.doClip) {
            this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipInverseDelta(this.rdrCtx.clipRect, mxx, mxy, myx, myy);
        }
        return this.dt_DeltaTransformFilter.init(out, mxx, mxy, myx, myy);
    }

    private static float adjustClipScale(float[] clipRect, float mxx, float myy) {
        float scaleY = 1.0f / myy;
        clipRect[0] = clipRect[0] * scaleY;
        clipRect[1] = clipRect[1] * scaleY;
        if (clipRect[1] < clipRect[0]) {
            float tmp = clipRect[0];
            clipRect[0] = clipRect[1];
            clipRect[1] = tmp;
        }
        float scaleX = 1.0f / mxx;
        clipRect[2] = clipRect[2] * scaleX;
        clipRect[3] = clipRect[3] * scaleX;
        if (clipRect[3] < clipRect[2]) {
            float tmp = clipRect[2];
            clipRect[2] = clipRect[3];
            clipRect[3] = tmp;
        }
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipScale): " + Arrays.toString(clipRect));
        }
        return 0.5f * (Math.abs(scaleX) + Math.abs(scaleY));
    }

    private static float adjustClipInverseDelta(float[] clipRect, float mxx, float mxy, float myx, float myy) {
        float ymax;
        float xmax;
        float det = mxx * myy - mxy * myx;
        float imxx = myy / det;
        float imxy = -mxy / det;
        float imyx = -myx / det;
        float imyy = mxx / det;
        float x = clipRect[2] * imxx + clipRect[0] * imxy;
        float y = clipRect[2] * imyx + clipRect[0] * imyy;
        float xmin = xmax = x;
        float ymin = ymax = y;
        x = clipRect[3] * imxx + clipRect[0] * imxy;
        y = clipRect[3] * imyx + clipRect[0] * imyy;
        if (x < xmin) {
            xmin = x;
        } else if (x > xmax) {
            xmax = x;
        }
        if (y < ymin) {
            ymin = y;
        } else if (y > ymax) {
            ymax = y;
        }
        x = clipRect[2] * imxx + clipRect[1] * imxy;
        y = clipRect[2] * imyx + clipRect[1] * imyy;
        if (x < xmin) {
            xmin = x;
        } else if (x > xmax) {
            xmax = x;
        }
        if (y < ymin) {
            ymin = y;
        } else if (y > ymax) {
            ymax = y;
        }
        x = clipRect[3] * imxx + clipRect[1] * imxy;
        y = clipRect[3] * imyx + clipRect[1] * imyy;
        if (x < xmin) {
            xmin = x;
        } else if (x > xmax) {
            xmax = x;
        }
        if (y < ymin) {
            ymin = y;
        } else if (y > ymax) {
            ymax = y;
        }
        clipRect[0] = ymin;
        clipRect[1] = ymax;
        clipRect[2] = xmin;
        clipRect[3] = xmax;
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipInverseDelta): " + Arrays.toString(clipRect));
        }
        float scaleX = (float)Math.sqrt(imxx * imxx + imxy * imxy);
        float scaleY = (float)Math.sqrt(imyx * imyx + imyy * imyy);
        return 0.5f * (scaleX + scaleY);
    }

    PathConsumer2D inverseDeltaTransformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float mxx = (float)at.getScaleX();
        float mxy = (float)at.getShearX();
        float myx = (float)at.getShearY();
        float myy = (float)at.getScaleY();
        if (mxy == 0.0f && myx == 0.0f) {
            if (mxx == 1.0f && myy == 1.0f) {
                return out;
            }
            return this.iv_DeltaScaleFilter.init(out, 1.0f / mxx, 1.0f / myy);
        }
        float det = mxx * myy - mxy * myx;
        return this.iv_DeltaTransformFilter.init(out, myy / det, -mxy / det, -myx / det, mxx / det);
    }

    static final class PathTracer
    implements PathConsumer2D {
        private final String prefix;
        private PathConsumer2D out;

        PathTracer(String name) {
            this.prefix = name + ": ";
        }

        PathTracer init(PathConsumer2D out) {
            this.out = out;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.log("moveTo (" + x0 + ", " + y0 + ')');
            this.out.moveTo(x0, y0);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.log("lineTo (" + x1 + ", " + y1 + ')');
            this.out.lineTo(x1, y1);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.log("curveTo P1(" + x1 + ", " + y1 + ") P2(" + x2 + ", " + y2 + ") P3(" + x3 + ", " + y3 + ')');
            this.out.curveTo(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.log("quadTo P1(" + x1 + ", " + y1 + ") P2(" + x2 + ", " + y2 + ')');
            this.out.quadTo(x1, y1, x2, y2);
        }

        @Override
        public void closePath() {
            this.log("closePath");
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.log("pathDone");
            this.out.pathDone();
        }

        private void log(String message) {
            MarlinUtils.logInfo(this.prefix + message);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class CurveBasicMonotonizer {
        private static final int MAX_N_CURVES = 11;
        private float lw2;
        int nbSplits;
        final float[] middle = new float[68];
        private final float[] subdivTs = new float[10];
        private final Curve curve;

        CurveBasicMonotonizer(RendererContext rdrCtx) {
            this.curve = rdrCtx.curve;
        }

        void init(float lineWidth) {
            this.lw2 = lineWidth * lineWidth / 4.0f;
        }

        CurveBasicMonotonizer curve(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
            float[] mid = this.middle;
            mid[0] = x0;
            mid[1] = y0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
            mid[6] = x3;
            mid[7] = y3;
            float[] subTs = this.subdivTs;
            int nSplits = Helpers.findSubdivPoints(this.curve, mid, subTs, 8, this.lw2);
            float prevT = 0.0f;
            int i = 0;
            int off = 0;
            while (i < nSplits) {
                float t = subTs[i];
                Helpers.subdivideCubicAt((t - prevT) / (1.0f - prevT), mid, off, mid, off, off + 6);
                prevT = t;
                ++i;
                off += 6;
            }
            this.nbSplits = nSplits;
            return this;
        }

        CurveBasicMonotonizer quad(float x0, float y0, float x1, float y1, float x2, float y2) {
            float[] mid = this.middle;
            mid[0] = x0;
            mid[1] = y0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
            float[] subTs = this.subdivTs;
            int nSplits = Helpers.findSubdivPoints(this.curve, mid, subTs, 6, this.lw2);
            float prevt = 0.0f;
            int i = 0;
            int off = 0;
            while (i < nSplits) {
                float t = subTs[i];
                Helpers.subdivideQuadAt((t - prevt) / (1.0f - prevt), mid, off, mid, off, off + 4);
                prevt = t;
                ++i;
                off += 4;
            }
            this.nbSplits = nSplits;
            return this;
        }
    }

    static final class CurveClipSplitter {
        static final float LEN_TH = MarlinProperties.getSubdividerMinLength();
        static final boolean DO_CHECK_LENGTH = LEN_TH > 0.0f;
        private static final boolean TRACE = false;
        private static final int MAX_N_CURVES = 12;
        private final RendererContext rdrCtx;
        private float minLength;
        final float[] clipRect;
        final float[] clipRectPad = new float[4];
        private boolean init_clipRectPad = false;
        final float[] middle = new float[98];
        private final float[] subdivTs = new float[12];
        private final Curve curve;

        CurveClipSplitter(RendererContext rdrCtx) {
            this.rdrCtx = rdrCtx;
            this.clipRect = rdrCtx.clipRect;
            this.curve = rdrCtx.curve;
        }

        void init() {
            this.init_clipRectPad = true;
            if (DO_CHECK_LENGTH) {
                float f = this.minLength = this.rdrCtx.clipInvScale == 0.0f ? LEN_TH : LEN_TH * this.rdrCtx.clipInvScale;
                if (MarlinConst.DO_LOG_CLIP) {
                    MarlinUtils.logInfo("CurveClipSplitter.minLength = " + this.minLength);
                }
            }
        }

        private void initPaddedClip() {
            float[] _clipRect = this.clipRect;
            float[] _clipRectPad = this.clipRectPad;
            _clipRectPad[0] = _clipRect[0] - 1.0f;
            _clipRectPad[1] = _clipRect[1] + 1.0f;
            _clipRectPad[2] = _clipRect[2] - 1.0f;
            _clipRectPad[3] = _clipRect[3] + 1.0f;
        }

        boolean splitLine(float x0, float y0, float x1, float y1, int outCodeOR, PathConsumer2D out) {
            if (DO_CHECK_LENGTH && Helpers.fastLineLen(x0, y0, x1, y1) <= this.minLength) {
                return false;
            }
            float[] mid = this.middle;
            mid[0] = x0;
            mid[1] = y0;
            mid[2] = x1;
            mid[3] = y1;
            return this.subdivideAtIntersections(4, outCodeOR, out);
        }

        boolean splitQuad(float x0, float y0, float x1, float y1, float x2, float y2, int outCodeOR, PathConsumer2D out) {
            if (DO_CHECK_LENGTH && Helpers.fastQuadLen(x0, y0, x1, y1, x2, y2) <= this.minLength) {
                return false;
            }
            float[] mid = this.middle;
            mid[0] = x0;
            mid[1] = y0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
            return this.subdivideAtIntersections(6, outCodeOR, out);
        }

        boolean splitCurve(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, int outCodeOR, PathConsumer2D out) {
            if (DO_CHECK_LENGTH && Helpers.fastCurvelen(x0, y0, x1, y1, x2, y2, x3, y3) <= this.minLength) {
                return false;
            }
            float[] mid = this.middle;
            mid[0] = x0;
            mid[1] = y0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
            mid[6] = x3;
            mid[7] = y3;
            return this.subdivideAtIntersections(8, outCodeOR, out);
        }

        private boolean subdivideAtIntersections(int type, int outCodeOR, PathConsumer2D out) {
            int nSplits;
            float[] mid = this.middle;
            float[] subTs = this.subdivTs;
            if (this.init_clipRectPad) {
                this.init_clipRectPad = false;
                this.initPaddedClip();
            }
            if ((nSplits = Helpers.findClipPoints(this.curve, mid, subTs, type, outCodeOR, this.clipRectPad)) == 0) {
                return false;
            }
            float prevT = 0.0f;
            int i = 0;
            int off = 0;
            while (i < nSplits) {
                float t = subTs[i];
                Helpers.subdivideAt((t - prevT) / (1.0f - prevT), mid, off, mid, off, type);
                prevT = t;
                ++i;
                off += type;
            }
            i = 0;
            off = 0;
            while (i <= nSplits) {
                CurveClipSplitter.emitCurrent(type, mid, off, out);
                ++i;
                off += type;
            }
            return true;
        }

        static void emitCurrent(int type, float[] pts, int off, PathConsumer2D out) {
            if (type == 8) {
                out.curveTo(pts[off + 2], pts[off + 3], pts[off + 4], pts[off + 5], pts[off + 6], pts[off + 7]);
            } else if (type == 4) {
                out.lineTo(pts[off + 2], pts[off + 3]);
            } else {
                out.quadTo(pts[off + 2], pts[off + 3], pts[off + 4], pts[off + 5]);
            }
        }
    }

    static final class PathClipFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private final float[] clipRect;
        private final float[] corners = new float[8];
        private boolean init_corners = false;
        private final Helpers.IndexStack stack;
        private int cOutCode = 0;
        private int gOutCode = 15;
        private boolean outside = false;
        private float cx0;
        private float cy0;
        private float cox0;
        private float coy0;
        private boolean subdivide = MarlinConst.DO_CLIP_SUBDIVIDER;
        private final CurveClipSplitter curveSplitter;

        PathClipFilter(RendererContext rdrCtx) {
            this.clipRect = rdrCtx.clipRect;
            this.curveSplitter = rdrCtx.curveClipSplitter;
            this.stack = rdrCtx.stats != null ? new Helpers.IndexStack(rdrCtx, rdrCtx.stats.stat_pcf_idxstack_indices, rdrCtx.stats.hist_pcf_idxstack_indices, rdrCtx.stats.stat_array_pcf_idxstack_indices) : new Helpers.IndexStack(rdrCtx);
        }

        PathClipFilter init(PathConsumer2D out) {
            this.out = out;
            if (MarlinConst.DO_CLIP_SUBDIVIDER) {
                this.curveSplitter.init();
            }
            this.init_corners = true;
            this.gOutCode = 15;
            return this;
        }

        void dispose() {
            this.stack.dispose();
        }

        private void finishPath() {
            if (this.outside) {
                if (this.gOutCode == 0) {
                    this.finish();
                } else {
                    this.outside = false;
                    this.stack.reset();
                }
            }
        }

        private void finish() {
            this.outside = false;
            if (!this.stack.isEmpty()) {
                if (this.init_corners) {
                    this.init_corners = false;
                    float[] _corners = this.corners;
                    float[] _clipRect = this.clipRect;
                    _corners[0] = _clipRect[2];
                    _corners[1] = _clipRect[0];
                    _corners[2] = _clipRect[2];
                    _corners[3] = _clipRect[1];
                    _corners[4] = _clipRect[3];
                    _corners[5] = _clipRect[0];
                    _corners[6] = _clipRect[3];
                    _corners[7] = _clipRect[1];
                }
                this.stack.pullAll(this.corners, this.out);
            }
            this.out.lineTo(this.cox0, this.coy0);
            this.cx0 = this.cox0;
            this.cy0 = this.coy0;
        }

        @Override
        public void pathDone() {
            this.finishPath();
            this.out.pathDone();
            this.dispose();
        }

        @Override
        public void closePath() {
            this.finishPath();
            this.out.closePath();
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.finishPath();
            this.cOutCode = Helpers.outcode(x0, y0, this.clipRect);
            this.outside = false;
            this.out.moveTo(x0, y0);
            this.cx0 = x0;
            this.cy0 = y0;
        }

        @Override
        public void lineTo(float xe, float ye) {
            int outcode0 = this.cOutCode;
            int outcode1 = Helpers.outcode(xe, ye, this.clipRect);
            int orCode = outcode0 | outcode1;
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.outside ? this.curveSplitter.splitLine(this.cox0, this.coy0, xe, ye, orCode, this) : this.curveSplitter.splitLine(this.cx0, this.cy0, xe, ye, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode1;
                    this.gOutCode &= sideCode;
                    this.outside = true;
                    this.cox0 = xe;
                    this.coy0 = ye;
                    this.clip(sideCode, outcode0, outcode1);
                    return;
                }
            }
            this.cOutCode = outcode1;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.lineTo(xe, ye);
            this.cx0 = xe;
            this.cy0 = ye;
        }

        private void clip(int sideCode, int outcode0, int outcode1) {
            if (outcode0 != outcode1 && (sideCode & 0xC) != 0) {
                int mergeCode = outcode0 | outcode1;
                int tbCode = mergeCode & 3;
                int lrCode = mergeCode & 0xC;
                int off = lrCode == 4 ? 0 : 2;
                switch (tbCode) {
                    case 1: {
                        this.stack.push(off);
                        return;
                    }
                    case 2: {
                        this.stack.push(off + 1);
                        return;
                    }
                }
                if ((outcode0 & 1) != 0) {
                    this.stack.push(off);
                    this.stack.push(off + 1);
                } else {
                    this.stack.push(off + 1);
                    this.stack.push(off);
                }
            }
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float xe, float ye) {
            int outcode3;
            int outcode2;
            int outcode0 = this.cOutCode;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(x2, y2, this.clipRect)) | (outcode3 = Helpers.outcode(xe, ye, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2 & outcode3;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.outside ? this.curveSplitter.splitCurve(this.cox0, this.coy0, x1, y1, x2, y2, xe, ye, orCode, this) : this.curveSplitter.splitCurve(this.cx0, this.cy0, x1, y1, x2, y2, xe, ye, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode3;
                    this.gOutCode &= sideCode;
                    this.outside = true;
                    this.cox0 = xe;
                    this.coy0 = ye;
                    this.clip(sideCode, outcode0, outcode3);
                    return;
                }
            }
            this.cOutCode = outcode3;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.curveTo(x1, y1, x2, y2, xe, ye);
            this.cx0 = xe;
            this.cy0 = ye;
        }

        @Override
        public void quadTo(float x1, float y1, float xe, float ye) {
            int outcode2;
            int outcode0 = this.cOutCode;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(xe, ye, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.outside ? this.curveSplitter.splitQuad(this.cox0, this.coy0, x1, y1, xe, ye, orCode, this) : this.curveSplitter.splitQuad(this.cx0, this.cy0, x1, y1, xe, ye, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode2;
                    this.gOutCode &= sideCode;
                    this.outside = true;
                    this.cox0 = xe;
                    this.coy0 = ye;
                    this.clip(sideCode, outcode0, outcode2);
                    return;
                }
            }
            this.cOutCode = outcode2;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.quadTo(x1, y1, xe, ye);
            this.cx0 = xe;
            this.cy0 = ye;
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class ClosedPathDetector
    implements PathConsumer2D {
        private final RendererContext rdrCtx;
        private final Helpers.PolyStack stack;
        private PathConsumer2D out;

        ClosedPathDetector(RendererContext rdrCtx) {
            this.rdrCtx = rdrCtx;
            this.stack = rdrCtx.stats != null ? new Helpers.PolyStack(rdrCtx, rdrCtx.stats.stat_cpd_polystack_types, rdrCtx.stats.stat_cpd_polystack_curves, rdrCtx.stats.hist_cpd_polystack_curves, rdrCtx.stats.stat_array_cpd_polystack_curves, rdrCtx.stats.stat_array_cpd_polystack_types) : new Helpers.PolyStack(rdrCtx);
        }

        ClosedPathDetector init(PathConsumer2D out) {
            this.out = out;
            return this;
        }

        void dispose() {
            this.stack.dispose();
        }

        @Override
        public void pathDone() {
            this.finish(false);
            this.out.pathDone();
            this.dispose();
        }

        @Override
        public void closePath() {
            this.finish(true);
            this.out.closePath();
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.finish(false);
            this.out.moveTo(x0, y0);
        }

        private void finish(boolean closed) {
            this.rdrCtx.closedPath = closed;
            this.stack.pullAll(this.out);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.stack.pushLine(x1, y1);
        }

        @Override
        public void curveTo(float x3, float y3, float x2, float y2, float x1, float y1) {
            this.stack.pushCubic(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void quadTo(float x2, float y2, float x1, float y1) {
            this.stack.pushQuad(x1, y1, x2, y2);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class Path2DWrapper
    implements PathConsumer2D {
        private Path2D.Float p2d;

        Path2DWrapper() {
        }

        Path2DWrapper init(Path2D.Float p2d) {
            this.p2d = p2d;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.p2d.moveTo(x0, y0);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.p2d.lineTo(x1, y1);
        }

        @Override
        public void closePath() {
            this.p2d.closePath();
        }

        @Override
        public void pathDone() {
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.p2d.curveTo(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.p2d.quadTo(x1, y1, x2, y2);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class DeltaTransformFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float mxx;
        private float mxy;
        private float myx;
        private float myy;

        DeltaTransformFilter() {
        }

        DeltaTransformFilter init(PathConsumer2D out, float mxx, float mxy, float myx, float myy) {
            this.out = out;
            this.mxx = mxx;
            this.mxy = mxy;
            this.myx = myx;
            this.myy = myy;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.mxx + y0 * this.mxy, x0 * this.myx + y0 * this.myy);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy, x2 * this.mxx + y2 * this.mxy, x2 * this.myx + y2 * this.myy);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy, x2 * this.mxx + y2 * this.mxy, x2 * this.myx + y2 * this.myy, x3 * this.mxx + y3 * this.mxy, x3 * this.myx + y3 * this.myy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class DeltaScaleFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float sx;
        private float sy;

        DeltaScaleFilter() {
        }

        DeltaScaleFilter init(PathConsumer2D out, float mxx, float myy) {
            this.out = out;
            this.sx = mxx;
            this.sy = myy;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.sx, y0 * this.sy);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.sx, y1 * this.sy);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.sx, y1 * this.sy, x2 * this.sx, y2 * this.sy);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.sx, y1 * this.sy, x2 * this.sx, y2 * this.sy, x3 * this.sx, y3 * this.sy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }
}

