/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.marlin.ReentrantContext;
import org.marlin.geom.Path2D;
import org.marlin.pisces.ArrayCacheConst;
import org.marlin.pisces.ByteArrayCache;
import org.marlin.pisces.CollinearSimplifier;
import org.marlin.pisces.Curve;
import org.marlin.pisces.Dasher;
import org.marlin.pisces.FloatArrayCache;
import org.marlin.pisces.IRendererContext;
import org.marlin.pisces.IntArrayCache;
import org.marlin.pisces.MarlinCache;
import org.marlin.pisces.MarlinRenderingEngine;
import org.marlin.pisces.MarlinTileGenerator;
import org.marlin.pisces.MarlinUtils;
import org.marlin.pisces.OffHeapArray;
import org.marlin.pisces.PathSimplifier;
import org.marlin.pisces.Renderer;
import org.marlin.pisces.RendererStats;
import org.marlin.pisces.Stroker;
import org.marlin.pisces.TransformingPathConsumer2D;

final class RendererContext
extends ReentrantContext
implements IRendererContext {
    private static final AtomicInteger CTX_COUNT = new AtomicInteger(1);
    private final Object cleanerObj;
    boolean dirty = false;
    final float[] float6 = new float[6];
    final Curve curve = new Curve();
    final MarlinRenderingEngine.NormalizingPathIterator nPCPathIterator;
    final MarlinRenderingEngine.NormalizingPathIterator nPQPathIterator;
    final TransformingPathConsumer2D transformerPC2D;
    private WeakReference<Path2D.Float> refPath2D = null;
    final Renderer renderer;
    final Stroker stroker;
    final CollinearSimplifier simplifier = new CollinearSimplifier();
    final PathSimplifier pathSimplifier = new PathSimplifier();
    final Dasher dasher;
    final MarlinTileGenerator ptg;
    final MarlinCache cache;
    int stroking = 0;
    boolean doClip = false;
    boolean closedPath = false;
    final float[] clipRect = new float[4];
    float clipInvScale = 0.0f;
    final TransformingPathConsumer2D.CurveBasicMonotonizer monotonizer;
    final TransformingPathConsumer2D.CurveClipSplitter curveClipSplitter;
    private final IntArrayCache cleanIntCache = new IntArrayCache(true, 5);
    private final IntArrayCache dirtyIntCache = new IntArrayCache(false, 5);
    private final FloatArrayCache dirtyFloatCache = new FloatArrayCache(false, 4);
    private final ByteArrayCache dirtyByteCache = new ByteArrayCache(false, 2);
    final RendererStats stats;

    static RendererContext createContext() {
        return new RendererContext("ctx" + Integer.toString(CTX_COUNT.getAndIncrement()));
    }

    RendererContext(String name) {
        if (LOG_CREATE_CONTEXT) {
            MarlinUtils.logInfo("new RendererContext = " + name);
        }
        this.cleanerObj = new Object();
        if (DO_STATS) {
            this.stats = RendererStats.createInstance(this.cleanerObj, name);
            this.stats.cacheStats = new ArrayCacheConst.CacheStats[]{this.cleanIntCache.stats, this.dirtyIntCache.stats, this.dirtyFloatCache.stats, this.dirtyByteCache.stats};
        } else {
            this.stats = null;
        }
        this.nPCPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelCenter(this.float6);
        this.nPQPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelQuarter(this.float6);
        this.monotonizer = new TransformingPathConsumer2D.CurveBasicMonotonizer(this);
        this.curveClipSplitter = new TransformingPathConsumer2D.CurveClipSplitter(this);
        this.transformerPC2D = new TransformingPathConsumer2D(this);
        this.cache = new MarlinCache(this);
        this.renderer = new Renderer(this);
        this.ptg = new MarlinTileGenerator(this.stats, this.renderer, this.cache);
        this.stroker = new Stroker(this);
        this.dasher = new Dasher(this);
    }

    void dispose() {
        if (DO_STATS) {
            if (this.stats.totalOffHeap > this.stats.totalOffHeapMax) {
                this.stats.totalOffHeapMax = this.stats.totalOffHeap;
            }
            this.stats.totalOffHeap = 0L;
        }
        this.stroking = 0;
        this.doClip = false;
        this.closedPath = false;
        this.clipInvScale = 0.0f;
        if (this.dirty) {
            this.nPCPathIterator.dispose();
            this.nPQPathIterator.dispose();
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    Path2D.Float getPath2D() {
        Path2D.Float p2d;
        Path2D.Float float_ = p2d = this.refPath2D != null ? (Path2D.Float)this.refPath2D.get() : null;
        if (p2d == null) {
            p2d = new Path2D.Float(1, INITIAL_EDGES_COUNT);
            this.refPath2D = new WeakReference<Path2D.Float>(p2d);
        }
        p2d.reset();
        return p2d;
    }

    @Override
    public RendererStats stats() {
        return this.stats;
    }

    @Override
    public OffHeapArray newOffHeapArray(long initialSize) {
        if (DO_STATS) {
            this.stats.totalOffHeapInitial += initialSize;
        }
        return new OffHeapArray(this.cleanerObj, initialSize);
    }

    @Override
    public IntArrayCache.Reference newCleanIntArrayRef(int initialSize) {
        return this.cleanIntCache.createRef(initialSize);
    }

    IntArrayCache.Reference newDirtyIntArrayRef(int initialSize) {
        return this.dirtyIntCache.createRef(initialSize);
    }

    FloatArrayCache.Reference newDirtyFloatArrayRef(int initialSize) {
        return this.dirtyFloatCache.createRef(initialSize);
    }

    ByteArrayCache.Reference newDirtyByteArrayRef(int initialSize) {
        return this.dirtyByteCache.createRef(initialSize);
    }
}

