/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.marlin.pisces.MarlinConst;
import org.marlin.pisces.MarlinUtils;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            Unsafe ref = null;
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                ref = (Unsafe)field.get(null);
            }
            catch (Exception e) {
                throw new InternalError("Unable to get sun.misc.Unsafe instance", e);
            }
            return ref;
        }
    });
    static final int SIZE_INT = 4;
    long address;
    long length;
    int used;
    private static final ReferenceQueue<Object> REF_QUEUE;
    private static final Vector<OffHeapReference> REF_LIST;

    OffHeapArray(Object parent, long len) {
        this.address = UNSAFE.allocateMemory(len);
        this.length = len;
        this.used = 0;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory =   " + len + " to addr = " + this.address);
        }
        REF_LIST.add(new OffHeapReference(parent, this));
    }

    void resize(long len) {
        this.address = UNSAFE.reallocateMemory(this.address, len);
        this.length = len;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + len + " to addr = " + this.address);
        }
    }

    void free() {
        UNSAFE.freeMemory(this.address);
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.freeMemory =       " + this.length + " at addr = " + this.address);
        }
        this.address = 0L;
    }

    void fill(byte val) {
        UNSAFE.setMemory(this.address, this.length, val);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread t = new Thread(MarlinUtils.getRootThreadGroup(), new OffHeapDisposer(), "MarlinRenderer Disposer");
                t.setContextClassLoader(null);
                t.setDaemon(true);
                t.setPriority(8);
                t.start();
                return null;
            }
        });
        REF_QUEUE = new ReferenceQueue();
        REF_LIST = new Vector(32);
    }

    static final class OffHeapDisposer
    implements Runnable {
        OffHeapDisposer() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    OffHeapReference ref = (OffHeapReference)REF_QUEUE.remove();
                    ref.dispose();
                    REF_LIST.remove(ref);
                }
                catch (InterruptedException ie) {
                    MarlinUtils.logException("OffHeapDisposer interrupted:", ie);
                }
            }
        }
    }

    static final class OffHeapReference
    extends PhantomReference<Object> {
        private final OffHeapArray array;

        OffHeapReference(Object parent, OffHeapArray edges) {
            super(parent, REF_QUEUE);
            this.array = edges;
        }

        void dispose() {
            this.array.free();
        }
    }
}

