/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.marlin.pisces.MarlinConst;

public final class MarlinUtils {
    private static final Logger LOG = MarlinConst.USE_LOGGER ? Logger.getLogger("sun.java2d.marlin") : null;

    private MarlinUtils() {
    }

    public static void logInfo(String msg) {
        if (MarlinConst.USE_LOGGER) {
            LOG.info(msg);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("INFO: ");
            System.out.println(msg);
        }
    }

    public static void logException(String msg, Throwable th) {
        if (MarlinConst.USE_LOGGER) {
            LOG.log(Level.WARNING, msg, th);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("WARNING: ");
            System.out.println(msg);
            th.printStackTrace(System.err);
        }
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup currentTG = Thread.currentThread().getThreadGroup();
        ThreadGroup parentTG = currentTG.getParent();
        while (parentTG != null) {
            currentTG = parentTG;
            parentTG = currentTG.getParent();
        }
        return currentTG;
    }
}

