/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import org.marlin.pisces.FloatArrayCache;
import org.marlin.pisces.FloatMath;
import org.marlin.pisces.Helpers;
import org.marlin.pisces.MarlinConst;
import org.marlin.pisces.MarlinProperties;
import org.marlin.pisces.RendererContext;
import org.marlin.pisces.TransformingPathConsumer2D;
import sun.awt.geom.PathConsumer2D;

final class Dasher
implements PathConsumer2D,
MarlinConst {
    static final int REC_LIMIT = 16;
    static final float CURVE_LEN_ERR = MarlinProperties.getCurveLengthError();
    static final float MIN_T_INC = 1.5258789E-5f;
    static final float MAX_CYCLES = 1.6E7f;
    private PathConsumer2D out;
    private float[] dash;
    private int dashLen;
    private float startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private float phase;
    private float sx0;
    private float sy0;
    private float cx0;
    private float cy0;
    private final float[] curCurvepts;
    final RendererContext rdrCtx;
    boolean recycleDashes;
    private float[] firstSegmentsBuffer;
    private int firstSegidx;
    final FloatArrayCache.Reference dashes_ref;
    final FloatArrayCache.Reference firstSegmentsBuffer_ref;
    private float[] clipRect;
    private int cOutCode = 0;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final LengthIterator li = new LengthIterator();
    private final TransformingPathConsumer2D.CurveClipSplitter curveSplitter;
    private float cycleLen;
    private boolean outside;
    private float totalSkipLen;

    Dasher(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.dashes_ref = rdrCtx.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer_ref = rdrCtx.newDirtyFloatArrayRef(256);
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.initial;
        this.curCurvepts = new float[16];
        this.curveSplitter = rdrCtx.curveClipSplitter;
    }

    Dasher init(PathConsumer2D out, float[] dash, int dashLen, float phase, boolean recycleDashes) {
        this.out = out;
        int sidx = 0;
        this.dashOn = true;
        float sum = 0.0f;
        for (int i = 0; i < dashLen; ++i) {
            sum += dash[i];
        }
        this.cycleLen = sum;
        float cycles = phase / sum;
        if (phase < 0.0f) {
            if (-cycles >= 1.6E7f) {
                phase = 0.0f;
            } else {
                int fullcycles = FloatMath.floor_int(-cycles);
                if ((fullcycles & dashLen & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                phase += (float)fullcycles * sum;
                while (phase < 0.0f) {
                    if (--sidx < 0) {
                        sidx = dashLen - 1;
                    }
                    phase += dash[sidx];
                    this.dashOn = !this.dashOn;
                }
            }
        } else if (phase > 0.0f) {
            if (cycles >= 1.6E7f) {
                phase = 0.0f;
            } else {
                int fullcycles = FloatMath.floor_int(cycles);
                if ((fullcycles & dashLen & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                phase -= (float)fullcycles * sum;
                while (true) {
                    float f;
                    float d = dash[sidx];
                    if (!(phase >= f)) break;
                    phase -= d;
                    sidx = (sidx + 1) % dashLen;
                    this.dashOn = !this.dashOn;
                }
            }
        }
        this.dash = dash;
        this.dashLen = dashLen;
        this.phase = phase;
        this.startPhase = phase;
        this.startDashOn = this.dashOn;
        this.startIdx = sidx;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = recycleDashes;
        if (this.rdrCtx.doClip) {
            this.clipRect = this.rdrCtx.clipRect;
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
        }
        return this;
    }

    void dispose() {
        if (this.recycleDashes) {
            this.dash = this.dashes_ref.putArray(this.dash);
        }
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.putArray(this.firstSegmentsBuffer);
    }

    float[] copyDashArray(float[] dashes) {
        float[] newDashes;
        int len = dashes.length;
        if (len <= 256) {
            newDashes = this.dashes_ref.initial;
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_dasher.add(len);
            }
            newDashes = this.dashes_ref.getArray(len);
        }
        System.arraycopy(dashes, 0, newDashes, 0, len);
        return newDashes;
    }

    @Override
    public void moveTo(float x0, float y0) {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.cx0 = x0;
        this.cy0 = y0;
        this.sx0 = x0;
        this.sy0 = y0;
        this.starting = true;
        if (this.clipRect != null) {
            int outcode;
            this.cOutCode = outcode = Helpers.outcode(x0, y0, this.clipRect);
            this.outside = false;
            this.totalSkipLen = 0.0f;
        }
    }

    private void emitSeg(float[] buf, int off, int type) {
        switch (type) {
            case 4: {
                this.out.lineTo(buf[off], buf[off + 1]);
                return;
            }
            case 8: {
                this.out.curveTo(buf[off], buf[off + 1], buf[off + 2], buf[off + 3], buf[off + 4], buf[off + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(buf[off], buf[off + 1], buf[off + 2], buf[off + 3]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int type;
        float[] fSegBuf = this.firstSegmentsBuffer;
        int len = this.firstSegidx;
        for (int i = 0; i < len; i += type - 1) {
            type = (int)fSegBuf[i];
            this.emitSeg(fSegBuf, i + 1, type);
        }
        this.firstSegidx = 0;
    }

    private void goTo(float[] pts, int off, int type, boolean on) {
        int index = off + type;
        float x = pts[index - 4];
        float y = pts[index - 3];
        if (on) {
            if (this.starting) {
                this.goTo_starting(pts, off, type);
            } else {
                if (this.needsMoveTo) {
                    this.needsMoveTo = false;
                    this.out.moveTo(this.cx0, this.cy0);
                }
                this.emitSeg(pts, off, type);
            }
        } else {
            if (this.starting) {
                this.starting = false;
            }
            this.needsMoveTo = true;
        }
        this.cx0 = x;
        this.cy0 = y;
    }

    private void goTo_starting(float[] pts, int off, int type) {
        int segIdx = this.firstSegidx;
        int len = type - 1;
        float[] buf = this.firstSegmentsBuffer;
        if (segIdx + len > buf.length) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_firstSegmentsBuffer.add(segIdx + len);
            }
            this.firstSegmentsBuffer = buf = this.firstSegmentsBuffer_ref.widenArray(buf, segIdx, segIdx + len);
        }
        buf[segIdx++] = type;
        System.arraycopy(pts, off, buf, segIdx, --len);
        this.firstSegidx = segIdx + len;
    }

    @Override
    public void lineTo(float x1, float y1) {
        int outcode0 = this.cOutCode;
        if (this.clipRect != null) {
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1;
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitLine(this.cx0, this.cy0, x1, y1, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode1;
                    this.skipLineTo(x1, y1);
                    return;
                }
            }
            this.cOutCode = outcode1;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._lineTo(x1, y1);
    }

    private void _lineTo(float x1, float y1) {
        float dx = x1 - this.cx0;
        float dy = y1 - this.cy0;
        float len = dx * dx + dy * dy;
        if (len == 0.0f) {
            return;
        }
        len = (float)Math.sqrt(len);
        float cx = dx / len;
        float cy = dy / len;
        float[] _curCurvepts = this.curCurvepts;
        float[] _dash = this.dash;
        int _dashLen = this.dashLen;
        int _idx = this.idx;
        boolean _dashOn = this.dashOn;
        float _phase = this.phase;
        while (true) {
            float d;
            float leftInThisDashSegment;
            if (len <= (leftInThisDashSegment = (d = _dash[_idx]) - _phase)) {
                _curCurvepts[0] = x1;
                _curCurvepts[1] = y1;
                this.goTo(_curCurvepts, 0, 4, _dashOn);
                _phase += len;
                if (len != leftInThisDashSegment) break;
                _phase = 0.0f;
                _idx = (_idx + 1) % _dashLen;
                _dashOn = !_dashOn;
                break;
            }
            if (_phase == 0.0f) {
                _curCurvepts[0] = this.cx0 + d * cx;
                _curCurvepts[1] = this.cy0 + d * cy;
            } else {
                _curCurvepts[0] = this.cx0 + leftInThisDashSegment * cx;
                _curCurvepts[1] = this.cy0 + leftInThisDashSegment * cy;
            }
            this.goTo(_curCurvepts, 0, 4, _dashOn);
            len -= leftInThisDashSegment;
            _idx = (_idx + 1) % _dashLen;
            _dashOn = !_dashOn;
            _phase = 0.0f;
        }
        this.idx = _idx;
        this.dashOn = _dashOn;
        this.phase = _phase;
    }

    private void skipLineTo(float x1, float y1) {
        float dx = x1 - this.cx0;
        float dy = y1 - this.cy0;
        float len = dx * dx + dy * dy;
        if (len != 0.0f) {
            len = (float)Math.sqrt(len);
        }
        this.outside = true;
        this.totalSkipLen += len;
        this.needsMoveTo = true;
        this.starting = false;
        this.cx0 = x1;
        this.cy0 = y1;
    }

    public void skipLen() {
        float len = this.totalSkipLen;
        this.totalSkipLen = 0.0f;
        float[] _dash = this.dash;
        int _dashLen = this.dashLen;
        int _idx = this.idx;
        boolean _dashOn = this.dashOn;
        float _phase = this.phase;
        long fullcycles = (long)Math.floor(len / this.cycleLen) - 2L;
        if (fullcycles > 0L) {
            len -= this.cycleLen * (float)fullcycles;
            long iterations = fullcycles * (long)_dashLen;
            _idx = (int)(iterations + (long)_idx) % _dashLen;
            boolean bl = _dashOn = (iterations + (_dashOn ? 1L : 0L) & 1L) == 1L;
        }
        while (true) {
            float d;
            float leftInThisDashSegment;
            if (len <= (leftInThisDashSegment = (d = _dash[_idx]) - _phase)) {
                _phase += len;
                if (len != leftInThisDashSegment) break;
                _phase = 0.0f;
                _idx = (_idx + 1) % _dashLen;
                _dashOn = !_dashOn;
                break;
            }
            len -= leftInThisDashSegment;
            _idx = (_idx + 1) % _dashLen;
            _dashOn = !_dashOn;
            _phase = 0.0f;
        }
        this.idx = _idx;
        this.dashOn = _dashOn;
        this.phase = _phase;
    }

    private void somethingTo(int type) {
        float[] _curCurvepts = this.curCurvepts;
        if (Dasher.pointCurve(_curCurvepts, type)) {
            return;
        }
        LengthIterator _li = this.li;
        float[] _dash = this.dash;
        int _dashLen = this.dashLen;
        _li.initializeIterationOnCurve(_curCurvepts, type);
        int _idx = this.idx;
        boolean _dashOn = this.dashOn;
        float _phase = this.phase;
        int curCurveoff = 0;
        float prevT = 0.0f;
        float leftInThisDashSegment = _dash[_idx] - _phase;
        while (true) {
            float f;
            float t = _li.next(leftInThisDashSegment);
            if (!(f < 1.0f)) break;
            if (t != 0.0f) {
                Helpers.subdivideAt((t - prevT) / (1.0f - prevT), _curCurvepts, curCurveoff, _curCurvepts, 0, type);
                prevT = t;
                this.goTo(_curCurvepts, 2, type, _dashOn);
                curCurveoff = type;
            }
            _idx = (_idx + 1) % _dashLen;
            _dashOn = !_dashOn;
            _phase = 0.0f;
            leftInThisDashSegment = _dash[_idx];
        }
        this.goTo(_curCurvepts, curCurveoff + 2, type, _dashOn);
        _phase += _li.lastSegLen();
        if (_phase >= _dash[_idx]) {
            _phase = 0.0f;
            _idx = (_idx + 1) % _dashLen;
            _dashOn = !_dashOn;
        }
        this.idx = _idx;
        this.dashOn = _dashOn;
        this.phase = _phase;
        _li.reset();
    }

    private void skipSomethingTo(int type) {
        float[] _curCurvepts = this.curCurvepts;
        if (Dasher.pointCurve(_curCurvepts, type)) {
            return;
        }
        LengthIterator _li = this.li;
        _li.initializeIterationOnCurve(_curCurvepts, type);
        float len = _li.totalLength();
        this.outside = true;
        this.totalSkipLen += len;
        this.needsMoveTo = true;
        this.starting = false;
    }

    private static boolean pointCurve(float[] curve, int type) {
        for (int i = 2; i < type; ++i) {
            if (curve[i] == curve[i - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        int outcode0 = this.cOutCode;
        if (this.clipRect != null) {
            int outcode3;
            int outcode2;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(x2, y2, this.clipRect)) | (outcode3 = Helpers.outcode(x3, y3, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2 & outcode3;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitCurve(this.cx0, this.cy0, x1, y1, x2, y2, x3, y3, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode3;
                    this.skipCurveTo(x1, y1, x2, y2, x3, y3);
                    return;
                }
            }
            this.cOutCode = outcode3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._curveTo(x1, y1, x2, y2, x3, y3);
    }

    private void _curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float[] _curCurvepts = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer monotonizer = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, x1, y1, x2, y2, x3, y3);
        int nSplits = monotonizer.nbSplits;
        float[] mid = monotonizer.middle;
        int i = 0;
        int off = 0;
        while (i <= nSplits) {
            System.arraycopy(mid, off, _curCurvepts, 0, 8);
            this.somethingTo(8);
            ++i;
            off += 6;
        }
    }

    private void skipCurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float[] _curCurvepts = this.curCurvepts;
        _curCurvepts[0] = this.cx0;
        _curCurvepts[1] = this.cy0;
        _curCurvepts[2] = x1;
        _curCurvepts[3] = y1;
        _curCurvepts[4] = x2;
        _curCurvepts[5] = y2;
        _curCurvepts[6] = x3;
        _curCurvepts[7] = y3;
        this.skipSomethingTo(8);
        this.cx0 = x3;
        this.cy0 = y3;
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        int outcode0 = this.cOutCode;
        if (this.clipRect != null) {
            int outcode2;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(x2, y2, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitQuad(this.cx0, this.cy0, x1, y1, x2, y2, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode2;
                    this.skipQuadTo(x1, y1, x2, y2);
                    return;
                }
            }
            this.cOutCode = outcode2;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._quadTo(x1, y1, x2, y2);
    }

    private void _quadTo(float x1, float y1, float x2, float y2) {
        float[] _curCurvepts = this.curCurvepts;
        TransformingPathConsumer2D.CurveBasicMonotonizer monotonizer = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, x1, y1, x2, y2);
        int nSplits = monotonizer.nbSplits;
        float[] mid = monotonizer.middle;
        int i = 0;
        int off = 0;
        while (i <= nSplits) {
            System.arraycopy(mid, off, _curCurvepts, 0, 8);
            this.somethingTo(6);
            ++i;
            off += 4;
        }
    }

    private void skipQuadTo(float x1, float y1, float x2, float y2) {
        float[] _curCurvepts = this.curCurvepts;
        _curCurvepts[0] = this.cx0;
        _curCurvepts[1] = this.cy0;
        _curCurvepts[2] = x1;
        _curCurvepts[3] = y1;
        _curCurvepts[4] = x2;
        _curCurvepts[5] = y2;
        this.skipSomethingTo(6);
        this.cx0 = x2;
        this.cy0 = y2;
    }

    @Override
    public void closePath() {
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            this.lineTo(this.sx0, this.sy0);
        }
        if (this.firstSegidx != 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx0, this.sy0);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx0, this.sy0);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Dasher does not use a native consumer");
    }

    static final class LengthIterator {
        private final float[][] recCurveStack;
        private final boolean[] sidesRight;
        private int curveType;
        private float nextT;
        private float lenAtNextT;
        private float lastT;
        private float lenAtLastT;
        private float lenAtLastSplit;
        private float lastSegLen;
        private int recLevel;
        private boolean done = true;
        private final float[] curLeafCtrlPolyLengths = new float[3];
        private int cachedHaveLowAcceleration = -1;
        private final float[] nextRoots = new float[4];
        private final float[] flatLeafCoefCache = new float[]{0.0f, 0.0f, -1.0f, 0.0f};

        LengthIterator() {
            this.recCurveStack = new float[17][8];
            this.sidesRight = new boolean[16];
            this.nextT = Float.MAX_VALUE;
            this.lenAtNextT = Float.MAX_VALUE;
            this.lenAtLastSplit = Float.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Float.MAX_VALUE;
        }

        void reset() {
        }

        void initializeIterationOnCurve(float[] pts, int type) {
            System.arraycopy(pts, 0, this.recCurveStack[0], 0, 8);
            this.curveType = type;
            this.recLevel = 0;
            this.lastT = 0.0f;
            this.lenAtLastT = 0.0f;
            this.nextT = 0.0f;
            this.lenAtNextT = 0.0f;
            this.goLeft();
            this.lenAtLastSplit = 0.0f;
            if (this.recLevel > 0) {
                this.sidesRight[0] = false;
                this.done = false;
            } else {
                this.sidesRight[0] = true;
                this.done = true;
            }
            this.lastSegLen = 0.0f;
        }

        private boolean haveLowAcceleration(float err) {
            if (this.cachedHaveLowAcceleration == -1) {
                float errLen3;
                float len3;
                float len1 = this.curLeafCtrlPolyLengths[0];
                float len2 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(len1, len2, err * len2)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(len2, len3 = this.curLeafCtrlPolyLengths[2], errLen3 = err * len3) && Helpers.within(len1, len3, errLen3))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        float next(float len) {
            float targetLength = this.lenAtLastSplit + len;
            while (this.lenAtNextT < targetLength) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0f;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = targetLength;
            float leaflen = this.lenAtNextT - this.lenAtLastT;
            float t = (targetLength - this.lenAtLastT) / leaflen;
            if (!this.haveLowAcceleration(0.05f)) {
                float d;
                float c;
                float b;
                float a;
                int n;
                float[] _flatLeafCoefCache = this.flatLeafCoefCache;
                if (_flatLeafCoefCache[2] < 0.0f) {
                    float x = this.curLeafCtrlPolyLengths[0];
                    float y = x + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        float z = y + this.curLeafCtrlPolyLengths[2];
                        _flatLeafCoefCache[0] = 3.0f * (x - y) + z;
                        _flatLeafCoefCache[1] = 3.0f * (y - 2.0f * x);
                        _flatLeafCoefCache[2] = 3.0f * x;
                        _flatLeafCoefCache[3] = -z;
                    } else if (this.curveType == 6) {
                        _flatLeafCoefCache[0] = 0.0f;
                        _flatLeafCoefCache[1] = y - 2.0f * x;
                        _flatLeafCoefCache[2] = 2.0f * x;
                        _flatLeafCoefCache[3] = -y;
                    }
                }
                if ((n = Helpers.cubicRootsInAB(a = _flatLeafCoefCache[0], b = _flatLeafCoefCache[1], c = _flatLeafCoefCache[2], d = t * _flatLeafCoefCache[3], this.nextRoots, 0, 0.0f, 1.0f)) == 1 && !Float.isNaN(this.nextRoots[0])) {
                    t = this.nextRoots[0];
                }
            }
            if ((t = t * (this.nextT - this.lastT) + this.lastT) >= 1.0f) {
                t = 1.0f;
                this.done = true;
            }
            this.lastSegLen = len;
            return t;
        }

        float totalLength() {
            while (!this.done) {
                this.goToNextLeaf();
            }
            this.reset();
            return this.lenAtNextT;
        }

        float lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            boolean[] _sides = this.sidesRight;
            int _recLevel = this.recLevel;
            --_recLevel;
            while (_sides[_recLevel]) {
                if (_recLevel == 0) {
                    this.recLevel = 0;
                    this.done = true;
                    return;
                }
                --_recLevel;
            }
            _sides[_recLevel] = true;
            System.arraycopy(this.recCurveStack[_recLevel++], 0, this.recCurveStack[_recLevel], 0, 8);
            this.recLevel = _recLevel;
            this.goLeft();
        }

        private void goLeft() {
            float len = this.onLeaf();
            if (len >= 0.0f) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (float)(1 << 16 - this.recLevel) * 1.5258789E-5f;
                this.lenAtNextT += len;
                this.flatLeafCoefCache[2] = -1.0f;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], this.recCurveStack[this.recLevel + 1], this.recCurveStack[this.recLevel], this.curveType);
                this.sidesRight[this.recLevel] = false;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private float onLeaf() {
            float[] curve = this.recCurveStack[this.recLevel];
            int _curveType = this.curveType;
            float polyLen = 0.0f;
            float x0 = curve[0];
            float y0 = curve[1];
            for (int i = 2; i < _curveType; i += 2) {
                float x1 = curve[i];
                float y1 = curve[i + 1];
                float len = Helpers.linelen(x0, y0, x1, y1);
                polyLen += len;
                this.curLeafCtrlPolyLengths[(i >> 1) - 1] = len;
                x0 = x1;
                y0 = y1;
            }
            float lineLen = Helpers.linelen(curve[0], curve[1], x0, y0);
            if (polyLen - lineLen < CURVE_LEN_ERR || this.recLevel == 16) {
                return (polyLen + lineLen) / 2.0f;
            }
            return -1.0f;
        }
    }
}

