/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import org.marlin.pisces.DPathConsumer2D;

final class DCollinearSimplifier
implements DPathConsumer2D {
    private static final int STATE_PREV_LINE = 0;
    private static final int STATE_PREV_POINT = 1;
    private static final int STATE_EMPTY = 2;
    private static final double EPS = 0.001;
    private DPathConsumer2D delegate;
    private int state;
    private double px1;
    private double py1;
    private double pdx;
    private double pdy;
    private double px2;
    private double py2;

    DCollinearSimplifier() {
    }

    public DCollinearSimplifier init(DPathConsumer2D delegate) {
        this.delegate = delegate;
        this.state = 2;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.delegate.pathDone();
        this.state = 2;
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.delegate.closePath();
        this.state = 2;
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(double x1, double y1, double xe, double ye) {
        this.emitStashedLine();
        this.delegate.quadTo(x1, y1, xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void curveTo(double x1, double y1, double x2, double y2, double xe, double ye) {
        this.emitStashedLine();
        this.delegate.curveTo(x1, y1, x2, y2, xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void moveTo(double xe, double ye) {
        this.emitStashedLine();
        this.delegate.moveTo(xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void lineTo(double xe, double ye) {
        if (this.state == 0) {
            double dx = xe - this.px2;
            double dy = ye - this.py2;
            if (dy == 0.0 && this.pdy == 0.0 && this.pdx * dx >= 0.0 || this.pdy * dy != 0.0 && this.pdx * dy - this.pdy * dx == 0.0) {
                this.px2 = xe;
                this.py2 = ye;
            } else {
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.pdx = dx;
                this.pdy = dy;
                this.px2 = xe;
                this.py2 = ye;
            }
        } else if (this.state == 1) {
            this.state = 0;
            this.pdx = xe - this.px1;
            this.pdy = ye - this.py1;
            this.px2 = xe;
            this.py2 = ye;
        } else if (this.state == 2) {
            this.delegate.lineTo(xe, ye);
            this.state = 1;
            this.px1 = xe;
            this.py1 = ye;
        }
    }

    private void emitStashedLine() {
        if (this.state == 0) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }
}

