/*
 * Decompiled with CFR 0.152.
 */
package org.marlin.pisces;

import sun.awt.geom.PathConsumer2D;

final class CollinearSimplifier
implements PathConsumer2D {
    private static final int STATE_PREV_LINE = 0;
    private static final int STATE_PREV_POINT = 1;
    private static final int STATE_EMPTY = 2;
    private static final float EPS = 0.001f;
    private PathConsumer2D delegate;
    private int state;
    private float px1;
    private float py1;
    private float pdx;
    private float pdy;
    private float px2;
    private float py2;

    CollinearSimplifier() {
    }

    public CollinearSimplifier init(PathConsumer2D delegate) {
        this.delegate = delegate;
        this.state = 2;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.delegate.pathDone();
        this.state = 2;
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.delegate.closePath();
        this.state = 2;
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(float x1, float y1, float xe, float ye) {
        this.emitStashedLine();
        this.delegate.quadTo(x1, y1, xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float xe, float ye) {
        this.emitStashedLine();
        this.delegate.curveTo(x1, y1, x2, y2, xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void moveTo(float xe, float ye) {
        this.emitStashedLine();
        this.delegate.moveTo(xe, ye);
        this.state = 1;
        this.px1 = xe;
        this.py1 = ye;
    }

    @Override
    public void lineTo(float xe, float ye) {
        if (this.state == 0) {
            float dx = xe - this.px2;
            float dy = ye - this.py2;
            if (dy == 0.0f && this.pdy == 0.0f && this.pdx * dx >= 0.0f || this.pdy * dy != 0.0f && this.pdx * dy - this.pdy * dx == 0.0f) {
                this.px2 = xe;
                this.py2 = ye;
            } else {
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.pdx = dx;
                this.pdy = dy;
                this.px2 = xe;
                this.py2 = ye;
            }
        } else if (this.state == 1) {
            this.state = 0;
            this.pdx = xe - this.px1;
            this.pdy = ye - this.py1;
            this.px2 = xe;
            this.py2 = ye;
        } else if (this.state == 2) {
            this.delegate.lineTo(xe, ye);
            this.state = 1;
            this.px1 = xe;
            this.py1 = ye;
        }
    }

    private void emitStashedLine() {
        if (this.state == 0) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }
}

