/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import javax.xml.namespace.QName;
import net.opengis.wfs20.PropertyType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class PropertyTypeBinding
extends AbstractComplexEMFBinding {
    public PropertyTypeBinding(Wfs20Factory factory) {
        super((EFactory)factory);
    }

    public QName getTarget() {
        return WFS.PropertyType;
    }

    public Class<?> getType() {
        return PropertyType.class;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        return value;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return super.parse(instance, node, value);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (WFS.Value.equals(name)) {
            return output -> {
                Object value = ((PropertyType)object).getValue();
                output.startElement("http://www.opengis.net/wfs/2.0", WFS.Value.getLocalPart(), "wfs:" + WFS.Value.getLocalPart(), new AttributesImpl());
                if (value instanceof Geometry) {
                    Encoder encoder = new Encoder((Configuration)new GMLConfiguration());
                    encoder.setInline(true);
                    encoder.encode(value, GML._Geometry, output);
                } else {
                    String s = value.toString();
                    output.characters(s.toCharArray(), 0, s.length());
                }
                output.endElement("http://www.opengis.net/wfs/2.0", WFS.Value.getLocalPart(), "wfs:" + WFS.Value.getLocalPart());
            };
        }
        return super.getProperty(object, name);
    }
}

