/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaStoreFactory;
import org.geowebcache.diskquota.jdbc.H2Dialect;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStore;
import org.geowebcache.diskquota.jdbc.SQLDialect;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.storage.DefaultStorageFinder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class JDBCQuotaStoreFactory
implements QuotaStoreFactory,
ApplicationContextAware {
    private static final Logger log = Logging.getLogger((String)JDBCQuotaStore.class.getName());
    private static final String CONFIGURATION_FILE_NAME = "geowebcache-diskquota-jdbc.xml";
    public static final String H2_STORE = "H2";
    public static final String JDBC_STORE = "JDBC";
    private ApplicationContext appContext;
    private ConfigurationResourceProvider defaultResourceProvider;

    public JDBCQuotaStoreFactory() {
    }

    public JDBCQuotaStoreFactory(ConfigurationResourceProvider resourceProvider) {
        this.defaultResourceProvider = resourceProvider;
    }

    public List<String> getSupportedStoreNames() {
        return Arrays.asList(H2_STORE, JDBC_STORE);
    }

    public QuotaStore getQuotaStore(ApplicationContext ctx, String quotaStoreName) throws ConfigurationException {
        DefaultStorageFinder cacheDirFinder = (DefaultStorageFinder)ctx.getBean("gwcDefaultStorageFinder");
        TilePageCalculator tilePageCalculator = (TilePageCalculator)ctx.getBean("gwcTilePageCalculator");
        if (H2_STORE.equals(quotaStoreName)) {
            return this.initializeH2Store(cacheDirFinder, tilePageCalculator);
        }
        if (JDBC_STORE.equals(quotaStoreName)) {
            return this.getJDBCStore(cacheDirFinder, tilePageCalculator);
        }
        return null;
    }

    private ConfigurationResourceProvider createResourceProvider(DefaultStorageFinder cacheDirFinder) throws ConfigurationException {
        return new XMLFileResourceProvider(CONFIGURATION_FILE_NAME, (WebApplicationContext)this.appContext, cacheDirFinder);
    }

    private QuotaStore getJDBCStore(DefaultStorageFinder cacheDirFinder, TilePageCalculator tilePageCalculator) throws ConfigurationException {
        JDBCConfiguration config = null;
        ConfigurationResourceProvider resourceProvider = this.defaultResourceProvider == null ? this.createResourceProvider(cacheDirFinder) : this.defaultResourceProvider;
        try {
            if (!resourceProvider.hasInput()) {
                throw new IllegalArgumentException("Unable to read JDBC configuration file: " + resourceProvider.getLocation());
            }
            config = JDBCConfiguration.load(resourceProvider.in());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read JDBC configuration file at " + resourceProvider.getId());
        }
        return this.getJDBCStore(cacheDirFinder, tilePageCalculator, config);
    }

    public QuotaStore getJDBCStore(ApplicationContext ctx, JDBCConfiguration config) throws ConfigurationException {
        DefaultStorageFinder cacheDirFinder = (DefaultStorageFinder)ctx.getBean("gwcDefaultStorageFinder");
        TilePageCalculator tilePageCalculator = (TilePageCalculator)ctx.getBean("gwcTilePageCalculator");
        return this.getJDBCStore(cacheDirFinder, tilePageCalculator, config);
    }

    private QuotaStore getJDBCStore(DefaultStorageFinder cacheDirFinder, TilePageCalculator tilePageCalculator, JDBCConfiguration config) throws ConfigurationException {
        JDBCConfiguration expandedConfig = config.clone(true);
        DataSource ds = this.getDataSource(expandedConfig);
        String dialectName = expandedConfig.getDialect();
        String dialectBeanName = dialectName + "QuotaDialect";
        Object bean = this.appContext.getBean(dialectBeanName);
        if (bean == null) {
            throw new ConfigurationException("Could not locate bean " + dialectBeanName + " for dialect " + dialectName + " in the Spring application context");
        }
        if (!(bean instanceof SQLDialect)) {
            throw new ConfigurationException("Bean " + dialectBeanName + " for dialect " + dialectName + " was found in the Spring application context, but it's not a SQLDialect object, instead it's a " + bean.getClass().getName());
        }
        SQLDialect dialect = (SQLDialect)bean;
        JDBCQuotaStore store = new JDBCQuotaStore(cacheDirFinder, tilePageCalculator);
        store.setDataSource(ds);
        store.setDialect(dialect);
        store.setSchema(expandedConfig.getSchema());
        store.initialize();
        return store;
    }

    protected DataSource getDataSource(JDBCConfiguration config) throws ConfigurationException {
        try {
            DataSource ds = null;
            if (config.getJNDISource() != null) {
                ds = (DataSource)GeoTools.jndiLookup((String)config.getJNDISource());
                if (ds == null) {
                    throw new ConfigurationException("Failed to get a datasource from: " + config.getJNDISource());
                }
            } else if (config.getConnectionPool() != null) {
                JDBCConfiguration.ConnectionPoolConfiguration cp = config.getConnectionPool();
                BasicDataSource bds = new BasicDataSource();
                bds.setDriverClassName(cp.getDriver());
                bds.setUrl(cp.getUrl());
                bds.setUsername(cp.getUsername());
                bds.setPassword(cp.getPassword());
                bds.setPoolPreparedStatements(true);
                bds.setMaxOpenPreparedStatements(cp.getMaxOpenPreparedStatements());
                bds.setMinIdle(cp.getMinConnections());
                bds.setMaxActive(cp.getMaxConnections());
                bds.setMaxWait((long)(cp.getConnectionTimeout() * 1000));
                bds.setValidationQuery(cp.getValidationQuery());
                ds = bds;
            } else {
                throw new IllegalArgumentException("JDBC configuration misses both JNDI source and connection pool");
            }
            Connection c = null;
            try {
                c = ds.getConnection();
            }
            catch (SQLException e) {
                throw new ConfigurationException("Failed to get a database connection: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (SQLException e) {
                        log.log(Level.FINE, "An error occurred while closing the test JDBC connection: " + e.getMessage(), e);
                    }
                }
            }
            return ds;
        }
        catch (NamingException e) {
            throw new ConfigurationException("Failed to locate the data source in JNDI", (Throwable)e);
        }
    }

    private QuotaStore initializeH2Store(DefaultStorageFinder cacheDirFinder, TilePageCalculator tilePageCalculator) throws ConfigurationException {
        DataSource ds = this.getH2DataSource(cacheDirFinder);
        JDBCQuotaStore store = new JDBCQuotaStore(cacheDirFinder, tilePageCalculator);
        store.setDataSource(ds);
        store.setDialect(new H2Dialect());
        store.initialize();
        return store;
    }

    private DataSource getH2DataSource(DefaultStorageFinder cacheDirFinder) throws ConfigurationException {
        File storeDirectory = new File(cacheDirFinder.getDefaultPath(), "diskquota_page_store_h2");
        storeDirectory.mkdirs();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("org.h2.Driver");
        String database = new File(storeDirectory, "diskquota").getAbsolutePath();
        dataSource.setUrl("jdbc:h2:" + database);
        dataSource.setUsername("sa");
        dataSource.setPoolPreparedStatements(true);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(-1);
        dataSource.setMaxWait(5000L);
        return dataSource;
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }
}

