/*
 * Decompiled with CFR 0.152.
 */
package wicketdnd.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Formattable;
import java.util.Formatter;

public class CollectionFormattable
implements Formattable {
    private Collection<?> collection;

    public CollectionFormattable(Object[] array) {
        this.collection = Arrays.asList(array);
    }

    public CollectionFormattable(Collection<?> collection) {
        this.collection = collection;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Object object : this.collection) {
            if (builder.length() > 1) {
                builder.append(",");
            }
            if (object == null) continue;
            if (object instanceof Number) {
                builder.append(object.toString());
                continue;
            }
            builder.append("'");
            builder.append(object.toString().replace("'", "\\'"));
            builder.append("'");
        }
        builder.append("]");
        formatter.format(builder.toString(), new Object[0]);
    }
}

