/*
 * Decompiled with CFR 0.152.
 */
package wicketdnd;

import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.resource.ResourceReference;
import wicketdnd.Operation;
import wicketdnd.Reject;
import wicketdnd.Transfer;
import wicketdnd.util.CollectionFormattable;
import wicketdnd.util.MarkupIdVisitor;

public class DragSource
extends Behavior {
    private static final long serialVersionUID = 1L;
    private Component component;
    private String selector = "undefined";
    private String initiateSelector = "undefined";
    private String cloneSelector = "undefined";
    private Set<Operation> operations;

    public DragSource(Operation ... operations) {
        this(Operation.of(operations));
    }

    public DragSource(Set<Operation> operations) {
        this.operations = operations;
    }

    public String[] getTypes() {
        return new String[]{""};
    }

    public DragSource drag(String selector) {
        this.selector = selector;
        if (this.initiateSelector.equals("undefined")) {
            this.initiateSelector = selector;
        }
        if (this.cloneSelector.equals("undefined")) {
            this.cloneSelector = selector;
        }
        return this;
    }

    public DragSource initiate(String selector) {
        this.initiateSelector = selector;
        return this;
    }

    public DragSource clone(String selector) {
        this.cloneSelector = selector;
        return this;
    }

    public final void bind(Component component) {
        this.component = component;
        component.setOutputMarkupId(true);
    }

    public String getPath() {
        return this.component.getPageRelativePath();
    }

    public int getBehaviorId() {
        return this.component.getBehaviorId((Behavior)this);
    }

    public final void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        this.renderDragHead(response);
    }

    private void renderDragHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Transfer.JS));
        String id = this.component.getMarkupId();
        String path = this.component.getPageRelativePath();
        int behavior = this.component.getBehaviorId((Behavior)this);
        String initJS = String.format("wicketdnd.dragSource('%s','%s','%s', %s,%s,{'select':'%s','initiate':'%s','clone':'%s'});", id, behavior, path, new CollectionFormattable(this.getOperations()), new CollectionFormattable(this.getTypes()), this.selector, this.initiateSelector, this.cloneSelector);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)initJS));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        tag.append("class", (CharSequence)"dnd-drag-source", " ");
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    final boolean hasOperation(Operation operation) {
        return this.getOperations().contains((Object)operation);
    }

    final void beforeDrop(Request request, Transfer transfer) throws Reject {
        Component drag = this.getDrag(request);
        this.onBeforeDrop(drag, transfer);
    }

    final void afterDrop(AjaxRequestTarget target, Transfer transfer) {
        this.onAfterDrop(target, transfer);
    }

    public void onBeforeDrop(Component drag, Transfer transfer) throws Reject {
        transfer.setData(drag.getDefaultModelObject());
    }

    public void onAfterDrop(AjaxRequestTarget target, Transfer transfer) {
    }

    private Component getDrag(Request request) {
        String drag = request.getRequestParameters().getParameterValue("drag").toString();
        return MarkupIdVisitor.getComponent((MarkupContainer)this.component, drag);
    }

    static final DragSource read(Page page, Request request) {
        String path = request.getRequestParameters().getParameterValue("path").toString();
        Component component = page.get(path);
        if (component == null) {
            throw new PageExpiredException("No drag source found " + path);
        }
        int behavior = request.getRequestParameters().getParameterValue("behavior").toInt();
        return (DragSource)component.getBehaviorById(behavior);
    }
}

