/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.util.URLs;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GETMAPValidator {
    public List<SAXException> validateGETMAP(InputStream xml) {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource schema = loader.get("data/capabilities/sld/GetMap.xsd");
        File schemaFile = schema.file();
        try {
            return this.validateGETMAP(xml, URLs.fileToUrl((File)schemaFile));
        }
        catch (Exception e) {
            ArrayList<SAXException> al = new ArrayList<SAXException>();
            al.add(new SAXException(e));
            return al;
        }
    }

    public static String getErrorMessage(InputStream xml, List<? extends Exception> errors) {
        return GETMAPValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    public static String getErrorMessage(Reader xml, List<? extends Exception> errors) {
        return SLDValidator.getErrorMessage(xml, errors);
    }

    public List<SAXException> validateGETMAP(InputStream xml, URL SchemaUrl) {
        return this.validateGETMAP(new InputSource(xml), SchemaUrl);
    }

    public List<SAXException> validateGETMAP(InputSource xml, ServletContext servContext) {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource schema = loader.get("data/capabilities/sld/GetMap.xsd");
        File schemaFile = schema.file();
        try {
            return this.validateGETMAP(xml, URLs.fileToUrl((File)schemaFile));
        }
        catch (Exception e) {
            ArrayList<SAXException> al = new ArrayList<SAXException>();
            al.add(new SAXException(e));
            return al;
        }
    }

    public List<SAXException> validateGETMAP(InputSource xml, URL SchemaUrl) {
        EntityResolverProvider provider = (EntityResolverProvider)GeoServerExtensions.bean(EntityResolverProvider.class);
        return ResponseUtils.validate(xml, SchemaUrl, true, provider.getEntityResolver());
    }
}

