/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.util.GeoServerDefaultLocale;
import org.geotools.util.GrowableInternationalString;
import org.opengis.util.InternationalString;

public class InternationalStringUtils {
    public static GrowableInternationalString growable(InternationalString internationalString) {
        GrowableInternationalString result = null;
        if (internationalString != null) {
            result = new GrowableInternationalString(internationalString);
        }
        return result;
    }

    public static GrowableInternationalString growable(InternationalString textTranslations, String textDefault) {
        if (textTranslations != null && textTranslations instanceof GrowableInternationalString) {
            GrowableInternationalString translations = (GrowableInternationalString)textTranslations;
            GrowableInternationalString combined = new GrowableInternationalString(textDefault);
            for (Locale locale : translations.getLocales()) {
                if (locale == null) continue;
                combined.add(locale, translations.toString(locale));
            }
            if (combined.toString(GeoServerDefaultLocale.get()) == null) {
                combined.add(GeoServerDefaultLocale.get(), textDefault);
            }
            return combined;
        }
        return new GrowableInternationalString(textDefault);
    }

    public static String getOrDefault(String string, InternationalString internationalString) {
        String result = string;
        if (result == null && internationalString != null) {
            result = internationalString.toString(GeoServerDefaultLocale.get());
        }
        return result;
    }

    public static String firstNonNull(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        for (String string : strings) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public static String firstNonBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        for (String string : strings) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            return string;
        }
        return null;
    }
}

