/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.util.DimensionWarning;

public class HTTPWarningAppender
extends AbstractDispatcherCallback {
    static final ThreadLocal<Set<DimensionWarning>> WARNINGS = ThreadLocal.withInitial(() -> new LinkedHashSet());

    public Request init(Request request) {
        WARNINGS.remove();
        return request;
    }

    public static void addWarning(DimensionWarning warning) {
        Set<DimensionWarning> warnings = WARNINGS.get();
        warnings.add(warning);
    }

    public static Set<DimensionWarning> getWarnings() {
        return Collections.unmodifiableSet(WARNINGS.get());
    }

    public static boolean anyMatch(Set<DimensionWarning.WarningType> types) {
        Objects.requireNonNull(types);
        return WARNINGS.get().stream().anyMatch(w -> types.contains((Object)w.getWarningType()));
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return super.operationExecuted(request, operation, result);
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        Set<DimensionWarning> warnings = WARNINGS.get();
        if (warnings != null && !warnings.isEmpty()) {
            HttpServletResponse httpResponse = request.getHttpResponse();
            for (DimensionWarning warning : warnings) {
                httpResponse.addHeader("Warning", warning.getHeader());
            }
        }
        return response;
    }

    public void finished(Request request) {
        WARNINGS.remove();
    }
}

