/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.AllowListEntityResolver;
import org.geotools.util.PreventLocalEntityResolver;
import org.xml.sax.EntityResolver;

public class EntityResolverProvider {
    private static final String ENTITY_RESOLUTION_ALLOWLIST = "ENTITY_RESOLUTION_ALLOWLIST";
    static String[] ALLOW_LIST = EntityResolverProvider.entityResolutionAllowlist();
    private static EntityResolver entityResolver = null;
    private final AllowListEntityResolver ALLOWLIST_ENTITY_RESOLVER;
    public static final EntityResolverProvider RESOLVE_DISABLED_PROVIDER = new EntityResolverProvider(null);
    private final GeoServer geoServer;

    public EntityResolverProvider(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.ALLOWLIST_ENTITY_RESOLVER = new AllowListEntityResolver(geoServer);
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        if (this.geoServer != null) {
            Boolean externalEntitiesEnabled = this.geoServer.getGlobal().isXmlExternalEntitiesEnabled();
            if (externalEntitiesEnabled != null && externalEntitiesEnabled.booleanValue()) {
                return null;
            }
            if (ALLOW_LIST != null) {
                return this.ALLOWLIST_ENTITY_RESOLVER;
            }
        }
        if (entityResolver != null) {
            return entityResolver;
        }
        return PreventLocalEntityResolver.INSTANCE;
    }

    public static String[] entityResolutionAllowlist() {
        String allowed = GeoServerExtensions.getProperty((String)ENTITY_RESOLUTION_ALLOWLIST);
        if (allowed == null || "*".equals(allowed.trim())) {
            return null;
        }
        if (!"".equals(allowed.trim())) {
            return new String[0];
        }
        return allowed.split("\\s*,\\s*|\\s+");
    }
}

