/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Execute;
import freemarker.template.utility.ObjectConstructor;
import java.util.Arrays;
import java.util.Collection;

public class TemplateUtils {
    public static Version FM_VERSION = Configuration.VERSION_2_3_0;
    private static final Collection<String> ILLEGAL_FREEMARKER_CLASSES = Arrays.asList(ObjectConstructor.class.getName(), Execute.class.getName(), "freemarker.template.utility.JythonRuntime");
    private static final Collection<String> LEGAL_FREEMARKER_CLASSES = Arrays.asList(new String[0]);

    public static Configuration getSafeConfiguration() {
        Configuration config = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        config.setNewBuiltinClassResolver((name, env, template) -> {
            if (ILLEGAL_FREEMARKER_CLASSES.stream().anyMatch(name::equals)) {
                throw new TemplateException(String.format("Class %s is not allowed in Freemarker templates", name), env);
            }
            if (LEGAL_FREEMARKER_CLASSES.stream().anyMatch(name::equals)) {
                try {
                    ClassUtil.forName((String)name);
                }
                catch (ClassNotFoundException e) {
                    throw new TemplateException((Exception)e, env);
                }
            }
            return TemplateClassResolver.SAFER_RESOLVER.resolve(name, env, template);
        });
        return config;
    }
}

