/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.template.SequenceMapModel;
import org.geoserver.template.TemplateUtils;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.MapEntry;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class FeatureWrapper
extends BeansWrapper {
    static Catalog gsCatalog;
    protected TemplateFeatureCollectionFactory templateFeatureCollectionFactory;
    protected static CopyTemplateFeatureCollectionFactory copyTemplateFeatureCollectionFactory;

    public FeatureWrapper() {
        super(TemplateUtils.FM_VERSION);
        this.setSimpleMapWrapper(true);
        this.templateFeatureCollectionFactory = copyTemplateFeatureCollectionFactory;
    }

    public FeatureWrapper(TemplateFeatureCollectionFactory templateFeatureCollectionFactory) {
        super(TemplateUtils.FM_VERSION);
        this.setSimpleMapWrapper(true);
        this.templateFeatureCollectionFactory = templateFeatureCollectionFactory;
    }

    private Catalog getCatalog() {
        try {
            gsCatalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
            return gsCatalog;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    protected String wrapValue(Object o) {
        return FeatureWrapper.valueToString(o);
    }

    private static String valueToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            if (o instanceof Timestamp) {
                return DateFormat.getDateTimeInstance().format((Date)o);
            }
            if (o instanceof Time) {
                return DateFormat.getTimeInstance().format((Date)o);
            }
            return DateFormat.getInstance().format((Date)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        if (o instanceof Geometry) {
            return String.valueOf(o);
        }
        return String.valueOf(o);
    }

    public String getPrefix(Name name) {
        Catalog cat = this.getCatalog();
        if (cat == null) {
            return "";
        }
        if (name.getNamespaceURI() == null) {
            return "";
        }
        NamespaceInfo ni = cat.getNamespaceByURI(name.getNamespaceURI());
        return ni == null ? "" : ni.getPrefix();
    }

    public String getNamespace(Name name) {
        return name.getNamespaceURI() == null ? "" : name.getNamespaceURI();
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object instanceof FeatureCollection) {
            SimpleHash map = new SimpleHash((ObjectWrapper)new DefaultObjectWrapper(TemplateUtils.FM_VERSION));
            map.put("features", (Object)this.templateFeatureCollectionFactory.createTemplateFeatureCollection((FeatureCollection)object, this));
            map.put("type", (Object)this.wrap(((FeatureCollection)object).getSchema()));
            return map;
        }
        if (object instanceof ComplexType) {
            return this.buildType((ComplexType)object);
        }
        if (object instanceof Feature) {
            return this.buildComplex((ComplexAttribute)((Feature)object));
        }
        return super.wrap(object);
    }

    private SimpleHash buildType(ComplexType ft) {
        LinkedHashMap attributeMap = new LinkedHashMap();
        Collection descriptors = ft.getDescriptors();
        for (PropertyDescriptor descr : descriptors) {
            HashMap<String, Object> attribute = new HashMap<String, Object>();
            attribute.put("name", descr.getName().getLocalPart());
            attribute.put("namespace", this.getNamespace(descr.getName()));
            attribute.put("prefix", this.getPrefix(descr.getName()));
            attribute.put("type", descr.getType().getBinding().getName());
            attribute.put("isGeometry", Geometry.class.isAssignableFrom(descr.getType().getBinding()));
            attributeMap.put(descr.getName().toString(), attribute);
        }
        SimpleHash map = new SimpleHash((ObjectWrapper)new DefaultObjectWrapper(TemplateUtils.FM_VERSION));
        map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
        map.put("name", (Object)ft.getName().getLocalPart());
        map.put("namespace", (Object)this.getNamespace(ft.getName()));
        map.put("prefix", (Object)this.getPrefix(ft.getName()));
        return map;
    }

    private SimpleHash buildComplex(ComplexAttribute att) {
        SimpleHash map = new SimpleHash((ObjectWrapper)new DefaultObjectWrapper(TemplateUtils.FM_VERSION));
        FeatureAttributesMap attributeMap = new FeatureAttributesMap(att);
        map.putAll((Map)attributeMap);
        Catalog cat = this.getCatalog();
        ResourceInfo info = null;
        if (cat != null && (info = cat.getResourceByName(att.getType().getName().getNamespaceURI(), att.getType().getName().getLocalPart(), ResourceInfo.class)) != null) {
            map.put("type", (Object)info);
        }
        if (info == null) {
            map.put("type", this.buildDummyFeatureTypeInfo(att));
        }
        if (att.getIdentifier() != null) {
            map.put("fid", att.getIdentifier().getID());
        } else {
            map.put("fid", (Object)"");
        }
        map.put("typeName", (Object)att.getType().getName().getLocalPart());
        map.put("attributes", (Object)new SequenceMapModel(attributeMap, this));
        if (att instanceof Feature) {
            map.put("bounds", (Object)((Feature)att).getBounds());
        }
        return map;
    }

    private Map<String, Object> buildDummyFeatureTypeInfo(ComplexAttribute f) {
        GeometryDescriptor gd;
        HashMap<String, Object> dummy = new HashMap<String, Object>();
        dummy.put("name", f.getType().getName().getLocalPart());
        dummy.put("namespace", this.getNamespace(f.getType().getName()));
        dummy.put("prefix", this.getPrefix(f.getType().getName()));
        dummy.put("title", "Layer: " + f.getType().getName().getLocalPart());
        dummy.put("abstract", "[No Abstract Provided]");
        dummy.put("description", "[No Description Provided]");
        dummy.put("keywords", new ArrayList());
        dummy.put("metadataLinks", new ArrayList());
        dummy.put("SRS", "[SRS]");
        if (f instanceof Feature && (gd = ((Feature)f).getType().getGeometryDescriptor()) != null) {
            dummy.put("nativeCRS", gd.getCoordinateReferenceSystem());
        }
        return dummy;
    }

    static {
        copyTemplateFeatureCollectionFactory = new CopyTemplateFeatureCollectionFactory();
    }

    protected static class CopyTemplateFeatureCollectionFactory
    implements TemplateFeatureCollectionFactory<CollectionModel> {
        protected CopyTemplateFeatureCollectionFactory() {
        }

        public CollectionModel createTemplateFeatureCollection(FeatureCollection collection, BeansWrapper wrapper) {
            return new CollectionModel((Collection)DataUtilities.list((FeatureCollection)collection), wrapper);
        }
    }

    public static interface TemplateFeatureCollectionFactory<T extends TemplateCollectionModel & TemplateSequenceModel> {
        public TemplateCollectionModel createTemplateFeatureCollection(FeatureCollection var1, BeansWrapper var2);
    }

    private class AttributeMap
    extends AbstractMap {
        private final Name attributeName;
        private final ComplexAttribute feature;
        private Property prop = null;
        private Set<MapEntry> entrySet;

        public AttributeMap(Name attributeName, ComplexAttribute feature) {
            this.attributeName = attributeName;
            this.feature = feature;
        }

        public AttributeMap(Name attributeName, ComplexAttribute feature, Property prop) {
            this(attributeName, feature);
            this.prop = prop;
        }

        @Override
        public int hashCode() {
            return this.attributeName.hashCode();
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                List substitutionGroup;
                Property property;
                this.entrySet = new LinkedHashSet<MapEntry>();
                ComplexType featureType = this.feature.getType();
                PropertyDescriptor attributeDescr = featureType.getDescriptor(this.attributeName);
                Property property2 = property = this.prop == null ? this.feature.getProperty(this.attributeName) : this.prop;
                if (property == null && (substitutionGroup = (List)attributeDescr.getUserData().get("substitutionGroup")) != null) {
                    Iterator it = substitutionGroup.iterator();
                    while (property == null && it.hasNext()) {
                        property = this.feature.getProperty(((AttributeDescriptor)it.next()).getName());
                    }
                    if (property != null) {
                        attributeDescr = property.getDescriptor();
                    }
                }
                this.entrySet.add(new MapEntry((Object)"isComplex", (Object)(property instanceof ComplexAttribute)));
                Object value = null;
                if (property instanceof ComplexAttribute) {
                    value = FeatureWrapper.this.buildComplex((ComplexAttribute)property);
                } else if (property != null) {
                    value = property.getValue();
                }
                this.entrySet.add(new DeferredValueEntry("value", value));
                this.entrySet.add(new MapEntry((Object)"name", (Object)this.attributeName.getLocalPart()));
                this.entrySet.add(new MapEntry((Object)"namespace", (Object)FeatureWrapper.this.getNamespace(this.attributeName)));
                this.entrySet.add(new MapEntry((Object)"prefix", (Object)FeatureWrapper.this.getPrefix(this.attributeName)));
                if (attributeDescr.getType() instanceof ComplexType) {
                    this.entrySet.add(new MapEntry((Object)"type", (Object)FeatureWrapper.this.buildType((ComplexType)attributeDescr.getType())));
                } else {
                    this.entrySet.add(new MapEntry((Object)"type", (Object)attributeDescr.getType().getBinding().getName()));
                }
                Object rawValue = value == null ? "" : value;
                boolean isGeometry = Geometry.class.isAssignableFrom(attributeDescr.getType().getBinding());
                this.entrySet.add(new MapEntry((Object)"isGeometry", (Object)isGeometry));
                this.entrySet.add(new MapEntry((Object)"rawValue", rawValue));
            }
            return this.entrySet;
        }

        private class DeferredValueEntry
        extends MapEntry<Object, Object> {
            private static final long serialVersionUID = -3919798947862996744L;

            public DeferredValueEntry(String key, Object attribute) {
                super((Object)key, attribute);
            }

            public Object getValue() {
                Object actualValue = super.getValue();
                String stringValue = FeatureWrapper.valueToString(actualValue);
                return stringValue;
            }
        }
    }

    private class FeatureAttributesMap
    extends AbstractMap {
        private Set<MapEntry> entrySet;
        private ComplexAttribute feature;

        public FeatureAttributesMap(ComplexAttribute feature) {
            this.feature = feature;
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new LinkedHashSet<MapEntry>();
                Collection types = this.feature.getType().getDescriptors();
                for (PropertyDescriptor type : types) {
                    Name attName = type.getName();
                    Object attributeMap = type.getMaxOccurs() > 1 ? this.getListMaps(attName) : new AttributeMap(attName, this.feature, this.feature.getProperty(attName));
                    this.entrySet.add(new MapEntry((Object)attName.getLocalPart(), attributeMap));
                }
            }
            return this.entrySet;
        }

        private List<Map> getListMaps(Name attName) {
            ArrayList<Map> listProps = new ArrayList<Map>();
            for (Property property : this.feature.getProperties(attName)) {
                listProps.add(new AttributeMap(attName, this.feature, property));
            }
            return listProps;
        }
    }
}

