/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.system.status;

import java.io.Serializable;
import java.time.LocalTime;
import org.geoserver.system.status.BaseSystemInfoCollector;
import org.geoserver.system.status.MetricInfo;
import org.geotools.util.Converters;

public class MetricValue
implements Serializable {
    private static final long serialVersionUID = 344784541680947799L;
    Object value;
    Boolean available;
    String description;
    String name;
    String unit;
    String category;
    String identifier;
    int priority;
    ValueHolder holder;

    public MetricValue(MetricInfo info) {
        this.priority = info.getPriority();
        this.name = info.name();
        this.description = info.getDescription();
        this.unit = info.getUnit();
        this.category = info.getCategory();
        this.identifier = info.name();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.holder = new ValueHolder(value);
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getCategory() {
        return this.category;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getValueUnit() {
        if (!this.available.booleanValue() || this.value == null) {
            return BaseSystemInfoCollector.DEFAULT_VALUE;
        }
        if (this.value instanceof Double || this.value instanceof Float) {
            Number numberValue = (Number)this.value;
            return String.format("%.2f %s", this.value instanceof Double ? numberValue.doubleValue() : (double)numberValue.floatValue(), this.unit);
        }
        if (this.unit != null && this.unit.equalsIgnoreCase("bytes")) {
            long bytes = (Long)Converters.convert((Object)this.value, Long.class);
            return MetricValue.humanReadableByteCount(bytes);
        }
        if (this.unit != null && this.unit.equalsIgnoreCase("sec")) {
            long seconds = (Long)Converters.convert((Object)this.value, Long.class);
            return LocalTime.MIN.plusSeconds(seconds).toString();
        }
        return String.format("%s %s", this.value, this.unit);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %siB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static class ValueHolder
    implements Serializable {
        private final Object valueOlder;

        public ValueHolder(Object valueOlder) {
            this.valueOlder = valueOlder;
        }

        public Object getValue() {
            return this.valueOlder;
        }
    }
}

