/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoleHierarchyHelper {
    Map<String, String> parentMappings;

    public RoleHierarchyHelper(Map<String, String> parentMappings) {
        this.parentMappings = parentMappings;
    }

    public boolean containsRole(String roleName) {
        return this.parentMappings.containsKey(roleName);
    }

    public String getParent(String roleName) {
        this.checkRole(roleName);
        String parentRole = this.parentMappings.get(roleName);
        if (roleName.equals(parentRole)) {
            this.cycleDetected(roleName, null);
        }
        return parentRole;
    }

    public List<String> getAncestors(String roleName) {
        this.checkRole(roleName);
        ArrayList<String> ancestors = new ArrayList<String>();
        this.fillAncestors(this.parentMappings.get(roleName), ancestors);
        return ancestors;
    }

    protected void fillAncestors(String roleName, List<String> ancestors) {
        if (roleName == null || roleName.length() == 0) {
            return;
        }
        ancestors.add(roleName);
        String parentName = this.parentMappings.get(roleName);
        if (ancestors.contains(parentName)) {
            this.cycleDetected(roleName, parentName);
        }
        this.fillAncestors(this.parentMappings.get(roleName), ancestors);
    }

    public List<String> getChildren(String roleName) {
        this.checkRole(roleName);
        ArrayList<String> children = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.parentMappings.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(roleName)) continue;
            if (roleName.equals(entry.getKey())) {
                this.cycleDetected(roleName, null);
            }
            children.add(entry.getKey());
        }
        return children;
    }

    public List<String> getDescendants(String roleName) {
        this.checkRole(roleName);
        HashSet<String> descendants = new HashSet<String>();
        this.fillDescendents(this.getChildren(roleName), descendants);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(descendants);
        return result;
    }

    protected void fillDescendents(List<String> children, Set<String> descendants) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (String childName : children) {
            if (descendants.contains(childName)) {
                this.cycleDetected(childName, null);
            }
            descendants.add(childName);
        }
        for (String childName : children) {
            List<String> grandchildren = this.getChildren(childName);
            this.fillDescendents(grandchildren, descendants);
        }
    }

    protected void checkRole(String roleName) {
        if (!this.parentMappings.containsKey(roleName)) {
            throw new RuntimeException("Not extistend role: " + roleName);
        }
    }

    protected void cycleDetected(String roleName1, String roleName2) {
        if (roleName2 == null) {
            throw new RuntimeException("Cycle detected for " + roleName1);
        }
        throw new RuntimeException("Cycle detected between " + roleName1 + " and " + roleName2);
    }

    public boolean isRoot(String roleName) {
        this.checkRole(roleName);
        return this.parentMappings.get(roleName) == null;
    }

    public List<String> getRootRoles() {
        ArrayList<String> result = new ArrayList<String>();
        for (String roleName : this.parentMappings.keySet()) {
            if (!this.isRoot(roleName)) continue;
            result.add(roleName);
        }
        return result;
    }

    public List<String> getLeafRoles() {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> leafRoles = new HashSet<String>();
        leafRoles.addAll(this.parentMappings.keySet());
        for (String parentRoleName : this.parentMappings.values()) {
            if (parentRoleName == null) continue;
            leafRoles.remove(parentRoleName);
        }
        result.addAll(leafRoles);
        return result;
    }

    public boolean isValidParent(String roleName, String parentName) {
        if (parentName == null || parentName.length() == 0) {
            return true;
        }
        if (roleName.equals(parentName)) {
            return false;
        }
        return !this.getDescendants(roleName).contains(parentName);
    }
}

