/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.LayerGroupStyleListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class LayerGroupContainmentCache
implements ApplicationListener {
    static final Function<? super String, ? extends Set<LayerGroupSummary>> CONCURRENT_SET_BUILDER = k -> Collections.newSetFromMap(new ConcurrentHashMap());
    static final Predicate<PublishedInfo> IS_LAYER = p -> p != null && p.getId() != null && p instanceof LayerInfo && ((LayerInfo)p).getResource() != null;
    static final Predicate<PublishedInfo> IS_GROUP = p -> p != null && p.getId() != null && p instanceof LayerGroupInfo;
    Map<String, LayerGroupSummary> groupCache = new ConcurrentHashMap<String, LayerGroupSummary>();
    Map<String, Set<LayerGroupSummary>> resourceContainmentCache = new ConcurrentHashMap<String, Set<LayerGroupSummary>>();
    private Catalog catalog;

    public LayerGroupContainmentCache(Catalog catalog) {
        this.catalog = catalog;
        catalog.addListener(new CatalogChangeListener());
        catalog.addListener(new LayerGroupStyleListener());
        this.buildLayerGroupCaches();
    }

    private void buildLayerGroupCaches() {
        this.groupCache.clear();
        this.resourceContainmentCache.clear();
        List<LayerGroupInfo> groups = this.catalog.getLayerGroups();
        for (LayerGroupInfo lg : groups) {
            this.addGroupInfo(lg);
        }
        for (LayerGroupInfo lg : groups) {
            this.registerContainedGroups(lg);
        }
    }

    private void registerContainedGroups(LayerGroupInfo lg) {
        lg.getLayers().stream().filter(IS_GROUP).forEach(p -> {
            String containerId = lg.getId();
            String containedId = p.getId();
            LayerGroupSummary container = this.groupCache.get(containerId);
            LayerGroupSummary contained = this.groupCache.get(containedId);
            if (container != null && contained != null) {
                contained.containerGroups.add(container);
            }
        });
    }

    private void addGroupInfo(LayerGroupInfo lg) {
        LayerGroupSummary groupData = new LayerGroupSummary(lg);
        this.groupCache.put(lg.getId(), groupData);
        lg.getLayers().stream().filter(IS_LAYER).forEach(p -> {
            String id = ((LayerInfo)p).getResource().getId();
            Set<LayerGroupSummary> containers = this.resourceContainmentCache.computeIfAbsent(id, CONCURRENT_SET_BUILDER);
            containers.add(groupData);
        });
    }

    private void clearGroupInfo(LayerGroupInfo lg) {
        LayerGroupSummary data = this.groupCache.remove(lg.getId());
        lg.getLayers().stream().filter(IS_LAYER).forEach(p -> {
            String rid;
            String string = rid = ((LayerInfo)p).getResource().getId();
            synchronized (string) {
                Set<LayerGroupSummary> containers = this.resourceContainmentCache.get(rid);
                if (containers != null) {
                    containers.remove(data);
                }
            }
        });
        for (LayerGroupSummary d : this.groupCache.values()) {
            d.containerGroups.remove(new LayerGroupSummary(lg));
        }
    }

    public Collection<LayerGroupSummary> getContainerGroupsFor(ResourceInfo resource) {
        String id = resource.getId();
        Set<LayerGroupSummary> groups = this.resourceContainmentCache.get(id);
        if (groups == null) {
            return Collections.emptyList();
        }
        HashSet<LayerGroupSummary> result = new HashSet<LayerGroupSummary>();
        for (LayerGroupSummary lg : groups) {
            this.collectContainers(lg, result);
        }
        return result;
    }

    public Collection<LayerGroupSummary> getContainerGroupsFor(LayerGroupInfo lg) {
        String id = lg.getId();
        if (id == null) {
            return Collections.emptyList();
        }
        LayerGroupSummary summary = this.groupCache.get(id);
        if (summary == null) {
            return Collections.emptyList();
        }
        HashSet<LayerGroupSummary> result = new HashSet<LayerGroupSummary>();
        for (LayerGroupSummary container : summary.getContainerGroups()) {
            this.collectContainers(container, result);
        }
        return result;
    }

    private void collectContainers(LayerGroupSummary lg, Set<LayerGroupSummary> groups) {
        if (!groups.contains(lg)) {
            if (lg.getMode() != LayerGroupInfo.Mode.SINGLE) {
                groups.add(lg);
            }
            for (LayerGroupSummary container : lg.containerGroups) {
                this.collectContainers(container, groups);
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        this.buildLayerGroupCaches();
    }

    final class CatalogChangeListener
    implements CatalogListener {
        CatalogChangeListener() {
        }

        @Override
        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
            if (event.getSource() instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)event.getSource();
                LayerGroupContainmentCache.this.addGroupInfo(lg);
                LayerGroupContainmentCache.this.registerContainedGroups(lg);
            }
        }

        @Override
        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
            if (event.getSource() instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)event.getSource();
                LayerGroupContainmentCache.this.clearGroupInfo(lg);
            }
        }

        @Override
        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
            int nameIdx;
            CatalogInfo source = event.getSource();
            if (source instanceof LayerGroupInfo) {
                int modeIdx;
                int layerIdx;
                int wsIdx;
                LayerGroupInfo lg = (LayerGroupInfo)event.getSource();
                int nameIdx2 = event.getPropertyNames().indexOf("name");
                if (nameIdx2 != -1) {
                    String newName = (String)event.getNewValues().get(nameIdx2);
                    this.updateGroupName(lg.getId(), newName);
                }
                if ((wsIdx = event.getPropertyNames().indexOf("workspace")) != -1) {
                    WorkspaceInfo newWorkspace = (WorkspaceInfo)event.getNewValues().get(wsIdx);
                    this.updateGroupWorkspace(lg.getId(), newWorkspace);
                }
                if ((layerIdx = event.getPropertyNames().indexOf("layers")) != -1) {
                    List oldLayers = (List)event.getOldValues().get(layerIdx);
                    List newLayers = (List)event.getNewValues().get(layerIdx);
                    this.updateContainedLayers(LayerGroupContainmentCache.this.groupCache.get(lg.getId()), oldLayers, newLayers);
                }
                if ((modeIdx = event.getPropertyNames().indexOf("mode")) != -1) {
                    LayerGroupInfo.Mode newMode = (LayerGroupInfo.Mode)((Object)event.getNewValues().get(modeIdx));
                    this.updateGroupMode(lg.getId(), newMode);
                }
            } else if (source instanceof WorkspaceInfo && (nameIdx = event.getPropertyNames().indexOf("name")) != -1) {
                String oldName = (String)event.getOldValues().get(nameIdx);
                String newName = (String)event.getNewValues().get(nameIdx);
                this.updateWorkspaceNames(oldName, newName);
            }
        }

        private void updateGroupMode(String id, LayerGroupInfo.Mode newMode) {
            LayerGroupSummary summary = LayerGroupContainmentCache.this.groupCache.get(id);
            summary.mode = newMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateContainedLayers(LayerGroupSummary groupSummary, List<PublishedInfo> oldLayers, List<PublishedInfo> newLayers) {
            String string;
            HashSet<PublishedInfo> removedLayers = new HashSet<PublishedInfo>(oldLayers);
            removedLayers.removeAll(newLayers);
            for (PublishedInfo removed : removedLayers) {
                if (removed instanceof LayerInfo) {
                    String resourceId = ((LayerInfo)removed).getResource().getId();
                    Set<LayerGroupSummary> containers = LayerGroupContainmentCache.this.resourceContainmentCache.get(resourceId);
                    if (containers == null) continue;
                    string = resourceId;
                    synchronized (string) {
                        containers.remove(groupSummary);
                        if (containers.isEmpty()) {
                            LayerGroupContainmentCache.this.resourceContainmentCache.remove(resourceId, containers);
                        }
                        continue;
                    }
                }
                LayerGroupInfo child = (LayerGroupInfo)removed;
                LayerGroupSummary summary = LayerGroupContainmentCache.this.groupCache.get(child.getId());
                if (summary == null) continue;
                summary.containerGroups.remove(groupSummary);
            }
            HashSet<PublishedInfo> addedLayers = new HashSet<PublishedInfo>(newLayers);
            addedLayers.removeAll(oldLayers);
            for (PublishedInfo added : addedLayers) {
                if (added instanceof LayerInfo) {
                    String resourceId;
                    string = resourceId = ((LayerInfo)added).getResource().getId();
                    synchronized (string) {
                        Set<LayerGroupSummary> containers = LayerGroupContainmentCache.this.resourceContainmentCache.computeIfAbsent(resourceId, CONCURRENT_SET_BUILDER);
                        containers.add(groupSummary);
                        continue;
                    }
                }
                LayerGroupInfo child = (LayerGroupInfo)added;
                LayerGroupSummary summary = LayerGroupContainmentCache.this.groupCache.get(child.getId());
                if (summary == null) continue;
                summary.containerGroups.add(groupSummary);
            }
        }

        private void updateGroupWorkspace(String id, WorkspaceInfo newWorkspace) {
            LayerGroupSummary summary = LayerGroupContainmentCache.this.groupCache.get(id);
            if (summary != null) {
                summary.workspace = newWorkspace == null ? null : newWorkspace.getName();
            }
        }

        private void updateGroupName(String id, String newName) {
            LayerGroupSummary summary = LayerGroupContainmentCache.this.groupCache.get(id);
            if (summary != null) {
                summary.name = newName;
            }
        }

        private void updateWorkspaceNames(String oldName, String newName) {
            LayerGroupContainmentCache.this.groupCache.values().stream().filter(lg -> Objects.equals(lg.workspace, oldName)).forEach(lg -> {
                lg.workspace = newName;
            });
        }

        @Override
        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        }

        @Override
        public void reloaded() {
            LayerGroupContainmentCache.this.buildLayerGroupCaches();
        }
    }

    public static class LayerGroupSummary {
        String id;
        String workspace;
        String name;
        LayerGroupInfo.Mode mode;
        Set<LayerGroupSummary> containerGroups;

        LayerGroupSummary(LayerGroupInfo lg) {
            this.id = lg.getId();
            this.workspace = lg.getWorkspace() != null ? lg.getWorkspace().getName() : null;
            this.name = lg.getName();
            this.mode = lg.getMode();
            this.containerGroups = CONCURRENT_SET_BUILDER.apply(null);
        }

        LayerGroupSummary(LayerGroupSummary other) {
            this.id = other.id;
            this.workspace = other.workspace;
            this.name = other.name;
            this.mode = other.mode;
            this.containerGroups = other.containerGroups;
        }

        public String getId() {
            return this.id;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public String getName() {
            return this.name;
        }

        public LayerGroupInfo.Mode getMode() {
            return this.mode;
        }

        public Set<LayerGroupSummary> getContainerGroups() {
            return this.containerGroups;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LayerGroupSummary)) {
                return false;
            }
            LayerGroupSummary other = (LayerGroupSummary)obj;
            return Objects.equals(this.id, other.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String[] getPath() {
            if (this.workspace == null) {
                return new String[]{this.name};
            }
            return new String[]{this.workspace, this.name};
        }

        public String toString() {
            return "LayerGroupSummary [id=" + this.id + ", workspace=" + this.workspace + ", name=" + this.name + ", mode=" + (Object)((Object)this.mode) + ", containerGroups=" + this.containerGroups + "]";
        }

        public String prefixedName() {
            if (this.workspace == null) {
                return this.name;
            }
            return this.workspace + ":" + this.name;
        }
    }
}

