/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.InMemorySecurityFilter;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WMTSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geoserver.security.impl.SecureTreeNode;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.springframework.security.core.Authentication;

public class DefaultResourceAccessManager
implements ResourceAccessManager {
    static final Logger LOGGER = Logging.getLogger(DefaultResourceAccessManager.class);
    static final Boolean RESOURCE_EQUALITY_FILTER_ENABLED = Boolean.getBoolean("geoserver.access.resourceEqualityFilterEnabled");
    SecureTreeNode root;
    DataAccessRuleDAO dao;
    Catalog rawCatalog;
    long lastLoaded = Long.MIN_VALUE;
    LayerGroupContainmentCache groupsCache;

    public DefaultResourceAccessManager(DataAccessRuleDAO dao, Catalog rawCatalog) {
        this.dao = dao;
        this.rawCatalog = rawCatalog;
        this.root = this.buildAuthorizationTree(dao);
    }

    public void setGroupsCache(LayerGroupContainmentCache groupsCache) {
        this.groupsCache = groupsCache;
    }

    public CatalogMode getMode() {
        return this.dao.getMode();
    }

    public boolean canAccess(Authentication user, WorkspaceInfo workspace, AccessMode mode) {
        this.checkPropertyFile();
        SecureTreeNode node = this.root.getDeepestNode(workspace.getName());
        if (node.canAccess(user, mode)) {
            return true;
        }
        return mode == AccessMode.READ && this.canAccessChild(node, user, mode);
    }

    private boolean canAccessChild(SecureTreeNode node, Authentication user, AccessMode mode) {
        if (node.canAccess(user, mode)) {
            return true;
        }
        for (SecureTreeNode child : node.getChildren().values()) {
            if (!this.canAccessChild(child, user, mode)) continue;
            return true;
        }
        return false;
    }

    public boolean canAccess(Authentication user, LayerInfo layer, AccessMode mode, boolean directAccess) {
        this.checkPropertyFile();
        if (layer.getResource() == null) {
            LOGGER.log(Level.FINE, "Layer " + layer + " has no attached resource, assuming it's possible to access it");
            return true;
        }
        return this.canAccess(user, layer.getResource(), mode, directAccess);
    }

    public boolean canAccess(Authentication user, ResourceInfo resource, AccessMode mode, boolean directAccess) {
        String workspace;
        this.checkPropertyFile();
        String resourceName = resource.getName();
        try {
            workspace = resource.getStore().getWorkspace().getName();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Errors occurred trying to gather workspace of resource " + resourceName);
            return true;
        }
        SecureTreeNode securityNode = this.root.getDeepestNode(workspace, resourceName);
        int catalogNodeDepth = securityNode.getDepth();
        boolean rulesAllowAccess = securityNode.canAccess(user, mode);
        if (catalogNodeDepth == SecureTreeNode.RESOURCE_DEPTH || !this.layerGroupContainmentCheckRequired()) {
            return rulesAllowAccess;
        }
        Collection<LayerGroupContainmentCache.LayerGroupSummary> containers = this.getLayerGroupsCache().getContainerGroupsFor(resource);
        if (containers.isEmpty()) {
            return rulesAllowAccess;
        }
        List groupOverrides = containers.stream().filter(sg -> {
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            if (gi == null) {
                return false;
            }
            SecureTreeNode node = this.getNodeForGroup(gi);
            return node != null && node.getDepth() > catalogNodeDepth || sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER;
        }).collect(Collectors.toList());
        if (!groupOverrides.isEmpty()) {
            rulesAllowAccess = groupOverrides.stream().anyMatch(sg -> {
                if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                    return false;
                }
                LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
                return gi != null && this.canAccess(user, gi, directAccess) && (!directAccess || this.allowsAccessViaNonOpaqueGroup(gi, resource));
            });
        }
        if (rulesAllowAccess) {
            return true;
        }
        return containers.stream().anyMatch(sg -> {
            if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                return false;
            }
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            if (gi == null) {
                return false;
            }
            SecureTreeNode node = this.getNodeForGroup(gi);
            return node == null && this.canAccess(user, gi, directAccess) && (!directAccess || this.allowsAccessViaNonOpaqueGroup(gi, resource));
        });
    }

    private boolean allowsAccessViaNonOpaqueGroup(LayerGroupInfo gi, ResourceInfo resource) {
        for (PublishedInfo pi : gi.getLayers()) {
            LayerGroupInfo lg;
            if (!(pi instanceof LayerInfo ? resource.equals(((LayerInfo)pi).getResource()) : (lg = (LayerGroupInfo)pi).getMode() != LayerGroupInfo.Mode.OPAQUE_CONTAINER && this.allowsAccessViaNonOpaqueGroup(lg, resource))) continue;
            return true;
        }
        return false;
    }

    private SecureTreeNode getNodeForGroup(LayerGroupInfo lg) {
        SecureTreeNode node;
        if (lg.getWorkspace() == null) {
            node = this.root.getNode(lg.getName());
        } else {
            String[] path = this.getLayerGroupPath(lg);
            node = this.root.getNode(path);
        }
        return node;
    }

    private boolean layerGroupContainmentCheckRequired() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return false;
        }
        String service = request.getService();
        return "WMS".equalsIgnoreCase(service) || "gwc".equalsIgnoreCase(service);
    }

    void checkPropertyFile() {
        this.rebuildAuthorizationTree(false);
    }

    private void rebuildAuthorizationTree(boolean force) {
        long daoLastModified = this.dao.getLastModified();
        if (this.lastLoaded < daoLastModified || force) {
            this.root = this.buildAuthorizationTree(this.dao);
            this.lastLoaded = daoLastModified;
        }
    }

    SecureTreeNode buildAuthorizationTree(DataAccessRuleDAO dao) {
        SecureTreeNode root = new SecureTreeNode();
        for (DataAccessRule rule : dao.getRules()) {
            SecureTreeNode node;
            String workspace = rule.getRoot();
            String layer = rule.getLayer();
            AccessMode accessMode = rule.getAccessMode();
            if ("*".equals(workspace)) {
                node = root;
            } else {
                SecureTreeNode ws = root.getChild(workspace);
                if (ws == null) {
                    ws = root.addChild(workspace);
                }
                if ("*".equals(layer)) {
                    node = ws;
                } else if (rule.isGlobalGroupRule()) {
                    node = ws;
                } else {
                    SecureTreeNode layerNode = ws.getChild(layer);
                    if (layerNode == null) {
                        layerNode = ws.addChild(layer);
                    }
                    node = layerNode;
                }
            }
            if (node.getAuthorizedRoles(accessMode) != null && node.getAuthorizedRoles(accessMode).size() > 0 && node != root) {
                LOGGER.warning("Rule " + rule + " is overriding another rule targetting the same resource");
            }
            node.setAuthorizedRoles(accessMode, new HashSet<String>(rule.getRoles()));
        }
        return root;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> context) {
        boolean directAccess = context == null || context.isEmpty();
        boolean read = this.canAccess(user, layer, AccessMode.READ, directAccess);
        boolean write = this.canAccess(user, layer, AccessMode.WRITE, directAccess);
        IncludeFilter readFilter = read ? Filter.INCLUDE : Filter.EXCLUDE;
        IncludeFilter writeFilter = write ? Filter.INCLUDE : Filter.EXCLUDE;
        return this.buildLimits(layer.getResource().getClass(), (Filter)readFilter, (Filter)writeFilter);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        boolean read = this.canAccess(user, resource, AccessMode.READ, true);
        boolean write = this.canAccess(user, resource, AccessMode.WRITE, true);
        IncludeFilter readFilter = read ? Filter.INCLUDE : Filter.EXCLUDE;
        IncludeFilter writeFilter = write ? Filter.INCLUDE : Filter.EXCLUDE;
        return this.buildLimits(resource.getClass(), (Filter)readFilter, (Filter)writeFilter);
    }

    DataAccessLimits buildLimits(Class<? extends ResourceInfo> resourceClass, Filter readFilter, Filter writeFilter) {
        CatalogMode mode = this.getMode();
        if ((readFilter == null || readFilter == Filter.INCLUDE) && (writeFilter == null || writeFilter == Filter.INCLUDE || WMSLayerInfo.class.isAssignableFrom(resourceClass) || WMTSLayerInfo.class.isAssignableFrom(resourceClass) || CoverageInfo.class.isAssignableFrom(resourceClass))) {
            return null;
        }
        if (FeatureTypeInfo.class.isAssignableFrom(resourceClass)) {
            return new VectorAccessLimits(mode, null, readFilter, null, writeFilter);
        }
        if (CoverageInfo.class.isAssignableFrom(resourceClass)) {
            return new CoverageAccessLimits(mode, readFilter, null, null);
        }
        if (WMSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMSAccessLimits(mode, readFilter, null, true);
        }
        if (WMTSLayerInfo.class.isAssignableFrom(resourceClass)) {
            return new WMTSAccessLimits(mode, readFilter, null);
        }
        LOGGER.log(Level.INFO, "Warning, adapting to generic access limits for unrecognized resource type " + resourceClass);
        return new DataAccessLimits(mode, readFilter);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        boolean readable = this.canAccess(user, workspace, AccessMode.READ);
        boolean writable = this.canAccess(user, workspace, AccessMode.WRITE);
        boolean adminable = this.canAccess(user, workspace, AccessMode.ADMIN);
        CatalogMode mode = this.getMode();
        if (readable && writable && !adminable && AdminRequest.get() == null) {
            return null;
        }
        return new WorkspaceAccessLimits(mode, readable, writable, adminable);
    }

    @Override
    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        return null;
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        boolean allowAccess = this.canAccess(user, layerGroup, containers == null || containers.isEmpty());
        return allowAccess ? null : new LayerGroupAccessLimits(this.getMode());
    }

    private boolean canAccess(Authentication user, LayerGroupInfo layerGroup, boolean directAccess) {
        Collection<LayerGroupContainmentCache.LayerGroupSummary> directContainers;
        String[] path = this.getLayerGroupPath(layerGroup);
        SecureTreeNode node = this.root.getDeepestNode(path);
        boolean catalogNodeAllowsAccess = node.canAccess(user, AccessMode.READ);
        boolean allowAccess = node != null && !catalogNodeAllowsAccess ? false : ((directContainers = this.getLayerGroupsCache().getContainerGroupsFor(layerGroup)).isEmpty() ? true : directContainers.stream().anyMatch(sg -> {
            if (directAccess && sg.getMode() == LayerGroupInfo.Mode.OPAQUE_CONTAINER) {
                return false;
            }
            LayerGroupInfo gi = this.rawCatalog.getLayerGroup(sg.getId());
            return gi != null && this.canAccess(user, gi, directAccess);
        }));
        return allowAccess;
    }

    private String[] getLayerGroupPath(LayerGroupInfo layerGroup) {
        if (layerGroup.getWorkspace() == null) {
            return new String[]{layerGroup.getName()};
        }
        return new String[]{layerGroup.getWorkspace().getName(), layerGroup.getName()};
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        if (this.getMode() == CatalogMode.CHALLENGE) {
            return InMemorySecurityFilter.buildUserAccessFilter(this, user);
        }
        if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("name", wsName));
            }
            if (exceptions.isEmpty()) {
                return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        if (PublishedInfo.class.isAssignableFrom(clazz) || ResourceInfo.class.isAssignableFrom(clazz) || CoverageInfo.class.isAssignableFrom(clazz)) {
            if (RESOURCE_EQUALITY_FILTER_ENABLED.booleanValue()) {
                return this.buildEqualityResourceFilter(user, clazz);
            }
            return this.buildInFunctionResourceFilter(user, clazz);
        }
        if (StyleInfo.class.isAssignableFrom(clazz) || LayerGroupInfo.class.isAssignableFrom(clazz)) {
            boolean rootAccess = this.canAccess(user, this.root);
            ArrayList<Filter> exceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> entry : this.root.getChildren().entrySet()) {
                String wsName = entry.getKey();
                SecureTreeNode node = entry.getValue();
                boolean nodeAccess = this.canAccess(user, node);
                if (nodeAccess == rootAccess) continue;
                if (rootAccess) {
                    exceptions.add(Predicates.notEqual("workspace.name", wsName));
                    continue;
                }
                exceptions.add(Predicates.equal("workspace.name", wsName));
            }
            if (exceptions.isEmpty()) {
                return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
            }
            return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
        }
        return InMemorySecurityFilter.buildUserAccessFilter(this, user);
    }

    private Filter buildEqualityResourceFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        boolean rootAccess = this.canAccess(user, this.root);
        ArrayList<Filter> exceptions = new ArrayList<Filter>();
        for (Map.Entry<String, SecureTreeNode> wsEntry : this.root.getChildren().entrySet()) {
            String wsName = wsEntry.getKey();
            SecureTreeNode wsNode = wsEntry.getValue();
            boolean wsAccess = this.canAccess(user, wsNode);
            ArrayList<Filter> layerExceptions = new ArrayList<Filter>();
            for (Map.Entry<String, SecureTreeNode> layerEntry : wsNode.getChildren().entrySet()) {
                boolean layerAccess;
                String layerName = layerEntry.getKey();
                SecureTreeNode layerNode = layerEntry.getValue();
                String prefixedName = wsName + ":" + layerName;
                Filter typeFilter = this.getTypeFilter(prefixedName, clazz);
                if (typeFilter == null || (layerAccess = this.canAccess(user, layerNode)) == wsAccess) continue;
                Filter prefixedNameFilter = Predicates.and(typeFilter, Predicates.equal("prefixedName", prefixedName));
                if (wsAccess) {
                    layerExceptions.add(Predicates.not(prefixedNameFilter));
                    continue;
                }
                layerExceptions.add(prefixedNameFilter);
            }
            Filter wsNamePropertyFilter = LayerGroupInfo.class.isAssignableFrom(clazz) ? Predicates.equal("workspace.name", wsName) : (LayerInfo.class.isAssignableFrom(clazz) ? Predicates.equal("resource.store.workspace.name", wsName) : (PublishedInfo.class.isAssignableFrom(clazz) ? Predicates.or(Predicates.and(Predicates.isInstanceOf(LayerInfo.class), Predicates.equal("resource.store.workspace.name", wsName)), Predicates.and(Predicates.isInstanceOf(PublishedInfo.class), Predicates.equal("workspace.name", wsName))) : Predicates.equal("store.workspace.name", wsName)));
            Filter wsFilter = null;
            if (rootAccess && !wsAccess) {
                wsFilter = Predicates.not(wsNamePropertyFilter);
            } else if (!rootAccess && wsAccess) {
                wsFilter = wsNamePropertyFilter;
            }
            if (layerExceptions.isEmpty()) {
                if (wsFilter == null) continue;
                exceptions.add(wsFilter);
                continue;
            }
            if (wsFilter != null) {
                layerExceptions.add(wsFilter);
            }
            Filter combined = wsAccess ? Predicates.and(layerExceptions) : Predicates.or(layerExceptions);
            exceptions.add(combined);
        }
        if (exceptions.isEmpty()) {
            return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
        }
        return rootAccess ? Predicates.and(exceptions) : Predicates.or(exceptions);
    }

    private Filter buildInFunctionResourceFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        boolean rootAccess = this.canAccess(user, this.root);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Map.Entry<String, SecureTreeNode> wsEntry : this.root.getChildren().entrySet()) {
            String wsName = wsEntry.getKey();
            if (this.rawCatalog.getWorkspaceByName(wsName) == null) continue;
            SecureTreeNode wsNode = wsEntry.getValue();
            boolean wsAccess = this.canAccess(user, wsNode);
            ArrayList<String> layerExceptionIds = new ArrayList<String>();
            for (Map.Entry<String, SecureTreeNode> layerEntry : wsNode.getChildren().entrySet()) {
                boolean layerAccess;
                String layerName = layerEntry.getKey();
                SecureTreeNode layerNode = layerEntry.getValue();
                String prefixedName = wsName + ":" + layerName;
                PublishedInfo published = this.rawCatalog.getLayerByName(prefixedName);
                if (published == null && (published = this.rawCatalog.getLayerGroupByName(prefixedName)) == null || (layerAccess = this.canAccess(user, layerNode)) == wsAccess) continue;
                if (clazz.isAssignableFrom(published.getClass())) {
                    layerExceptionIds.add(published.getId());
                    continue;
                }
                layerExceptionIds.add(((LayerInfo)published).getResource().getId());
            }
            Filter wsNamePropertyFilter = LayerGroupInfo.class.isAssignableFrom(clazz) ? Predicates.equal("workspace.name", wsName) : (LayerInfo.class.isAssignableFrom(clazz) ? Predicates.equal("resource.store.workspace.name", wsName) : (PublishedInfo.class.isAssignableFrom(clazz) ? Predicates.or(Predicates.and(Predicates.isInstanceOf(LayerInfo.class), Predicates.equal("resource.store.workspace.name", wsName)), Predicates.and(Predicates.isInstanceOf(PublishedInfo.class), Predicates.equal("workspace.name", wsName))) : Predicates.equal("store.workspace.name", wsName)));
            Filter wsFilter = null;
            if (rootAccess && !wsAccess) {
                wsFilter = Predicates.not(wsNamePropertyFilter);
            } else if (!rootAccess && wsAccess) {
                wsFilter = wsNamePropertyFilter;
            }
            if (layerExceptionIds.isEmpty()) {
                if (wsFilter == null) continue;
                filters.add(wsFilter);
                continue;
            }
            Filter id = Predicates.in("id", layerExceptionIds);
            if (wsAccess) {
                id = Predicates.not(id);
            }
            if (wsFilter != null) {
                filters.add(Predicates.and(wsFilter, id));
                continue;
            }
            filters.add(id);
        }
        if (filters.isEmpty()) {
            return rootAccess ? Filter.INCLUDE : Filter.EXCLUDE;
        }
        return rootAccess ? Predicates.and(filters) : Predicates.or(filters);
    }

    private Filter getTypeFilter(String prefixedName, Class<?> clazz) {
        if (this.rawCatalog.getLayerByName(prefixedName) != null) {
            if (clazz.equals(PublishedInfo.class)) {
                return Predicates.isInstanceOf(LayerInfo.class);
            }
            return Predicates.isInstanceOf(clazz);
        }
        if (this.rawCatalog.getLayerGroupByName(prefixedName) != null) {
            return Predicates.isInstanceOf(LayerGroupInfo.class);
        }
        return null;
    }

    private boolean canAccess(Authentication user, SecureTreeNode node) {
        boolean access = node.canAccess(user, AccessMode.READ);
        if (access && AdminRequest.get() != null) {
            return node.canAccess(user, AccessMode.ADMIN);
        }
        return access;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        return this.getAccessLimits(user, layer, Collections.emptyList());
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        return this.getAccessLimits(user, layerGroup, Collections.emptyList());
    }

    protected LayerGroupContainmentCache getLayerGroupsCache() {
        if (this.groupsCache == null) {
            this.groupsCache = (LayerGroupContainmentCache)GeoServerExtensions.bean(LayerGroupContainmentCache.class);
        }
        return this.groupsCache;
    }

    static class SecuredGroupSummary
    extends LayerGroupContainmentCache.LayerGroupSummary {
        private SecureTreeNode node;

        SecuredGroupSummary(LayerGroupContainmentCache.LayerGroupSummary origin, SecureTreeNode node) {
            super(origin);
            this.node = node;
        }

        boolean canAccess(Authentication user, AccessMode mode) {
            return this.node == null || this.node.canAccess(user, mode);
        }

        public SecureTreeNode getNode() {
            return this.node;
        }
    }
}

