/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerJ2eeBaseAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class GeoServerX509CertificateAuthenticationFilter
extends GeoServerJ2eeBaseAuthenticationFilter {
    private X509PrincipalExtractor principalExtractor;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.setPrincipalExtractor((X509PrincipalExtractor)new SubjectDnX509PrincipalExtractor());
    }

    @Override
    protected String getPreAuthenticatedPrincipalName(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate cert = certs[0];
        String principal = (String)this.principalExtractor.extractPrincipal(cert);
        if (principal != null && principal.trim().length() == 0) {
            principal = null;
        }
        return principal;
    }

    public X509PrincipalExtractor getPrincipalExtractor() {
        return this.principalExtractor;
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }
}

