/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class SecuredSimpleFeatureCollection
extends SecuredFeatureCollection<SimpleFeatureType, SimpleFeature>
implements SimpleFeatureCollection {
    SimpleFeatureType readSchema;

    SecuredSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, WrapperPolicy policy) {
        super(delegate, policy);
        if (policy.getLimits() instanceof VectorAccessLimits) {
            List<PropertyName> properties = ((VectorAccessLimits)policy.getLimits()).getReadAttributes();
            if (properties == null) {
                this.readSchema = (SimpleFeatureType)this.getSchema();
            } else {
                ArrayList<String> names = new ArrayList<String>();
                for (PropertyName property : properties) {
                    names.add(property.getPropertyName());
                }
                String[] nameArray = names.toArray(new String[names.size()]);
                try {
                    this.readSchema = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)this.getSchema()), (String[])nameArray);
                }
                catch (SchemaException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.readSchema = (SimpleFeatureType)this.getSchema();
        }
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return (SimpleFeatureCollection)super.sort(order);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return (SimpleFeatureCollection)super.subCollection(filter);
    }

    public SimpleFeatureIterator features() {
        return (SimpleFeatureIterator)super.features();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (this.canDelegate(visitor)) {
            this.delegate.accepts(visitor, progress);
        } else {
            super.accepts(visitor, progress);
        }
    }

    protected boolean canDelegate(FeatureVisitor visitor) {
        return ReTypingFeatureCollection.isTypeCompatible((FeatureVisitor)visitor, (SimpleFeatureType)this.readSchema);
    }
}

